/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.item.BedrockEnchantment;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.components.Rarity;
import org.geysermc.geyser.item.enchantment.Enchantment;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DyedItemColor;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemEnchantments;

public class Item {
    private static final Map<Block, Item> BLOCK_TO_ITEM = new HashMap<Block, Item>();
    private final String javaIdentifier;
    private int javaId = -1;
    private final int stackSize;
    private final int attackDamage;
    private final int maxDamage;
    private final Rarity rarity;
    private final boolean glint;

    public Item(String javaIdentifier, Builder builder) {
        this.javaIdentifier = MinecraftKey.key(javaIdentifier).asString().intern();
        this.stackSize = builder.stackSize;
        this.maxDamage = builder.maxDamage;
        this.attackDamage = builder.attackDamage;
        this.rarity = builder.rarity;
        this.glint = builder.glint;
    }

    public String javaIdentifier() {
        return this.javaIdentifier;
    }

    public int javaId() {
        return this.javaId;
    }

    public int maxDamage() {
        return this.maxDamage;
    }

    public int attackDamage() {
        return this.attackDamage;
    }

    public int maxStackSize() {
        return this.stackSize;
    }

    public Rarity rarity() {
        return this.rarity;
    }

    public boolean glint() {
        return this.glint;
    }

    public boolean isValidRepairItem(Item other) {
        return false;
    }

    public ItemData.Builder translateToBedrock(int count, DataComponents components, ItemMapping mapping, ItemMappings mappings) {
        if (this == Items.AIR || count <= 0) {
            return ItemData.builder();
        }
        ItemData.Builder builder = ItemData.builder().definition(mapping.getBedrockDefinition()).damage(mapping.getBedrockData()).count(count);
        ItemTranslator.translateCustomItem(components, builder, mapping);
        return builder;
    }

    public @NonNull GeyserItemStack translateToJava(@NonNull ItemData itemData, @NonNull ItemMapping mapping, @NonNull ItemMappings mappings) {
        return GeyserItemStack.of(this.javaId, itemData.getCount());
    }

    public ItemMapping toBedrockDefinition(DataComponents components, ItemMappings mappings) {
        return mappings.getMapping(this.javaId);
    }

    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull BedrockItemBuilder builder) {
        Integer repairCost;
        Integer damage;
        List<Component> loreComponents = components.get(DataComponentType.LORE);
        if (loreComponents != null && components.get(DataComponentType.HIDE_TOOLTIP) == null) {
            List<String> lore = builder.getOrCreateLore();
            for (Component loreComponent : loreComponents) {
                lore.add(MessageTranslator.convertMessage(loreComponent, session.locale()));
            }
        }
        if ((damage = components.get(DataComponentType.DAMAGE)) != null) {
            builder.setDamage(damage);
        }
        ArrayList<NbtMap> enchantNbtList = new ArrayList<NbtMap>();
        ItemEnchantments enchantments = components.get(DataComponentType.ENCHANTMENTS);
        if (enchantments != null) {
            for (Map.Entry<Integer, Integer> enchantment : enchantments.getEnchantments().entrySet()) {
                NbtMap enchantNbt = this.remapEnchantment(session, enchantment.getKey(), enchantment.getValue(), builder);
                if (enchantNbt == null) continue;
                enchantNbtList.add(enchantNbt);
            }
        }
        if (!enchantNbtList.isEmpty()) {
            builder.putList("ench", NbtType.COMPOUND, enchantNbtList);
        }
        if ((repairCost = components.get(DataComponentType.REPAIR_COST)) != null) {
            builder.putInt("RepairCost", repairCost);
        }
        builder.putInt("GeyserHash", components.hashCode());
    }

    public void translateNbtToJava(@NonNull GeyserSession session, @NonNull NbtMap bedrockTag, @NonNull DataComponents components, @NonNull ItemMapping mapping) {
    }

    protected final @Nullable NbtMap remapEnchantment(GeyserSession session, int enchantId, int level, BedrockItemBuilder builder) {
        Enchantment enchantment = session.getRegistryCache().enchantments().byId(enchantId);
        if (enchantment == null) {
            GeyserImpl.getInstance().getLogger().debug("Unknown Java enchantment while NBT item translating: " + enchantId);
            return null;
        }
        BedrockEnchantment bedrockEnchantment = enchantment.bedrockEnchantment();
        if (bedrockEnchantment == null) {
            String enchantmentTranslation = MinecraftLocale.getLocaleString(enchantment.description(), session.locale());
            this.addJavaOnlyEnchantment(session, builder, enchantmentTranslation, level);
            return null;
        }
        return NbtMap.builder().putShort("id", (short)bedrockEnchantment.ordinal()).putShort("lvl", (short)level).build();
    }

    private void addJavaOnlyEnchantment(GeyserSession session, BedrockItemBuilder builder, String enchantmentName, int level) {
        String lvlTranslation = MinecraftLocale.getLocaleString("enchantment.level." + level, session.locale());
        builder.getOrCreateLore().add(0, "\u00a7r\u00a77" + enchantmentName + " " + lvlTranslation);
    }

    protected final void translateDyedColor(DataComponents components, BedrockItemBuilder builder) {
        DyedItemColor dyedItemColor = components.get(DataComponentType.DYED_COLOR);
        if (dyedItemColor != null) {
            builder.putInt("customColor", dyedItemColor.getRgb());
        }
    }

    public boolean ignoreDamage() {
        return false;
    }

    public GeyserItemStack newItemStack(int count, DataComponents components) {
        return GeyserItemStack.of(this.javaId, count, components);
    }

    public void setJavaId(int javaId) {
        if (this.javaId != -1) {
            throw new RuntimeException("Item ID has already been set!");
        }
        this.javaId = javaId;
    }

    public String toString() {
        return "Item{javaIdentifier='" + this.javaIdentifier + "', javaId=" + this.javaId + "}";
    }

    public static @NonNull Item byBlock(Block block) {
        return BLOCK_TO_ITEM.getOrDefault(block, Items.AIR);
    }

    protected static void registerBlock(Block block, Item item) {
        BLOCK_TO_ITEM.put(block, item);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int stackSize = 64;
        private int maxDamage;
        private int attackDamage;
        private Rarity rarity = Rarity.COMMON;
        private boolean glint = false;

        public Builder stackSize(int stackSize) {
            this.stackSize = stackSize;
            return this;
        }

        public Builder attackDamage(double attackDamage) {
            this.attackDamage = (int)attackDamage;
            return this;
        }

        public Builder maxDamage(int maxDamage) {
            this.maxDamage = maxDamage;
            return this;
        }

        public Builder rarity(Rarity rarity) {
            this.rarity = rarity;
            return this;
        }

        public Builder glint(boolean glintOverride) {
            this.glint = glintOverride;
            return this;
        }

        private Builder() {
        }
    }
}

