/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.attribute;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.AttributeData;

public enum GeyserAttributeType {
    FOLLOW_RANGE("minecraft:generic.follow_range", "minecraft:follow_range", 0.0f, 2048.0f, 32.0f),
    KNOCKBACK_RESISTANCE("minecraft:generic.knockback_resistance", "minecraft:knockback_resistance", 0.0f, 1.0f, 0.0f),
    MOVEMENT_SPEED("minecraft:generic.movement_speed", "minecraft:movement", 0.0f, 1024.0f, 0.1f),
    FLYING_SPEED("minecraft:generic.flying_speed", "minecraft:movement", 0.0f, 1024.0f, 0.4f),
    ATTACK_DAMAGE("minecraft:generic.attack_damage", "minecraft:attack_damage", 0.0f, 2048.0f, 1.0f),
    HORSE_JUMP_STRENGTH("minecraft:horse.jump_strength", "minecraft:horse.jump_strength", 0.0f, 2.0f, 0.7f),
    LUCK("minecraft:generic.luck", "minecraft:luck", -1024.0f, 1024.0f, 0.0f),
    ARMOR("minecraft:generic.armor", null, 0.0f, 30.0f, 0.0f),
    ARMOR_TOUGHNESS("minecraft:generic.armor_toughness", null, 0.0f, 20.0f, 0.0f),
    ATTACK_KNOCKBACK("minecraft:generic.attack_knockback", null, 1.5f, Float.MAX_VALUE, 0.0f),
    ATTACK_SPEED("minecraft:generic.attack_speed", null, 0.0f, 1024.0f, 4.0f),
    MAX_HEALTH("minecraft:generic.max_health", null, 0.0f, 1024.0f, 20.0f),
    SCALE("minecraft:generic.scale", null, 0.0625f, 16.0f, 1.0f),
    BLOCK_INTERACTION_RANGE("minecraft:player.block_interaction_range", null, 0.0f, 64.0f, 4.5f),
    ABSORPTION(null, "minecraft:absorption", 0.0f, 1024.0f, 0.0f),
    EXHAUSTION(null, "minecraft:player.exhaustion", 0.0f, 5.0f, 0.0f),
    EXPERIENCE(null, "minecraft:player.experience", 0.0f, 1.0f, 0.0f),
    EXPERIENCE_LEVEL(null, "minecraft:player.level", 0.0f, 24791.0f, 0.0f),
    HEALTH(null, "minecraft:health", 0.0f, 1024.0f, 20.0f),
    HUNGER(null, "minecraft:player.hunger", 0.0f, 20.0f, 20.0f),
    SATURATION(null, "minecraft:player.saturation", 0.0f, 20.0f, 20.0f);

    private final String javaIdentifier;
    private final String bedrockIdentifier;
    private final float minimum;
    private final float maximum;
    private final float defaultValue;

    public AttributeData getAttribute() {
        return this.getAttribute(this.defaultValue);
    }

    public AttributeData getAttribute(float value) {
        return this.getAttribute(value, this.maximum);
    }

    public @Nullable AttributeData getAttribute(float value, float maximum) {
        if (this.bedrockIdentifier == null) {
            return null;
        }
        return new AttributeData(this.bedrockIdentifier, this.minimum, maximum, value, this.defaultValue);
    }

    public String getJavaIdentifier() {
        return this.javaIdentifier;
    }

    public String getBedrockIdentifier() {
        return this.bedrockIdentifier;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    private GeyserAttributeType(String javaIdentifier, String bedrockIdentifier, float minimum, float maximum, float defaultValue) {
        this.javaIdentifier = javaIdentifier;
        this.bedrockIdentifier = bedrockIdentifier;
        this.minimum = minimum;
        this.maximum = maximum;
        this.defaultValue = defaultValue;
    }
}

