/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.level.map.MapData;
import org.geysermc.mcprotocollib.protocol.data.game.level.map.MapIcon;
import org.geysermc.mcprotocollib.protocol.data.game.level.map.MapIconType;

public class ClientboundMapItemDataPacket
implements MinecraftPacket {
    private final int mapId;
    private final byte scale;
    private final boolean locked;
    @lombok.NonNull
    private final MapIcon[] icons;
    private final MapData data;

    public ClientboundMapItemDataPacket(int mapId, byte scale, boolean locked, @lombok.NonNull MapIcon[] icons) {
        this(mapId, scale, locked, icons, null);
        if (icons == null) {
            throw new NullPointerException("icons is marked non-null but is null");
        }
    }

    public ClientboundMapItemDataPacket(ByteBuf in, MinecraftCodecHelper helper) {
        short columns;
        short x;
        this.mapId = helper.readVarInt(in);
        this.scale = in.readByte();
        this.locked = in.readBoolean();
        boolean hasIcons = in.readBoolean();
        this.icons = new MapIcon[hasIcons ? helper.readVarInt(in) : 0];
        if (hasIcons) {
            for (int index = 0; index < this.icons.length; ++index) {
                int type = helper.readVarInt(in);
                x = in.readByte();
                byte z = in.readByte();
                byte rotation = in.readByte();
                Component displayName = helper.readNullable(in, helper::readComponent);
                this.icons[index] = new MapIcon(x, z, MapIconType.from(type), rotation, displayName);
            }
        }
        if ((columns = in.readUnsignedByte()) > 0) {
            short rows = in.readUnsignedByte();
            x = in.readUnsignedByte();
            short y = in.readUnsignedByte();
            byte[] data = helper.readByteArray(in);
            this.data = new MapData(columns, rows, x, y, data);
        } else {
            this.data = null;
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.mapId);
        out.writeByte(this.scale);
        out.writeBoolean(this.locked);
        if (this.icons.length != 0) {
            out.writeBoolean(true);
            helper.writeVarInt(out, this.icons.length);
            for (MapIcon icon : this.icons) {
                int type = icon.getIconType().ordinal();
                helper.writeVarInt(out, type);
                out.writeByte(icon.getCenterX());
                out.writeByte(icon.getCenterZ());
                out.writeByte(icon.getIconRotation());
                helper.writeNullable(out, icon.getDisplayName(), helper::writeComponent);
            }
        } else {
            out.writeBoolean(false);
        }
        if (this.data != null && this.data.getColumns() != 0) {
            out.writeByte(this.data.getColumns());
            out.writeByte(this.data.getRows());
            out.writeByte(this.data.getX());
            out.writeByte(this.data.getY());
            helper.writeVarInt(out, this.data.getData().length);
            out.writeBytes(this.data.getData());
        } else {
            out.writeByte(0);
        }
    }

    public int getMapId() {
        return this.mapId;
    }

    public byte getScale() {
        return this.scale;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @lombok.NonNull
    public MapIcon[] getIcons() {
        return this.icons;
    }

    public MapData getData() {
        return this.data;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundMapItemDataPacket)) {
            return false;
        }
        ClientboundMapItemDataPacket other = (ClientboundMapItemDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMapId() != other.getMapId()) {
            return false;
        }
        if (this.getScale() != other.getScale()) {
            return false;
        }
        if (this.isLocked() != other.isLocked()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIcons(), other.getIcons())) {
            return false;
        }
        MapData this$data = this.getData();
        MapData other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundMapItemDataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMapId();
        result = result * 59 + this.getScale();
        result = result * 59 + (this.isLocked() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getIcons());
        MapData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundMapItemDataPacket(mapId=" + this.getMapId() + ", scale=" + this.getScale() + ", locked=" + this.isLocked() + ", icons=" + Arrays.deepToString(this.getIcons()) + ", data=" + this.getData() + ")";
    }

    public @NonNull ClientboundMapItemDataPacket withMapId(int mapId) {
        return this.mapId == mapId ? this : new ClientboundMapItemDataPacket(mapId, this.scale, this.locked, this.icons, this.data);
    }

    public @NonNull ClientboundMapItemDataPacket withScale(byte scale) {
        return this.scale == scale ? this : new ClientboundMapItemDataPacket(this.mapId, scale, this.locked, this.icons, this.data);
    }

    public @NonNull ClientboundMapItemDataPacket withLocked(boolean locked) {
        return this.locked == locked ? this : new ClientboundMapItemDataPacket(this.mapId, this.scale, locked, this.icons, this.data);
    }

    public @NonNull ClientboundMapItemDataPacket withIcons(@lombok.NonNull MapIcon[] icons) {
        if (icons == null) {
            throw new NullPointerException("icons is marked non-null but is null");
        }
        return this.icons == icons ? this : new ClientboundMapItemDataPacket(this.mapId, this.scale, this.locked, icons, this.data);
    }

    public @NonNull ClientboundMapItemDataPacket withData(MapData data) {
        return this.data == data ? this : new ClientboundMapItemDataPacket(this.mapId, this.scale, this.locked, this.icons, data);
    }

    public ClientboundMapItemDataPacket(int mapId, byte scale, boolean locked, @lombok.NonNull MapIcon[] icons, MapData data) {
        if (icons == null) {
            throw new NullPointerException("icons is marked non-null but is null");
        }
        this.mapId = mapId;
        this.scale = scale;
        this.locked = locked;
        this.icons = icons;
        this.data = data;
    }
}

