/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.item.BedrockEnchantment;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.BlockTag;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.util.ItemUtils;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public final class BlockUtils {
    private static boolean correctTool(GeyserSession session, Block block, String itemToolType) {
        return switch (itemToolType) {
            case "axe" -> session.getTagCache().is(BlockTag.MINEABLE_AXE, block);
            case "hoe" -> session.getTagCache().is(BlockTag.MINEABLE_HOE, block);
            case "pickaxe" -> session.getTagCache().is(BlockTag.MINEABLE_PICKAXE, block);
            case "shears" -> {
                if (session.getTagCache().is(BlockTag.LEAVES, block) || session.getTagCache().is(BlockTag.WOOL, block)) {
                    yield true;
                }
                yield false;
            }
            case "shovel" -> session.getTagCache().is(BlockTag.MINEABLE_SHOVEL, block);
            case "sword" -> {
                if (block == Blocks.COBWEB) {
                    yield true;
                }
                yield false;
            }
            default -> {
                session.getGeyser().getLogger().warning("Unknown tool type: " + itemToolType);
                yield false;
            }
        };
    }

    private static double toolBreakTimeBonus(String toolType, String toolTier, boolean isShearsEffective) {
        if (toolType.equals("shears")) {
            return isShearsEffective ? 5.0 : 15.0;
        }
        if (toolType.isEmpty()) {
            return 1.0;
        }
        return switch (toolTier) {
            case "wooden" -> 2.0;
            case "stone" -> 4.0;
            case "iron" -> 6.0;
            case "diamond" -> 8.0;
            case "netherite" -> 9.0;
            case "golden" -> 12.0;
            default -> 1.0;
        };
    }

    private static boolean canToolTierBreakBlock(GeyserSession session, Block block, String toolTier) {
        if (toolTier.equals("netherite") || toolTier.equals("diamond")) {
            return true;
        }
        switch (toolTier) {
            default: {
                if (session.getTagCache().is(BlockTag.NEEDS_STONE_TOOL, block)) {
                    return false;
                }
            }
            case "stone": {
                if (!session.getTagCache().is(BlockTag.NEEDS_IRON_TOOL, block)) break;
                return false;
            }
            case "iron": 
        }
        return !session.getTagCache().is(BlockTag.NEEDS_DIAMOND_TOOL, block);
    }

    private static double calculateBreakTime(double blockHardness, String toolTier, boolean canHarvestWithHand, boolean correctTool, boolean canTierMineBlock, String toolType, boolean isShearsEffective, int toolEfficiencyLevel, int hasteLevel, int miningFatigueLevel, boolean insideOfWaterWithoutAquaAffinity, boolean onGround) {
        double baseTime = (correctTool && canTierMineBlock || canHarvestWithHand ? 1.5 : 5.0) * blockHardness;
        double speed = 1.0 / baseTime;
        if (correctTool) {
            speed *= BlockUtils.toolBreakTimeBonus(toolType, toolTier, isShearsEffective);
            speed += toolEfficiencyLevel == 0 ? 0.0 : (double)(toolEfficiencyLevel * toolEfficiencyLevel + 1);
        }
        speed *= 1.0 + 0.2 * (double)hasteLevel;
        switch (miningFatigueLevel) {
            case 0: {
                break;
            }
            case 1: {
                speed -= speed * 0.7;
                break;
            }
            case 2: {
                speed -= speed * 0.91;
                break;
            }
            case 3: {
                speed -= speed * 0.9973;
                break;
            }
            default: {
                speed -= speed * 0.99919;
            }
        }
        if (insideOfWaterWithoutAquaAffinity) {
            speed *= 0.2;
        }
        if (!onGround) {
            speed *= 0.2;
        }
        return 1.0 / speed;
    }

    public static double getBreakTime(GeyserSession session, Block block, ItemMapping item, @Nullable DataComponents components, boolean isSessionPlayer) {
        boolean isShearsEffective = session.getTagCache().is(BlockTag.LEAVES, block) || session.getTagCache().is(BlockTag.WOOL, block);
        boolean canHarvestWithHand = !block.requiresCorrectToolForDrops();
        String toolType = "";
        String toolTier = "";
        boolean correctTool = false;
        boolean toolCanBreak = false;
        if (item.isTool()) {
            toolType = item.getToolType();
            toolTier = item.getToolTier();
            correctTool = BlockUtils.correctTool(session, block, toolType);
            toolCanBreak = BlockUtils.canToolTierBreakBlock(session, block, toolTier);
        }
        int toolEfficiencyLevel = ItemUtils.getEnchantmentLevel(session, components, BedrockEnchantment.EFFICIENCY);
        int hasteLevel = 0;
        int miningFatigueLevel = 0;
        if (!isSessionPlayer) {
            return BlockUtils.calculateBreakTime(block.destroyTime(), toolTier, canHarvestWithHand, correctTool, toolCanBreak, toolType, isShearsEffective, toolEfficiencyLevel, hasteLevel, miningFatigueLevel, false, true);
        }
        hasteLevel = Math.max(session.getEffectCache().getHaste(), session.getEffectCache().getConduitPower());
        miningFatigueLevel = session.getEffectCache().getMiningFatigue();
        boolean waterInEyes = session.getCollisionManager().isWaterInEyes();
        boolean insideOfWaterWithoutAquaAffinity = waterInEyes && ItemUtils.getEnchantmentLevel(session, session.getPlayerInventory().getItem(5).getComponents(), BedrockEnchantment.AQUA_AFFINITY) < 1;
        return BlockUtils.calculateBreakTime(block.destroyTime(), toolTier, canHarvestWithHand, correctTool, toolCanBreak, toolType, isShearsEffective, toolEfficiencyLevel, hasteLevel, miningFatigueLevel, insideOfWaterWithoutAquaAffinity, session.getPlayerEntity().isOnGround());
    }

    public static double getSessionBreakTime(GeyserSession session, Block block) {
        PlayerInventory inventory = session.getPlayerInventory();
        GeyserItemStack item = inventory.getItemInHand();
        ItemMapping mapping = ItemMapping.AIR;
        DataComponents components = null;
        if (item != null) {
            mapping = item.getMapping(session);
            components = item.getComponents();
        }
        return BlockUtils.getBreakTime(session, block, mapping, components, true);
    }

    public static Vector3i getBlockPosition(Vector3i blockPos, int face) {
        return switch (face) {
            case 0 -> blockPos.sub(0, 1, 0);
            case 1 -> blockPos.add(0, 1, 0);
            case 2 -> blockPos.sub(0, 0, 1);
            case 3 -> blockPos.add(0, 0, 1);
            case 4 -> blockPos.sub(1, 0, 0);
            case 5 -> blockPos.add(1, 0, 0);
            default -> blockPos;
        };
    }

    public static String getCleanIdentifier(String fullJavaIdentifier) {
        int stateIndex = fullJavaIdentifier.indexOf(91);
        if (stateIndex == -1) {
            return fullJavaIdentifier;
        }
        return fullJavaIdentifier.substring(0, stateIndex);
    }

    public static BlockCollision getCollision(int blockId) {
        return BlockRegistries.COLLISIONS.get(blockId);
    }

    public static BlockCollision getCollisionAt(GeyserSession session, Vector3i blockPos) {
        return BlockUtils.getCollision(session.getGeyser().getWorldManager().getBlockAt(session, blockPos));
    }

    public static BlockCollision getCollisionAt(GeyserSession session, int x, int y, int z) {
        return BlockUtils.getCollision(session.getGeyser().getWorldManager().getBlockAt(session, x, y, z));
    }

    private BlockUtils() {
    }
}

