/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import java.util.concurrent.TimeUnit;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityLinkData;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.AutoCraftRecipeAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftRecipeAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityLinkPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.MerchantContainer;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.BaseInventoryTranslator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundSelectTradePacket;

public class MerchantInventoryTranslator
extends BaseInventoryTranslator {
    private final InventoryUpdater updater = UIInventoryUpdater.INSTANCE;

    public MerchantInventoryTranslator() {
        super(3);
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        return switch (slot) {
            case 0 -> 4;
            case 1 -> 5;
            case 2 -> 50;
            default -> super.javaSlotToBedrock(slot);
        };
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot) {
        return switch (slot) {
            case 0 -> new BedrockContainerSlot(ContainerSlotType.TRADE2_INGREDIENT_1, 4);
            case 1 -> new BedrockContainerSlot(ContainerSlotType.TRADE2_INGREDIENT_2, 5);
            case 2 -> new BedrockContainerSlot(ContainerSlotType.TRADE2_RESULT, 50);
            default -> super.javaSlotToBedrockContainer(slot);
        };
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        return switch (slotInfoData.getContainer()) {
            case ContainerSlotType.TRADE2_INGREDIENT_1 -> 0;
            case ContainerSlotType.TRADE2_INGREDIENT_2 -> 1;
            case ContainerSlotType.TRADE2_RESULT, ContainerSlotType.CREATED_OUTPUT -> 2;
            default -> super.bedrockSlotToJava(slotInfoData);
        };
    }

    @Override
    public SlotType getSlotType(int javaSlot) {
        if (javaSlot == 2) {
            return SlotType.OUTPUT;
        }
        return SlotType.NORMAL;
    }

    @Override
    public boolean prepareInventory(GeyserSession session, Inventory inventory) {
        MerchantContainer merchantInventory = (MerchantContainer)inventory;
        if (merchantInventory.getVillager() == null) {
            long geyserId = session.getEntityCache().getNextEntityId().incrementAndGet();
            Vector3f pos = session.getPlayerEntity().getPosition().sub(0.0f, 3.0f, 0.0f);
            Entity villager = new Entity(session, 0, geyserId, null, EntityDefinitions.VILLAGER, pos, Vector3f.ZERO, 0.0f, 0.0f, 0.0f){

                @Override
                protected void initializeMetadata() {
                    this.dirtyMetadata.put(EntityDataTypes.SCALE, Float.valueOf(0.0f));
                    this.dirtyMetadata.put(EntityDataTypes.WIDTH, Float.valueOf(0.0f));
                    this.dirtyMetadata.put(EntityDataTypes.HEIGHT, Float.valueOf(0.0f));
                }
            };
            villager.spawnEntity();
            SetEntityLinkPacket linkPacket = new SetEntityLinkPacket();
            EntityLinkData.Type type = EntityLinkData.Type.PASSENGER;
            linkPacket.setEntityLink(new EntityLinkData(session.getPlayerEntity().getGeyserId(), geyserId, type, true, false));
            session.sendUpstreamPacket(linkPacket);
            merchantInventory.setVillager(villager);
        }
        return true;
    }

    @Override
    public void openInventory(GeyserSession session, Inventory inventory) {
    }

    @Override
    public void closeInventory(GeyserSession session, Inventory inventory) {
        MerchantContainer merchantInventory = (MerchantContainer)inventory;
        if (merchantInventory.getVillager() != null) {
            merchantInventory.getVillager().despawnEntity();
        }
    }

    @Override
    public ItemStackResponse translateCraftingRequest(GeyserSession session, Inventory inventory, ItemStackRequest request) {
        int tradeChoice = ((CraftRecipeAction)request.getActions()[0]).getRecipeNetworkId() - 1;
        return this.handleTrade(session, inventory, request, tradeChoice);
    }

    @Override
    public ItemStackResponse translateAutoCraftingRequest(GeyserSession session, Inventory inventory, ItemStackRequest request) {
        int tradeChoice = ((AutoCraftRecipeAction)request.getActions()[0]).getRecipeNetworkId() - 1;
        return this.handleTrade(session, inventory, request, tradeChoice);
    }

    private ItemStackResponse handleTrade(GeyserSession session, Inventory inventory, ItemStackRequest request, int tradeChoice) {
        ServerboundSelectTradePacket packet = new ServerboundSelectTradePacket(tradeChoice);
        session.sendDownstreamGamePacket(packet);
        if (session.isEmulatePost1_13Logic()) {
            if (inventory instanceof MerchantContainer) {
                MerchantContainer merchantInventory = (MerchantContainer)inventory;
                merchantInventory.onTradeSelected(session, tradeChoice);
            }
            return this.translateRequest(session, inventory, request);
        }
        session.scheduleInEventLoop(() -> {
            if (inventory instanceof MerchantContainer) {
                MerchantContainer merchantInventory = (MerchantContainer)inventory;
                merchantInventory.onTradeSelected(session, tradeChoice);
                this.translateRequest(session, inventory, request);
                this.updateInventory(session, inventory);
                InventoryUtils.updateCursor(session);
            }
        }, 100L, TimeUnit.MILLISECONDS);
        return MerchantInventoryTranslator.rejectRequest(request);
    }

    @Override
    public void updateInventory(GeyserSession session, Inventory inventory) {
        this.updater.updateInventory(this, session, inventory);
    }

    @Override
    public void updateSlot(GeyserSession session, Inventory inventory, int slot) {
        this.updater.updateSlot(this, session, inventory, slot);
    }

    @Override
    public Inventory createInventory(String name, int windowId, ContainerType containerType, PlayerInventory playerInventory) {
        return new MerchantContainer(name, windowId, this.size, containerType, playerInventory);
    }
}

