/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.packet.ContainerSetDataPacket;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.updater.ContainerInventoryUpdater;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;

public class BrewingInventoryTranslator
extends AbstractBlockInventoryTranslator {
    public BrewingInventoryTranslator() {
        super(5, Blocks.BREWING_STAND.defaultBlockState().withValue(Properties.HAS_BOTTLE_0, false).withValue(Properties.HAS_BOTTLE_1, false).withValue(Properties.HAS_BOTTLE_2, false), ContainerType.BREWING_STAND, (InventoryUpdater)ContainerInventoryUpdater.INSTANCE, new Block[0]);
    }

    @Override
    public void openInventory(GeyserSession session, Inventory inventory) {
        super.openInventory(session, inventory);
        ContainerSetDataPacket dataPacket = new ContainerSetDataPacket();
        dataPacket.setWindowId((byte)inventory.getBedrockId());
        dataPacket.setProperty(2);
        dataPacket.setValue(20);
        session.sendUpstreamPacket(dataPacket);
    }

    @Override
    public void updateProperty(GeyserSession session, Inventory inventory, int key, int value) {
        ContainerSetDataPacket dataPacket = new ContainerSetDataPacket();
        dataPacket.setWindowId((byte)inventory.getBedrockId());
        switch (key) {
            case 0: {
                dataPacket.setProperty(0);
                break;
            }
            case 1: {
                dataPacket.setProperty(1);
                break;
            }
            default: {
                return;
            }
        }
        dataPacket.setValue(value);
        session.sendUpstreamPacket(dataPacket);
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        if (slotInfoData.getContainer() == ContainerSlotType.BREWING_INPUT) {
            return 3;
        }
        if (slotInfoData.getContainer() == ContainerSlotType.BREWING_RESULT) {
            return slotInfoData.getSlot() - 1;
        }
        return super.bedrockSlotToJava(slotInfoData);
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        return switch (slot) {
            case 0 -> 1;
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> 0;
            case 4 -> 4;
            default -> super.javaSlotToBedrock(slot);
        };
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot) {
        return switch (slot) {
            case 0, 1, 2 -> new BedrockContainerSlot(ContainerSlotType.BREWING_RESULT, this.javaSlotToBedrock(slot));
            case 3 -> new BedrockContainerSlot(ContainerSlotType.BREWING_INPUT, 0);
            case 4 -> new BedrockContainerSlot(ContainerSlotType.BREWING_FUEL, 4);
            default -> super.javaSlotToBedrockContainer(slot);
        };
    }
}

