/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.nbt.NbtUtils;
import org.cloudburstmc.protocol.bedrock.codec.v671.Bedrock_v671;
import org.cloudburstmc.protocol.bedrock.codec.v685.Bedrock_v685;
import org.cloudburstmc.protocol.bedrock.data.BlockPropertyData;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.nonvanilla.JavaBlockState;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.FlowerPotBlock;
import org.geysermc.geyser.level.physics.PistonBehavior;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.populator.Conversion685_671;
import org.geysermc.geyser.registry.populator.CustomBlockRegistryPopulator;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public final class BlockRegistryPopulator {
    private static List<NbtMap> BLOCKS_NBT;
    private static int MIN_CUSTOM_RUNTIME_ID;
    private static int JAVA_BLOCKS_SIZE;
    private static final long FNV1_64_OFFSET_BASIS = -3750763034362895579L;
    private static final long FNV1_64_PRIME = 1099511628211L;

    public static void populate(Stage stage) {
        switch (stage) {
            case PRE_INIT: 
            case POST_INIT: {
                BlockRegistryPopulator.nullifyBlocksNbt();
                break;
            }
            case INIT_JAVA: {
                BlockRegistryPopulator.registerJavaBlocks();
                break;
            }
            case INIT_BEDROCK: {
                BlockRegistryPopulator.registerBedrockBlocks();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown stage: " + stage);
            }
        }
    }

    private static void nullifyBlocksNbt() {
        BLOCKS_NBT = null;
    }

    private static void registerBedrockBlocks() {
        ImmutableMap<ObjectIntPair<String>, Remapper> blockMappers = ImmutableMap.builder().put(ObjectIntPair.of("1_20_80", Bedrock_v671.CODEC.getProtocolVersion()), Conversion685_671::remapBlock).put(ObjectIntPair.of("1_21_0", Bedrock_v685.CODEC.getProtocolVersion()), tag -> tag).build();
        Interner<NbtMap> statesInterner = Interners.newStrongInterner();
        for (ObjectIntPair palette : blockMappers.keySet()) {
            ArrayList<NbtMap> blockStates;
            ArrayList<NbtMap> vanillaBlockStates;
            int protocolVersion = palette.valueInt();
            try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow(String.format("bedrock/block_palette.%s.nbt", palette.key()));
                 NBTInputStream nbtInputStream = new NBTInputStream(new DataInputStream(new GZIPInputStream(stream)), true, true);){
                NbtMap blockPalette = (NbtMap)nbtInputStream.readTag();
                vanillaBlockStates = new ArrayList<NbtMap>(blockPalette.getList("blocks", NbtType.COMPOUND));
                for (int i = 0; i < vanillaBlockStates.size(); ++i) {
                    CustomBlockData[] builder = ((NbtMap)vanillaBlockStates.get(i)).toBuilder();
                    builder.remove("version");
                    builder.remove("name_hash");
                    builder.remove("network_id");
                    builder.remove("block_id");
                    builder.putCompound("states", statesInterner.intern((NbtMap)builder.remove("states")));
                    vanillaBlockStates.set(i, builder.build());
                }
                blockStates = new ArrayList<NbtMap>(vanillaBlockStates);
            }
            catch (Exception e) {
                throw new AssertionError("Unable to get blocks from runtime block states", e);
            }
            ArrayList<BlockPropertyData> customBlockProperties = new ArrayList<BlockPropertyData>();
            ArrayList<NbtMap> customBlockStates = new ArrayList<NbtMap>();
            ArrayList<CustomBlockState> customExtBlockStates = new ArrayList<CustomBlockState>();
            int[] remappedVanillaIds = new int[]{};
            if (((CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()).length != 0) {
                CustomBlockRegistryPopulator.BLOCK_ID.set(10000);
                for (CustomBlockData customBlock : (CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()) {
                    customBlockProperties.add(CustomBlockRegistryPopulator.generateBlockPropertyData(customBlock, protocolVersion));
                    CustomBlockRegistryPopulator.generateCustomBlockStates(customBlock, customBlockStates, customExtBlockStates);
                }
                blockStates.addAll(customBlockStates);
                GeyserImpl.getInstance().getLogger().debug("Added " + customBlockStates.size() + " custom block states to v" + protocolVersion + " palette.");
                blockStates.sort((a, b) -> Long.compareUnsigned(BlockRegistryPopulator.fnv164(a.getString("name")), BlockRegistryPopulator.fnv164(b.getString("name"))));
            }
            Object2ObjectOpenHashMap<NbtMap, GeyserBedrockBlock> blockStateOrderedMap = new Object2ObjectOpenHashMap<NbtMap, GeyserBedrockBlock>(blockStates.size());
            GeyserBedrockBlock[] bedrockRuntimeMap = new GeyserBedrockBlock[blockStates.size()];
            for (int i = 0; i < blockStates.size(); ++i) {
                NbtMap tag2 = (NbtMap)blockStates.get(i);
                if (blockStateOrderedMap.containsKey(tag2)) {
                    throw new AssertionError((Object)("Duplicate block states in Bedrock palette: " + tag2));
                }
                GeyserBedrockBlock block2 = new GeyserBedrockBlock(i, tag2);
                blockStateOrderedMap.put(tag2, block2);
                bedrockRuntimeMap[i] = block2;
            }
            Object2ObjectMap<CustomBlockState, GeyserBedrockBlock> customBlockStateDefinitions = Object2ObjectMaps.emptyMap();
            Int2ObjectOpenHashMap<GeyserBedrockBlock> extendedCollisionBoxes = new Int2ObjectOpenHashMap<GeyserBedrockBlock>();
            if (((CustomBlockData[])BlockRegistries.CUSTOM_BLOCKS.get()).length != 0) {
                int i;
                customBlockStateDefinitions = new Object2ObjectOpenHashMap(customExtBlockStates.size());
                for (i = 0; i < customExtBlockStates.size(); ++i) {
                    NbtMap tag3 = (NbtMap)customBlockStates.get(i);
                    CustomBlockState blockState = (CustomBlockState)customExtBlockStates.get(i);
                    GeyserBedrockBlock bedrockBlock = (GeyserBedrockBlock)blockStateOrderedMap.get(tag3);
                    customBlockStateDefinitions.put(blockState, bedrockBlock);
                    Set extendedCollisionjavaIds = BlockRegistries.EXTENDED_COLLISION_BOXES.getOrDefault(blockState.block(), null);
                    if (extendedCollisionjavaIds == null) continue;
                    Iterator iterator = extendedCollisionjavaIds.iterator();
                    while (iterator.hasNext()) {
                        int javaId = (Integer)iterator.next();
                        extendedCollisionBoxes.put(javaId, bedrockBlock);
                    }
                }
                remappedVanillaIds = new int[vanillaBlockStates.size()];
                for (i = 0; i < vanillaBlockStates.size(); ++i) {
                    GeyserBedrockBlock bedrockBlock = (GeyserBedrockBlock)blockStateOrderedMap.get(vanillaBlockStates.get(i));
                    remappedVanillaIds[i] = bedrockBlock != null ? bedrockBlock.getRuntimeId() : -1;
                }
            }
            int javaRuntimeId = -1;
            List javaBlockStates = (List)BlockRegistries.BLOCK_STATES.get();
            GeyserBedrockBlock airDefinition = null;
            GeyserBedrockBlock commandBlockDefinition = null;
            GeyserBedrockBlock mobSpawnerBlockDefinition = null;
            GeyserBedrockBlock waterDefinition = null;
            GeyserBedrockBlock movingBlockDefinition = null;
            Iterator<NbtMap> blocksIterator = BLOCKS_NBT.iterator();
            Remapper stateMapper = blockMappers.get(palette);
            Object[] javaToBedrockBlocks = new GeyserBedrockBlock[JAVA_BLOCKS_SIZE];
            Object[] javaToVanillaBedrockBlocks = new GeyserBedrockBlock[JAVA_BLOCKS_SIZE];
            Int2ObjectOpenHashMap<String> javaToBedrockIdentifiers = new Int2ObjectOpenHashMap<String>();
            Block lastBlockSeen = null;
            List javaPottable = ((List)BlockRegistries.JAVA_BLOCKS.get()).parallelStream().flatMap(block -> {
                FlowerPotBlock flowerPot;
                if (block instanceof FlowerPotBlock && (flowerPot = (FlowerPotBlock)block).flower() != Blocks.AIR) {
                    return Stream.of(flowerPot.flower());
                }
                return null;
            }).toList();
            Object2ObjectOpenHashMap<Block, NbtMap> flowerPotBlocks = new Object2ObjectOpenHashMap<Block, NbtMap>();
            Object2ObjectOpenHashMap<NbtMap, BlockDefinition> itemFrames = new Object2ObjectOpenHashMap<NbtMap, BlockDefinition>();
            ObjectOpenHashSet<BlockDefinition> jigsawDefinitions = new ObjectOpenHashSet<BlockDefinition>();
            Object2ObjectOpenHashMap<String, BlockDefinition> structureBlockDefinitions = new Object2ObjectOpenHashMap<String, BlockDefinition>();
            BlockMappings.BlockMappingsBuilder builder = BlockMappings.builder();
            while (blocksIterator.hasNext()) {
                boolean waterlogged;
                GeyserBedrockBlock bedrockDefinition;
                NbtMap entry2 = blocksIterator.next();
                BlockState blockState = (BlockState)javaBlockStates.get(++javaRuntimeId);
                String javaId = blockState.toString();
                NbtMap originalBedrockTag = BlockRegistryPopulator.buildBedrockState(blockState, entry2);
                NbtMap bedrockTag = stateMapper.remap(originalBedrockTag);
                GeyserBedrockBlock vanillaBedrockDefinition = (GeyserBedrockBlock)blockStateOrderedMap.get(bedrockTag);
                CustomBlockState blockStateOverride = (CustomBlockState)BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.get(javaRuntimeId);
                if (blockStateOverride == null) {
                    bedrockDefinition = vanillaBedrockDefinition;
                    if (bedrockDefinition == null) {
                        throw new RuntimeException("Unable to find %s Bedrock runtime ID for %s! Original block tag:\n%s\nUpdated block tag:\n%s".formatted(javaId, palette.key(), originalBedrockTag, bedrockTag));
                    }
                } else {
                    bedrockDefinition = (GeyserBedrockBlock)customBlockStateDefinitions.get(blockStateOverride);
                    if (bedrockDefinition == null) {
                        throw new RuntimeException("Unable to find " + javaId + " Bedrock runtime ID! Custom block override: \n" + blockStateOverride);
                    }
                }
                switch (javaId) {
                    case "minecraft:air": {
                        airDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:water[level=0]": {
                        waterDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:command_block[conditional=false,facing=north]": {
                        commandBlockDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:spawner": {
                        mobSpawnerBlockDefinition = bedrockDefinition;
                        break;
                    }
                    case "minecraft:moving_piston[facing=north,type=normal]": {
                        movingBlockDefinition = bedrockDefinition;
                    }
                }
                Block block3 = blockState.block();
                if (block3 != lastBlockSeen) {
                    lastBlockSeen = block3;
                    String bedrockName = bedrockDefinition.getState().getString("name");
                    if (!block3.javaIdentifier().toString().equals(bedrockName)) {
                        javaToBedrockIdentifiers.put(block3.javaId(), bedrockName.substring("minecraft:".length()).intern());
                    }
                }
                if (block3 == Blocks.JIGSAW) {
                    jigsawDefinitions.add(bedrockDefinition);
                }
                if (block3 == Blocks.STRUCTURE_BLOCK) {
                    String mode = blockState.getValue(Properties.STRUCTUREBLOCK_MODE);
                    structureBlockDefinitions.put(mode.toUpperCase(Locale.ROOT), bedrockDefinition);
                }
                boolean bl = waterlogged = blockState.getValue(Properties.WATERLOGGED, false) != false || block3 == Blocks.BUBBLE_COLUMN || block3 == Blocks.KELP || block3 == Blocks.KELP_PLANT || block3 == Blocks.SEAGRASS || block3 == Blocks.TALL_SEAGRASS;
                if (waterlogged) {
                    ((BitSet)BlockRegistries.WATERLOGGED.get()).set(javaRuntimeId);
                }
                if (javaPottable.contains(block3)) {
                    flowerPotBlocks.put(block3, (NbtMap)blockStates.get(bedrockDefinition.getRuntimeId()));
                }
                javaToVanillaBedrockBlocks[javaRuntimeId] = vanillaBedrockDefinition;
                javaToBedrockBlocks[javaRuntimeId] = bedrockDefinition;
            }
            if (commandBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find command block in palette");
            }
            builder.commandBlock(commandBlockDefinition);
            if (mobSpawnerBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find mob spawner block in palette");
            }
            builder.mobSpawnerBlock(mobSpawnerBlockDefinition);
            if (waterDefinition == null) {
                throw new AssertionError((Object)"Unable to find water in palette");
            }
            builder.bedrockWater(waterDefinition);
            if (airDefinition == null) {
                throw new AssertionError((Object)"Unable to find air in palette");
            }
            builder.bedrockAir(airDefinition);
            if (movingBlockDefinition == null) {
                throw new AssertionError((Object)"Unable to find moving block in palette");
            }
            builder.bedrockMovingBlock(movingBlockDefinition);
            Map nonVanillaStateOverrides = (Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get();
            if (!nonVanillaStateOverrides.isEmpty()) {
                Arrays.fill(javaToVanillaBedrockBlocks, MIN_CUSTOM_RUNTIME_ID, javaToVanillaBedrockBlocks.length, airDefinition);
                Arrays.fill(javaToBedrockBlocks, MIN_CUSTOM_RUNTIME_ID, javaToBedrockBlocks.length, airDefinition);
                for (Map.Entry entry3 : nonVanillaStateOverrides.entrySet()) {
                    GeyserBedrockBlock bedrockDefinition = (GeyserBedrockBlock)customBlockStateDefinitions.get(entry3.getValue());
                    if (bedrockDefinition == null) {
                        GeyserImpl.getInstance().getLogger().warning("Unable to find custom block for " + entry3.getValue());
                        continue;
                    }
                    JavaBlockState javaState = (JavaBlockState)entry3.getKey();
                    int stateRuntimeId = javaState.javaId();
                    boolean waterlogged = javaState.waterlogged();
                    if (waterlogged) {
                        BlockRegistries.WATERLOGGED.register(set -> set.set(stateRuntimeId));
                    }
                    javaToVanillaBedrockBlocks[stateRuntimeId] = bedrockDefinition;
                    javaToBedrockBlocks[stateRuntimeId] = bedrockDefinition;
                    javaToBedrockIdentifiers.put(((JavaBlockState)entry3.getKey()).stateGroupId(), ((CustomBlockState)entry3.getValue()).block().identifier());
                }
            }
            javaToBedrockIdentifiers.trim();
            Object2ObjectMaps.fastForEach(blockStateOrderedMap, entry -> {
                String name = ((NbtMap)entry.getKey()).getString("name");
                if (name.equals("minecraft:frame") || name.equals("minecraft:glow_frame")) {
                    itemFrames.put((NbtMap)entry.getKey(), (BlockDefinition)entry.getValue());
                }
            });
            BlockRegistries.BLOCKS.register(palette.valueInt(), builder.bedrockRuntimeMap(bedrockRuntimeMap).javaToBedrockBlocks((GeyserBedrockBlock[])javaToBedrockBlocks).javaToVanillaBedrockBlocks((GeyserBedrockBlock[])javaToVanillaBedrockBlocks).javaToBedrockIdentifiers(javaToBedrockIdentifiers).stateDefinitionMap(blockStateOrderedMap).itemFrames(itemFrames).flowerPotBlocks(flowerPotBlocks).jigsawStates(jigsawDefinitions).structureBlockStates(structureBlockDefinitions).remappedVanillaIds(remappedVanillaIds).blockProperties(customBlockProperties).customBlockStateDefinitions(customBlockStateDefinitions).extendedCollisionBoxes(extendedCollisionBoxes).build());
        }
    }

    private static void registerJavaBlocks() {
        JsonNode blockInteractionsJson;
        List<NbtMap> blocksNbt;
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("mappings/blocks.nbt");){
            blocksNbt = ((NbtMap)NbtUtils.createGZIPReader(stream).readTag()).getList("bedrock_mappings", NbtType.COMPOUND);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java block mappings", e);
        }
        JAVA_BLOCKS_SIZE = ((List)BlockRegistries.BLOCK_STATES.get()).size();
        if (!((Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get()).isEmpty()) {
            MIN_CUSTOM_RUNTIME_ID = ((Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get()).keySet().stream().min(Comparator.comparing(JavaBlockState::javaId)).orElseThrow().javaId();
            int maxCustomRuntimeID = ((Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get()).keySet().stream().max(Comparator.comparing(JavaBlockState::javaId)).orElseThrow().javaId();
            if (MIN_CUSTOM_RUNTIME_ID < blocksNbt.size()) {
                throw new RuntimeException("Non vanilla custom block state overrides runtime ID must start after the last vanilla block state (" + JAVA_BLOCKS_SIZE + ")");
            }
            JAVA_BLOCKS_SIZE = maxCustomRuntimeID + 1;
        }
        int javaRuntimeId = -1;
        for (Object javaBlockState : (List)BlockRegistries.BLOCK_STATES.get()) {
            String javaId = ((BlockState)javaBlockState).toString().intern();
            BlockRegistries.JAVA_IDENTIFIER_TO_ID.register(javaId, ++javaRuntimeId);
        }
        if (!((Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get()).isEmpty()) {
            IntOpenHashSet usedNonVanillaRuntimeIDs = new IntOpenHashSet();
            for (final JavaBlockState javaBlockState : ((Map)BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.get()).keySet()) {
                if (!usedNonVanillaRuntimeIDs.add(javaBlockState.javaId())) {
                    throw new RuntimeException("Duplicate runtime ID " + javaBlockState.javaId() + " for non vanilla Java block state " + javaBlockState.identifier());
                }
                String javaId = javaBlockState.identifier();
                int stateRuntimeId = javaBlockState.javaId();
                String pistonBehavior = javaBlockState.pistonBehavior();
                Block.Builder builder = Block.builder().destroyTime(javaBlockState.blockHardness()).pushReaction(pistonBehavior == null ? PistonBehavior.NORMAL : PistonBehavior.getByName(pistonBehavior));
                if (!javaBlockState.canBreakWithHand()) {
                    builder.requiresCorrectToolForDrops();
                }
                String cleanJavaIdentifier = BlockUtils.getCleanIdentifier(javaBlockState.identifier());
                final String pickItem = javaBlockState.pickItem();
                Block block = new Block(cleanJavaIdentifier, builder){

                    @Override
                    public ItemStack pickItem(BlockState state) {
                        if (this.item == null) {
                            this.item = (Item)Registries.JAVA_ITEM_IDENTIFIERS.get(pickItem);
                            if (this.item == null) {
                                GeyserImpl.getInstance().getLogger().warning("We could not find item " + pickItem + " for getting the item for block " + javaBlockState.identifier());
                                this.item = Items.AIR;
                            }
                        }
                        return new ItemStack(this.item.javaId());
                    }
                };
                block.setJavaId(javaBlockState.stateGroupId());
                BlockRegistries.JAVA_BLOCKS.registerWithAnyIndex(javaBlockState.stateGroupId(), block, Blocks.AIR);
                BlockRegistries.JAVA_IDENTIFIER_TO_ID.register(javaId, stateRuntimeId);
                BlockRegistries.BLOCK_STATES.register(stateRuntimeId, new BlockState(block, stateRuntimeId));
            }
        }
        BLOCKS_NBT = blocksNbt;
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("mappings/interactions.json");){
            blockInteractionsJson = GeyserImpl.JSON_MAPPER.readTree(stream);
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load Java block interaction mappings", e);
        }
        BlockRegistries.INTERACTIVE.set(BlockRegistryPopulator.toBlockStateSet((ArrayNode)blockInteractionsJson.get("always_consumes")));
        BlockRegistries.INTERACTIVE_MAY_BUILD.set(BlockRegistryPopulator.toBlockStateSet((ArrayNode)blockInteractionsJson.get("requires_may_build")));
        BlockRegistries.BLOCK_STATES.freeze();
    }

    private static BitSet toBlockStateSet(ArrayNode node) {
        BitSet blockStateSet = new BitSet(node.size());
        for (JsonNode javaIdentifier : node) {
            blockStateSet.set(((Object2IntMap)BlockRegistries.JAVA_IDENTIFIER_TO_ID.get()).getInt(javaIdentifier.textValue()));
        }
        return blockStateSet;
    }

    private static NbtMap buildBedrockState(BlockState state, NbtMap nbt) {
        NbtMapBuilder tagBuilder = NbtMap.builder();
        String bedrockIdentifier = "minecraft:" + nbt.getString("bedrock_identifier", state.block().javaIdentifier().value());
        tagBuilder.putString("name", bedrockIdentifier);
        tagBuilder.put("states", (Object)nbt.getCompound("state"));
        return tagBuilder.build();
    }

    private static long fnv164(String str) {
        long hash = -3750763034362895579L;
        for (byte b : str.getBytes(StandardCharsets.UTF_8)) {
            hash *= 1099511628211L;
            hash ^= (long)b;
        }
        return hash;
    }

    static {
        MIN_CUSTOM_RUNTIME_ID = -1;
        JAVA_BLOCKS_SIZE = -1;
    }

    public static enum Stage {
        PRE_INIT,
        INIT_JAVA,
        INIT_BEDROCK,
        POST_INIT;

    }

    @FunctionalInterface
    static interface Remapper {
        public NbtMap remap(NbtMap var1);
    }
}

