/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.standalone.gui;

import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.geysermc.geyser.platform.standalone.gui.ANSIColor;

public class ColorPane
extends JTextPane {
    private static final long serialVersionUID = 1L;
    private static Color colorCurrent = ANSIColor.RESET.getColor();
    private String remaining = "";

    private void append(Color c, String s) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, c);
        int len = this.getDocument().getLength();
        try {
            this.getDocument().insertString(len, s, aset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void appendANSI(String s) {
        int aPos = 0;
        boolean stillSearching = true;
        String addString = this.remaining + s;
        this.remaining = "";
        if (addString.length() > 0) {
            String tmpString;
            int aIndex = addString.indexOf("\u001b");
            if (aIndex == -1) {
                this.append(colorCurrent, addString);
                return;
            }
            if (aIndex > 0) {
                tmpString = addString.substring(0, aIndex);
                this.append(colorCurrent, tmpString);
                aPos = aIndex;
            }
            while (stillSearching) {
                int mIndex = addString.indexOf("m", aPos);
                if (mIndex < 0) {
                    this.remaining = addString.substring(aPos);
                    stillSearching = false;
                    continue;
                }
                tmpString = addString.substring(aPos, mIndex + 1);
                colorCurrent = ANSIColor.fromANSI(tmpString).getColor();
                aPos = mIndex + 1;
                aIndex = addString.indexOf("\u001b", aPos);
                if (aIndex == -1) {
                    tmpString = addString.substring(aPos);
                    this.append(colorCurrent, tmpString);
                    stillSearching = false;
                    continue;
                }
                tmpString = addString.substring(aPos, aIndex);
                aPos = aIndex;
                this.append(colorCurrent, tmpString);
            }
        }
    }
}

