/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.standalone;

import net.minecrell.terminalconsole.SimpleTerminalConsole;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeyserStandaloneLogger
extends SimpleTerminalConsole
implements GeyserLogger,
GeyserCommandSource {
    private static final Logger log = LoggerFactory.getLogger(GeyserStandaloneLogger.class);

    @Override
    protected boolean isRunning() {
        return !GeyserImpl.getInstance().isShuttingDown();
    }

    @Override
    protected void runCommand(String line) {
        GeyserImpl.getInstance().commandManager().runCommand(this, line);
    }

    @Override
    protected void shutdown() {
        GeyserImpl.getInstance().getBootstrap().onGeyserShutdown();
    }

    @Override
    public void severe(String message) {
        log.error("\u00a74" + message);
    }

    @Override
    public void severe(String message, Throwable error) {
        log.error("\u00a74" + message, error);
    }

    @Override
    public void error(String message) {
        log.error("\u00a7c" + message);
    }

    @Override
    public void error(String message, Throwable error) {
        log.error("\u00a7c" + message, error);
    }

    @Override
    public void warning(String message) {
        log.warn("\u00a7e" + message);
    }

    @Override
    public void info(String message) {
        log.info("\u00a7r" + message);
    }

    @Override
    public void debug(String message) {
        log.debug("\u00a77" + message);
    }

    @Override
    public void setDebug(boolean debug) {
        Configurator.setLevel(log.getName(), debug ? Level.DEBUG : Level.INFO);
    }

    @Override
    public boolean isDebug() {
        return log.isDebugEnabled();
    }
}

