/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.stream.Stream;
import org.geysermc.geyser.session.GeyserSession;

public class InvalidPacketHandler
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "rak-error-handler";
    private final GeyserSession session;

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Throwable rootCause = Stream.iterate(cause, Throwable::getCause).filter(element -> element.getCause() == null).findFirst().orElse(cause);
        if (!(rootCause instanceof IllegalArgumentException)) {
            this.session.getGeyser().getLogger().warning("Exception caught in session of" + this.session.bedrockUsername() + ": " + rootCause.getMessage());
            this.session.disconnect("An internal error occurred!");
            return;
        }
        this.session.getGeyser().getLogger().warning(rootCause.getMessage());
        this.session.disconnect("Invalid packet received!");
    }

    public InvalidPacketHandler(GeyserSession session) {
        this.session = session;
    }
}

