/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.enchantment;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.inventory.item.BedrockEnchantment;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.enchantment.EnchantmentComponent;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.cache.registry.RegistryEntryContext;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;

public record Enchantment(String identifier, Set<EnchantmentComponent> effects, HolderSet supportedItems, int maxLevel, String description, int anvilCost, HolderSet exclusiveSet, @Nullable BedrockEnchantment bedrockEnchantment) {
    public static Enchantment read(RegistryEntryContext context) {
        NbtMap data = context.data();
        Set<EnchantmentComponent> effects = Enchantment.readEnchantmentComponents(data.getCompound("effects"));
        HolderSet supportedItems = Enchantment.readHolderSet(data.get("supported_items"), itemId -> Registries.JAVA_ITEM_IDENTIFIERS.getOrDefault(itemId.asString(), Items.AIR).javaId());
        int maxLevel = data.getInt("max_level");
        int anvilCost = data.getInt("anvil_cost");
        HolderSet exclusiveSet = Enchantment.readHolderSet(data.getOrDefault("exclusive_set", null), context::getNetworkId);
        BedrockEnchantment bedrockEnchantment = BedrockEnchantment.getByJavaIdentifier(context.id().asString());
        String description = bedrockEnchantment == null ? MessageTranslator.deserializeDescription(data) : null;
        return new Enchantment(context.id().asString(), effects, supportedItems, maxLevel, description, anvilCost, exclusiveSet, bedrockEnchantment);
    }

    private static Set<EnchantmentComponent> readEnchantmentComponents(NbtMap effects) {
        HashSet<EnchantmentComponent> components = new HashSet<EnchantmentComponent>();
        for (Map.Entry<String, Object> entry : effects.entrySet()) {
            switch (entry.getKey()) {
                case "minecraft:prevent_armor_change": {
                    components.add(EnchantmentComponent.PREVENT_ARMOR_CHANGE);
                }
            }
        }
        return Set.copyOf(components);
    }

    private static HolderSet readHolderSet(@Nullable Object holderSet, Function<Key, Integer> keyIdMapping) {
        if (holderSet == null) {
            return new HolderSet(new int[0]);
        }
        if (holderSet instanceof String) {
            String stringTag = (String)holderSet;
            if (stringTag.startsWith("#")) {
                return new HolderSet(Key.key(stringTag.substring(1)));
            }
            return new HolderSet(new int[]{keyIdMapping.apply(Key.key(stringTag))});
        }
        if (holderSet instanceof List) {
            List list = (List)holderSet;
            return new HolderSet(list.stream().map(o -> (String)o).map(Key::key).map(keyIdMapping).mapToInt(Integer::intValue).toArray());
        }
        throw new IllegalArgumentException("Holder set must either be a tag, a string ID or a list of string IDs");
    }
}

