/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.netty;

import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.ObjectPool;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import org.cloudburstmc.protocol.bedrock.data.CompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.netty.BedrockPacketWrapper;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.util.BatchFlag;

public class BedrockBatchWrapper
extends AbstractReferenceCounted {
    private static final ObjectPool<BedrockBatchWrapper> RECYCLER = ObjectPool.newPool(BedrockBatchWrapper::new);
    private final ObjectPool.Handle<BedrockBatchWrapper> handle;
    private ByteBuf compressed;
    private CompressionAlgorithm algorithm;
    private ByteBuf uncompressed;
    private List<BedrockPacketWrapper> packets = new ObjectArrayList<BedrockPacketWrapper>();
    private boolean modified;
    private Set<BatchFlag> flags = new ObjectOpenHashSet<BatchFlag>();

    private BedrockBatchWrapper(ObjectPool.Handle<BedrockBatchWrapper> handle) {
        this.handle = handle;
    }

    public static BedrockBatchWrapper newInstance() {
        return BedrockBatchWrapper.newInstance(null, null);
    }

    public static BedrockBatchWrapper newInstance(ByteBuf compressed, ByteBuf uncompressed) {
        BedrockBatchWrapper batch = RECYCLER.get();
        batch.compressed = compressed;
        batch.uncompressed = uncompressed;
        batch.setRefCnt(1);
        if (!batch.packets.isEmpty() || !batch.flags.isEmpty()) {
            throw new IllegalStateException("Batch was not deallocated");
        }
        return batch;
    }

    public static BedrockBatchWrapper create(int subClientId, BedrockPacket ... packets) {
        BedrockBatchWrapper batch = BedrockBatchWrapper.newInstance();
        for (BedrockPacket packet : packets) {
            batch.getPackets().add(new BedrockPacketWrapper(0, subClientId, 0, packet, null));
        }
        return batch;
    }

    @Override
    protected void deallocate() {
        this.packets.forEach(ReferenceCountUtil::safeRelease);
        ReferenceCountUtil.safeRelease(this.uncompressed);
        ReferenceCountUtil.safeRelease(this.compressed);
        this.compressed = null;
        this.uncompressed = null;
        this.packets.clear();
        this.modified = false;
        this.algorithm = null;
        this.flags.clear();
        this.handle.recycle(this);
    }

    public void addPacket(BedrockPacketWrapper wrapper) {
        this.packets.add(wrapper);
        this.modify();
    }

    public void modify() {
        this.modified = true;
    }

    public void setCompressed(ByteBuf compressed) {
        if (this.compressed != null) {
            this.compressed.release();
        }
        this.compressed = compressed;
        if (compressed == null) {
            this.algorithm = null;
        }
    }

    public void setCompressed(ByteBuf compressed, CompressionAlgorithm algorithm) {
        if (this.compressed != null) {
            this.compressed.release();
        }
        this.compressed = compressed;
        this.algorithm = algorithm;
    }

    public void setUncompressed(ByteBuf uncompressed) {
        if (this.uncompressed != null) {
            this.uncompressed.release();
        }
        this.uncompressed = uncompressed;
    }

    public void setFlag(BatchFlag flag) {
        this.flags.add(flag);
    }

    public boolean hasFlag(BatchFlag flag) {
        return this.flags.contains(flag);
    }

    public void unsetFlag(BatchFlag flag) {
        this.flags.remove(flag);
    }

    @Override
    public ReferenceCounted touch(Object o) {
        return this;
    }

    @Override
    public BedrockBatchWrapper retain() {
        return (BedrockBatchWrapper)super.retain();
    }

    @Override
    public BedrockBatchWrapper retain(int increment) {
        return (BedrockBatchWrapper)super.retain(increment);
    }

    public ObjectPool.Handle<BedrockBatchWrapper> getHandle() {
        return this.handle;
    }

    public ByteBuf getCompressed() {
        return this.compressed;
    }

    public CompressionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public ByteBuf getUncompressed() {
        return this.uncompressed;
    }

    public List<BedrockPacketWrapper> getPackets() {
        return this.packets;
    }

    public boolean isModified() {
        return this.modified;
    }

    public Set<BatchFlag> getFlags() {
        return this.flags;
    }

    public void setAlgorithm(CompressionAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void setPackets(List<BedrockPacketWrapper> packets) {
        this.packets = packets;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void setFlags(Set<BatchFlag> flags) {
        this.flags = flags;
    }

    public String toString() {
        return "BedrockBatchWrapper(handle=" + this.getHandle() + ", compressed=" + this.getCompressed() + ", algorithm=" + this.getAlgorithm() + ", uncompressed=" + this.getUncompressed() + ", packets=" + this.getPackets() + ", modified=" + this.isModified() + ", flags=" + this.getFlags() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BedrockBatchWrapper)) {
            return false;
        }
        BedrockBatchWrapper other = (BedrockBatchWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isModified() != other.isModified()) {
            return false;
        }
        ObjectPool.Handle<BedrockBatchWrapper> this$handle = this.getHandle();
        ObjectPool.Handle<BedrockBatchWrapper> other$handle = other.getHandle();
        if (this$handle == null ? other$handle != null : !this$handle.equals(other$handle)) {
            return false;
        }
        ByteBuf this$compressed = this.getCompressed();
        ByteBuf other$compressed = other.getCompressed();
        if (this$compressed == null ? other$compressed != null : !((Object)this$compressed).equals(other$compressed)) {
            return false;
        }
        CompressionAlgorithm this$algorithm = this.getAlgorithm();
        CompressionAlgorithm other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        ByteBuf this$uncompressed = this.getUncompressed();
        ByteBuf other$uncompressed = other.getUncompressed();
        if (this$uncompressed == null ? other$uncompressed != null : !((Object)this$uncompressed).equals(other$uncompressed)) {
            return false;
        }
        List<BedrockPacketWrapper> this$packets = this.getPackets();
        List<BedrockPacketWrapper> other$packets = other.getPackets();
        if (this$packets == null ? other$packets != null : !((Object)this$packets).equals(other$packets)) {
            return false;
        }
        Set<BatchFlag> this$flags = this.getFlags();
        Set<BatchFlag> other$flags = other.getFlags();
        return !(this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BedrockBatchWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isModified() ? 79 : 97);
        ObjectPool.Handle<BedrockBatchWrapper> $handle = this.getHandle();
        result = result * 59 + ($handle == null ? 43 : $handle.hashCode());
        ByteBuf $compressed = this.getCompressed();
        result = result * 59 + ($compressed == null ? 43 : ((Object)$compressed).hashCode());
        CompressionAlgorithm $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        ByteBuf $uncompressed = this.getUncompressed();
        result = result * 59 + ($uncompressed == null ? 43 : ((Object)$uncompressed).hashCode());
        List<BedrockPacketWrapper> $packets = this.getPackets();
        result = result * 59 + ($packets == null ? 43 : ((Object)$packets).hashCode());
        Set<BatchFlag> $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        return result;
    }
}

