/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data;

import io.netty.buffer.ByteBuf;
import io.netty.util.AbstractReferenceCounted;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.HeightMapDataType;
import org.cloudburstmc.protocol.bedrock.data.SubChunkRequestResult;

public class SubChunkData
extends AbstractReferenceCounted {
    private Vector3i position;
    private ByteBuf data;
    private SubChunkRequestResult result;
    private HeightMapDataType heightMapType;
    private ByteBuf heightMapData;
    private boolean cacheEnabled;
    private long blobId;

    @Override
    public SubChunkData touch(Object o) {
        if (this.data != null) {
            this.data.touch(o);
        }
        if (this.heightMapData != null) {
            this.heightMapData.touch(o);
        }
        return this;
    }

    @Override
    protected void deallocate() {
        if (this.data != null) {
            this.data.release();
        }
        if (this.heightMapData != null) {
            this.heightMapData.release();
        }
    }

    public Vector3i getPosition() {
        return this.position;
    }

    public ByteBuf getData() {
        return this.data;
    }

    public SubChunkRequestResult getResult() {
        return this.result;
    }

    public HeightMapDataType getHeightMapType() {
        return this.heightMapType;
    }

    public ByteBuf getHeightMapData() {
        return this.heightMapData;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public long getBlobId() {
        return this.blobId;
    }

    public void setPosition(Vector3i position) {
        this.position = position;
    }

    public void setData(ByteBuf data) {
        this.data = data;
    }

    public void setResult(SubChunkRequestResult result) {
        this.result = result;
    }

    public void setHeightMapType(HeightMapDataType heightMapType) {
        this.heightMapType = heightMapType;
    }

    public void setHeightMapData(ByteBuf heightMapData) {
        this.heightMapData = heightMapData;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public void setBlobId(long blobId) {
        this.blobId = blobId;
    }

    public String toString() {
        return "SubChunkData(position=" + this.getPosition() + ", data=" + this.getData() + ", result=" + (Object)((Object)this.getResult()) + ", heightMapType=" + (Object)((Object)this.getHeightMapType()) + ", heightMapData=" + this.getHeightMapData() + ", cacheEnabled=" + this.isCacheEnabled() + ", blobId=" + this.getBlobId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubChunkData)) {
            return false;
        }
        SubChunkData other = (SubChunkData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCacheEnabled() != other.isCacheEnabled()) {
            return false;
        }
        if (this.getBlobId() != other.getBlobId()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        ByteBuf this$data = this.getData();
        ByteBuf other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        SubChunkRequestResult this$result = this.getResult();
        SubChunkRequestResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)((Object)this$result)).equals((Object)other$result)) {
            return false;
        }
        HeightMapDataType this$heightMapType = this.getHeightMapType();
        HeightMapDataType other$heightMapType = other.getHeightMapType();
        if (this$heightMapType == null ? other$heightMapType != null : !((Object)((Object)this$heightMapType)).equals((Object)other$heightMapType)) {
            return false;
        }
        ByteBuf this$heightMapData = this.getHeightMapData();
        ByteBuf other$heightMapData = other.getHeightMapData();
        return !(this$heightMapData == null ? other$heightMapData != null : !((Object)this$heightMapData).equals(other$heightMapData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubChunkData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCacheEnabled() ? 79 : 97);
        long $blobId = this.getBlobId();
        result = result * 59 + (int)($blobId >>> 32 ^ $blobId);
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        ByteBuf $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        SubChunkRequestResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)((Object)$result)).hashCode());
        HeightMapDataType $heightMapType = this.getHeightMapType();
        result = result * 59 + ($heightMapType == null ? 43 : ((Object)((Object)$heightMapType)).hashCode());
        ByteBuf $heightMapData = this.getHeightMapData();
        result = result * 59 + ($heightMapData == null ? 43 : ((Object)$heightMapData).hashCode());
        return result;
    }
}

