/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.step.msa;

import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebView;
import javax.swing.JFrame;
import lombok.Generated;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.utils.URLWrapper;
import net.raphimc.minecraftauth.responsehandler.exception.MsaRequestException;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.msa.MsaCodeStep;
import net.raphimc.minecraftauth.util.logging.ILogger;

public class StepJfxWebViewMsaCode
extends MsaCodeStep<JavaFxWebView> {
    private final int timeout;

    public StepJfxWebViewMsaCode(AbstractStep.ApplicationDetails applicationDetails, int timeout) {
        super(applicationDetails);
        this.timeout = timeout;
    }

    @Override
    protected MsaCodeStep.MsaCode execute(ILogger logger, HttpClient httpClient, JavaFxWebView javaFxWebViewCallback) throws Exception {
        logger.info(this, "Opening JavaFX WebView window for MSA login...");
        JFXPanel jfxPanel = new JFXPanel();
        URL authenticationUrl = new URLWrapper(this.applicationDetails.getOAuthEnvironment().getAuthorizeUrl()).wrapQuery().addQueries(this.applicationDetails.getOAuthParameters()).apply().toURL();
        final CompletableFuture msaCodeFuture = new CompletableFuture();
        JFrame window = new JFrame("MinecraftAuth - Microsoft Login");
        window.setDefaultCloseOperation(0);
        window.setSize(800, 600);
        window.setLocationRelativeTo(null);
        window.setResizable(false);
        window.setContentPane((Container)jfxPanel);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!msaCodeFuture.isDone()) {
                    msaCodeFuture.completeExceptionally(new UserClosedWindowException());
                }
            }
        });
        Platform.runLater(() -> {
            WebView webView = new WebView();
            webView.setContextMenuEnabled(false);
            httpClient.getFirstHeader("User-Agent").ifPresent(s -> webView.getEngine().setUserAgent(s));
            webView.getEngine().load(authenticationUrl.toString());
            webView.getEngine().locationProperty().addListener((observable, oldValue, newValue) -> {
                try {
                    if (newValue.startsWith(this.applicationDetails.getRedirectUri())) {
                        Map<String, String> parameters = new URLWrapper((String)newValue).wrapQuery().getQueries();
                        if (parameters.containsKey("error") && parameters.containsKey("error_description")) {
                            HttpResponse fakeResponse = new HttpResponse(null, 500, new byte[0], Collections.emptyMap());
                            throw new MsaRequestException(fakeResponse, parameters.get("error"), parameters.get("error_description"));
                        }
                        if (!parameters.containsKey("code")) {
                            throw new IllegalStateException("Could not extract MSA Code from response url");
                        }
                        msaCodeFuture.complete(new MsaCodeStep.MsaCode(parameters.get("code")));
                    }
                }
                catch (Throwable e) {
                    msaCodeFuture.completeExceptionally(e);
                }
            });
            jfxPanel.setScene(new Scene((Parent)webView, (double)window.getWidth(), (double)window.getHeight()));
            if (javaFxWebViewCallback == null) {
                window.setVisible(true);
            } else {
                javaFxWebViewCallback.openCallback.accept(window, webView);
            }
        });
        try {
            MsaCodeStep.MsaCode msaCode = (MsaCodeStep.MsaCode)msaCodeFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            window.dispose();
            logger.info(this, "Got MSA Code");
            return msaCode;
        }
        catch (TimeoutException e) {
            window.dispose();
            throw new TimeoutException("MSA login timed out");
        }
        catch (ExecutionException e) {
            window.dispose();
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    public static class UserClosedWindowException
    extends Exception {
        public UserClosedWindowException() {
            super("User closed login window");
        }
    }

    public static final class JavaFxWebView
    extends AbstractStep.InitialInput {
        private final BiConsumer<JFrame, WebView> openCallback = (window, webView) -> window.setVisible(true);

        @Generated
        public JavaFxWebView() {
        }

        @Generated
        public BiConsumer<JFrame, WebView> getOpenCallback() {
            return this.openCallback;
        }

        @Generated
        public String toString() {
            return "StepJfxWebViewMsaCode.JavaFxWebView(openCallback=" + this.getOpenCallback() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JavaFxWebView)) {
                return false;
            }
            JavaFxWebView other = (JavaFxWebView)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BiConsumer<JFrame, WebView> this$openCallback = this.getOpenCallback();
            BiConsumer<JFrame, WebView> other$openCallback = other.getOpenCallback();
            return !(this$openCallback == null ? other$openCallback != null : !this$openCallback.equals(other$openCallback));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JavaFxWebView;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BiConsumer<JFrame, WebView> $openCallback = this.getOpenCallback();
            result = result * 59 + ($openCallback == null ? 43 : $openCallback.hashCode());
            return result;
        }
    }
}

