/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.advancement.Advancement;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;

public class ClientboundUpdateAdvancementsPacket
implements MinecraftPacket {
    private static final int FLAG_HAS_BACKGROUND_TEXTURE = 1;
    private static final int FLAG_SHOW_TOAST = 2;
    private static final int FLAG_HIDDEN = 4;
    private final boolean reset;
    @lombok.NonNull
    private final Advancement[] advancements;
    @lombok.NonNull
    private final String[] removedAdvancements;
    @lombok.NonNull
    private final Map<String, Map<String, Long>> progress;

    public Map<String, Long> getProgress(@lombok.NonNull String advancementId) {
        if (advancementId == null) {
            throw new NullPointerException("advancementId is marked non-null but is null");
        }
        return this.progress.get(advancementId);
    }

    public long getAchievedDate(@lombok.NonNull String advancementId, @lombok.NonNull String criterionId) {
        if (advancementId == null) {
            throw new NullPointerException("advancementId is marked non-null but is null");
        }
        if (criterionId == null) {
            throw new NullPointerException("criterionId is marked non-null but is null");
        }
        Map<String, Long> progress = this.getProgress(advancementId);
        if (progress == null || !progress.containsKey(criterionId)) {
            return -1L;
        }
        return progress.get(criterionId);
    }

    public ClientboundUpdateAdvancementsPacket(ByteBuf in, MinecraftCodecHelper helper) {
        int i;
        this.reset = in.readBoolean();
        this.advancements = new Advancement[helper.readVarInt(in)];
        for (i = 0; i < this.advancements.length; ++i) {
            String id = helper.readString(in);
            String parentId = helper.readNullable(in, helper::readString);
            Advancement.DisplayData displayData = helper.readNullable(in, buf -> {
                Component title = helper.readComponent((ByteBuf)buf);
                Component description = helper.readComponent((ByteBuf)buf);
                ItemStack icon = helper.readOptionalItemStack((ByteBuf)buf);
                Advancement.DisplayData.AdvancementType advancementType = Advancement.DisplayData.AdvancementType.from(helper.readVarInt((ByteBuf)buf));
                int flags = buf.readInt();
                boolean hasBackgroundTexture = (flags & 1) != 0;
                boolean showToast = (flags & 2) != 0;
                boolean hidden = (flags & 4) != 0;
                String backgroundTexture = hasBackgroundTexture ? helper.readString((ByteBuf)buf) : null;
                float posX = buf.readFloat();
                float posY = buf.readFloat();
                return new Advancement.DisplayData(title, description, icon, advancementType, showToast, hidden, posX, posY, backgroundTexture);
            });
            List<List<String>> requirements = helper.readList(in, buf -> helper.readList((ByteBuf)buf, helper::readString));
            boolean sendTelemetryEvent = in.readBoolean();
            this.advancements[i] = new Advancement(id, requirements, parentId, displayData, sendTelemetryEvent);
        }
        this.removedAdvancements = new String[helper.readVarInt(in)];
        for (i = 0; i < this.removedAdvancements.length; ++i) {
            this.removedAdvancements[i] = helper.readString(in);
        }
        this.progress = new HashMap<String, Map<String, Long>>();
        int progressCount = helper.readVarInt(in);
        for (int i2 = 0; i2 < progressCount; ++i2) {
            String advancementId = helper.readString(in);
            HashMap<String, Long> advancementProgress = new HashMap<String, Long>();
            int criterionCount = helper.readVarInt(in);
            for (int j = 0; j < criterionCount; ++j) {
                String criterionId = helper.readString(in);
                long achievedDate = in.readBoolean() ? in.readLong() : -1L;
                advancementProgress.put(criterionId, achievedDate);
            }
            this.progress.put(advancementId, advancementProgress);
        }
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeBoolean(this.reset);
        helper.writeVarInt(out, this.advancements.length);
        for (Advancement advancement : this.advancements) {
            helper.writeString(out, advancement.getId());
            if (advancement.getParentId() != null) {
                out.writeBoolean(true);
                helper.writeString(out, advancement.getParentId());
            } else {
                out.writeBoolean(false);
            }
            helper.writeNullable(out, advancement.getDisplayData(), (buf, data) -> {
                helper.writeComponent((ByteBuf)buf, data.getTitle());
                helper.writeComponent((ByteBuf)buf, data.getDescription());
                helper.writeOptionalItemStack((ByteBuf)buf, data.getIcon());
                helper.writeVarInt((ByteBuf)buf, data.getAdvancementType().ordinal());
                int flags = 0;
                if (data.getBackgroundTexture() != null) {
                    flags |= 1;
                }
                if (data.isShowToast()) {
                    flags |= 2;
                }
                if (data.isHidden()) {
                    flags |= 4;
                }
                buf.writeInt(flags);
                if (data.getBackgroundTexture() != null) {
                    helper.writeString((ByteBuf)buf, data.getBackgroundTexture());
                }
                buf.writeFloat(data.getPosX());
                buf.writeFloat(data.getPosY());
            });
            helper.writeList(out, advancement.getRequirements(), (buf, requirement) -> helper.writeList((ByteBuf)buf, requirement, helper::writeString));
            out.writeBoolean(advancement.isSendsTelemetryEvent());
        }
        helper.writeVarInt(out, this.removedAdvancements.length);
        for (String id : this.removedAdvancements) {
            helper.writeString(out, id);
        }
        helper.writeVarInt(out, this.progress.size());
        for (Map.Entry entry : this.progress.entrySet()) {
            helper.writeString(out, (String)entry.getKey());
            Map advancementProgress = (Map)entry.getValue();
            helper.writeVarInt(out, advancementProgress.size());
            for (Map.Entry criterion : advancementProgress.entrySet()) {
                helper.writeString(out, (String)criterion.getKey());
                if ((Long)criterion.getValue() != -1L) {
                    out.writeBoolean(true);
                    out.writeLong(((Long)criterion.getValue()).longValue());
                    continue;
                }
                out.writeBoolean(false);
            }
        }
    }

    public boolean isReset() {
        return this.reset;
    }

    @lombok.NonNull
    public Advancement[] getAdvancements() {
        return this.advancements;
    }

    @lombok.NonNull
    public String[] getRemovedAdvancements() {
        return this.removedAdvancements;
    }

    @lombok.NonNull
    public Map<String, Map<String, Long>> getProgress() {
        return this.progress;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateAdvancementsPacket)) {
            return false;
        }
        ClientboundUpdateAdvancementsPacket other = (ClientboundUpdateAdvancementsPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReset() != other.isReset()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAdvancements(), other.getAdvancements())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getRemovedAdvancements(), other.getRemovedAdvancements())) {
            return false;
        }
        Map<String, Map<String, Long>> this$progress = this.getProgress();
        Map<String, Map<String, Long>> other$progress = other.getProgress();
        return !(this$progress == null ? other$progress != null : !((Object)this$progress).equals(other$progress));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundUpdateAdvancementsPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReset() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getAdvancements());
        result = result * 59 + Arrays.deepHashCode(this.getRemovedAdvancements());
        Map<String, Map<String, Long>> $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : ((Object)$progress).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundUpdateAdvancementsPacket(reset=" + this.isReset() + ", advancements=" + Arrays.deepToString(this.getAdvancements()) + ", removedAdvancements=" + Arrays.deepToString(this.getRemovedAdvancements()) + ", progress=" + this.getProgress() + ")";
    }

    public @NonNull ClientboundUpdateAdvancementsPacket withReset(boolean reset) {
        return this.reset == reset ? this : new ClientboundUpdateAdvancementsPacket(reset, this.advancements, this.removedAdvancements, this.progress);
    }

    public @NonNull ClientboundUpdateAdvancementsPacket withAdvancements(@lombok.NonNull Advancement[] advancements) {
        if (advancements == null) {
            throw new NullPointerException("advancements is marked non-null but is null");
        }
        return this.advancements == advancements ? this : new ClientboundUpdateAdvancementsPacket(this.reset, advancements, this.removedAdvancements, this.progress);
    }

    public @NonNull ClientboundUpdateAdvancementsPacket withRemovedAdvancements(@lombok.NonNull String[] removedAdvancements) {
        if (removedAdvancements == null) {
            throw new NullPointerException("removedAdvancements is marked non-null but is null");
        }
        return this.removedAdvancements == removedAdvancements ? this : new ClientboundUpdateAdvancementsPacket(this.reset, this.advancements, removedAdvancements, this.progress);
    }

    public @NonNull ClientboundUpdateAdvancementsPacket withProgress(@lombok.NonNull Map<String, Map<String, Long>> progress) {
        if (progress == null) {
            throw new NullPointerException("progress is marked non-null but is null");
        }
        return this.progress == progress ? this : new ClientboundUpdateAdvancementsPacket(this.reset, this.advancements, this.removedAdvancements, progress);
    }

    public ClientboundUpdateAdvancementsPacket(boolean reset, @lombok.NonNull Advancement[] advancements, @lombok.NonNull String[] removedAdvancements, @lombok.NonNull Map<String, Map<String, Long>> progress) {
        if (advancements == null) {
            throw new NullPointerException("advancements is marked non-null but is null");
        }
        if (removedAdvancements == null) {
            throw new NullPointerException("removedAdvancements is marked non-null but is null");
        }
        if (progress == null) {
            throw new NullPointerException("progress is marked non-null but is null");
        }
        this.reset = reset;
        this.advancements = advancements;
        this.removedAdvancements = removedAdvancements;
        this.progress = progress;
    }
}

