/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.codec;

import java.util.EnumMap;
import java.util.function.Supplier;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.PacketStateCodec;
import org.geysermc.mcprotocollib.protocol.data.ProtocolState;

public class PacketCodec {
    private final int protocolVersion;
    private final String minecraftVersion;
    private final EnumMap<ProtocolState, PacketStateCodec> stateProtocols;
    private final Supplier<MinecraftCodecHelper> helperFactory;

    public PacketStateCodec getCodec(ProtocolState protocolState) {
        return this.stateProtocols.get((Object)protocolState);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.protocolVersion = this.protocolVersion;
        builder.stateProtocols = this.stateProtocols;
        builder.minecraftVersion = this.minecraftVersion;
        builder.helperFactory = this.helperFactory;
        return builder;
    }

    private PacketCodec(int protocolVersion, String minecraftVersion, EnumMap<ProtocolState, PacketStateCodec> stateProtocols, Supplier<MinecraftCodecHelper> helperFactory) {
        this.protocolVersion = protocolVersion;
        this.minecraftVersion = minecraftVersion;
        this.stateProtocols = stateProtocols;
        this.helperFactory = helperFactory;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public Supplier<MinecraftCodecHelper> getHelperFactory() {
        return this.helperFactory;
    }

    public static class Builder {
        private int protocolVersion = -1;
        private String minecraftVersion = null;
        private EnumMap<ProtocolState, PacketStateCodec> stateProtocols = new EnumMap(ProtocolState.class);
        private Supplier<MinecraftCodecHelper> helperFactory;

        public Builder protocolVersion(int protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder minecraftVersion(String minecraftVersion) {
            this.minecraftVersion = minecraftVersion;
            return this;
        }

        public Builder state(ProtocolState state, PacketStateCodec.Builder protocol) {
            this.stateProtocols.put(state, protocol.build());
            return this;
        }

        public Builder helper(Supplier<MinecraftCodecHelper> helperFactory) {
            this.helperFactory = helperFactory;
            return this;
        }

        public PacketCodec build() {
            return new PacketCodec(this.protocolVersion, this.minecraftVersion, this.stateProtocols, this.helperFactory);
        }
    }
}

