/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network;

import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.network.Flag;
import org.geysermc.mcprotocollib.network.codec.PacketCodecHelper;
import org.geysermc.mcprotocollib.network.crypt.PacketEncryption;
import org.geysermc.mcprotocollib.network.event.session.SessionEvent;
import org.geysermc.mcprotocollib.network.event.session.SessionListener;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.network.packet.PacketProtocol;

public interface Session {
    public void connect();

    public void connect(boolean var1);

    public void connect(boolean var1, boolean var2);

    public String getHost();

    public int getPort();

    public SocketAddress getLocalAddress();

    public SocketAddress getRemoteAddress();

    public PacketProtocol getPacketProtocol();

    public PacketCodecHelper getCodecHelper();

    public Map<String, Object> getFlags();

    public boolean hasFlag(Flag<?> var1);

    public <T> T getFlag(Flag<T> var1);

    public <T> T getFlag(Flag<T> var1, T var2);

    public <T> void setFlag(Flag<T> var1, T var2);

    public void setFlags(Map<String, Object> var1);

    public List<SessionListener> getListeners();

    public void addListener(SessionListener var1);

    public void removeListener(SessionListener var1);

    public void callEvent(SessionEvent var1);

    public void callPacketReceived(Packet var1);

    public void callPacketSent(Packet var1);

    public int getCompressionThreshold();

    public void setCompressionThreshold(int var1, boolean var2);

    public void enableEncryption(PacketEncryption var1);

    public int getConnectTimeout();

    public void setConnectTimeout(int var1);

    public int getReadTimeout();

    public void setReadTimeout(int var1);

    public int getWriteTimeout();

    public void setWriteTimeout(int var1);

    public boolean isConnected();

    public void send(Packet var1);

    default public void disconnect(@NonNull String reason) {
        this.disconnect(reason, null);
    }

    default public void disconnect(@NonNull String reason, @Nullable Throwable cause) {
        this.disconnect(Component.text(reason), cause);
    }

    default public void disconnect(@NonNull Component reason) {
        this.disconnect(reason, null);
    }

    public void disconnect(@NonNull Component var1, @Nullable Throwable var2);
}

