/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import java.util.ArrayList;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityLinkData;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityLinkPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundSetPassengersPacket;

@Translator(packet=ClientboundSetPassengersPacket.class)
public class JavaSetPassengersTranslator
extends PacketTranslator<ClientboundSetPassengersPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSetPassengersPacket packet) {
        Entity entity = session.getEntityCache().getEntityByJavaId(packet.getEntityId());
        if (entity == null) {
            return;
        }
        ArrayList<Entity> newPassengers = new ArrayList<Entity>();
        for (int passengerId : packet.getPassengerIds()) {
            Entity passenger = session.getEntityCache().getEntityByJavaId(passengerId);
            if (passenger == session.getPlayerEntity()) {
                session.getPlayerEntity().setVehicle(entity);
                session.confirmTeleport(passenger.getPosition().sub(0.0f, EntityDefinitions.PLAYER.offset(), 0.0f).toDouble());
            }
            if (passenger == null) continue;
            boolean rider = packet.getPassengerIds()[0] == passengerId;
            EntityLinkData.Type type = rider ? EntityLinkData.Type.RIDER : EntityLinkData.Type.PASSENGER;
            SetEntityLinkPacket linkPacket = new SetEntityLinkPacket();
            linkPacket.setEntityLink(new EntityLinkData(entity.getGeyserId(), passenger.getGeyserId(), type, false, false));
            session.sendUpstreamPacket(linkPacket);
            newPassengers.add(passenger);
            passenger.setVehicle(entity);
            EntityUtils.updateRiderRotationLock(passenger, entity, true);
            EntityUtils.updateMountOffset(passenger, entity, rider, true, packet.getPassengerIds().length > 1);
            passenger.updateBedrockMetadata();
        }
        Object object = entity.getPassengers().iterator();
        while (object.hasNext()) {
            Entity passenger = (Entity)object.next();
            if (passenger == null || newPassengers.contains(passenger)) continue;
            SetEntityLinkPacket linkPacket = new SetEntityLinkPacket();
            linkPacket.setEntityLink(new EntityLinkData(entity.getGeyserId(), passenger.getGeyserId(), EntityLinkData.Type.REMOVE, false, false));
            session.sendUpstreamPacket(linkPacket);
            passenger.setVehicle(null);
            EntityUtils.updateRiderRotationLock(passenger, entity, false);
            EntityUtils.updateMountOffset(passenger, entity, false, false, packet.getPassengerIds().length > 1);
            passenger.updateBedrockMetadata();
            if (passenger != session.getPlayerEntity() || session.getMountVehicleScheduledFuture() == null) continue;
            session.getMountVehicleScheduledFuture().cancel(false);
        }
        entity.setPassengers(newPassengers);
        switch (entity.getDefinition().entityType()) {
            case HORSE: 
            case SKELETON_HORSE: 
            case DONKEY: 
            case MULE: 
            case RAVAGER: {
                entity.getDirtyMetadata().put(EntityDataTypes.SEAT_ROTATION_OFFSET_DEGREES, Float.valueOf(181.0f));
                entity.updateBedrockMetadata();
            }
        }
    }
}

