/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.cloudburstmc.protocol.bedrock.packet.NetworkStackLatencyPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.packet.common.serverbound.ServerboundKeepAlivePacket;

@Translator(packet=NetworkStackLatencyPacket.class)
public class BedrockNetworkStackLatencyTranslator
extends PacketTranslator<NetworkStackLatencyPacket> {
    @Override
    public void translate(GeyserSession session, NetworkStackLatencyPacket packet) {
        if (packet.getTimestamp() >= 0L) {
            if (session.getGeyser().getConfig().isForwardPlayerPing()) {
                Long keepAliveId = session.getKeepAliveCache().poll();
                if (keepAliveId == null) {
                    session.getGeyser().getLogger().debug("Received a latency packet that we don't have a KeepAlive for: " + packet);
                    return;
                }
                ServerboundKeepAlivePacket keepAlivePacket = new ServerboundKeepAlivePacket(keepAliveId);
                session.sendDownstreamPacket(keepAlivePacket);
            }
            return;
        }
        session.scheduleInEventLoop(() -> {
            UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
            attributesPacket.setRuntimeEntityId(session.getPlayerEntity().getGeyserId());
            AttributeData attribute = session.getPlayerEntity().getAttributes().get((Object)GeyserAttributeType.EXPERIENCE_LEVEL);
            if (attribute != null) {
                attributesPacket.setAttributes(Collections.singletonList(attribute));
            } else {
                attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.EXPERIENCE_LEVEL.getAttribute(0.0f)));
            }
            session.sendUpstreamPacket(attributesPacket);
        }, 500L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean shouldExecuteInEventLoop() {
        return false;
    }
}

