/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import java.util.Locale;
import org.cloudburstmc.protocol.bedrock.packet.EntityPickRequestPacket;
import org.geysermc.geyser.entity.type.BoatEntity;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;

@Translator(packet=EntityPickRequestPacket.class)
public class BedrockEntityPickRequestTranslator
extends PacketTranslator<EntityPickRequestPacket> {
    @Override
    public void translate(GeyserSession session, EntityPickRequestPacket packet) {
        Object itemName;
        if (!session.isInstabuild()) {
            return;
        }
        Entity entity = session.getEntityCache().getEntityByGeyserId(packet.getRuntimeEntityId());
        if (entity == null) {
            return;
        }
        switch (entity.getDefinition().entityType()) {
            case BOAT: 
            case CHEST_BOAT: {
                int variant = ((BoatEntity)entity).getVariant();
                String typeOfBoat = switch (variant) {
                    case 1 -> "spruce";
                    case 2 -> "birch";
                    case 3 -> "jungle";
                    case 4 -> "acacia";
                    case 5 -> "cherry";
                    case 6 -> "dark_oak";
                    case 7 -> "mangrove";
                    case 8 -> "bamboo";
                    default -> "oak";
                };
                itemName = typeOfBoat + "_" + entity.getDefinition().entityType().name().toLowerCase(Locale.ROOT);
                if (variant != 8) break;
                itemName = ((String)itemName).replace("boat", "raft");
                break;
            }
            case LEASH_KNOT: {
                itemName = "lead";
                break;
            }
            case CHEST_MINECART: 
            case COMMAND_BLOCK_MINECART: 
            case FURNACE_MINECART: 
            case HOPPER_MINECART: 
            case TNT_MINECART: {
                itemName = entity.getDefinition().identifier();
                break;
            }
            case SPAWNER_MINECART: {
                itemName = "minecart";
                break;
            }
            case ARMOR_STAND: 
            case END_CRYSTAL: 
            case MINECART: 
            case PAINTING: {
                itemName = entity.getDefinition().entityType().toString().toLowerCase(Locale.ROOT);
                break;
            }
            default: {
                itemName = entity.getDefinition().entityType().toString().toLowerCase(Locale.ROOT) + "_spawn_egg";
            }
        }
        String fullItemName = "minecraft:" + (String)itemName;
        ItemMapping mapping = session.getItemMappings().getMapping(fullItemName);
        if (mapping == null) {
            return;
        }
        InventoryUtils.findOrCreateItem(session, fullItemName);
    }
}

