/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import java.util.Arrays;
import java.util.Collections;
import java.util.function.IntFunction;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftCreativeAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.DestroyAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.DropAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.SwapAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.TransferItemStackRequestAction;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.cloudburstmc.protocol.bedrock.packet.ContainerClosePacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerOpenPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventoryContentPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntIterator;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.FakeHeadProvider;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundSetCreativeModeSlotPacket;

public class PlayerInventoryTranslator
extends InventoryTranslator {
    private static final IntFunction<ItemData> UNUSUABLE_CRAFTING_SPACE_BLOCK = InventoryUtils.createUnusableSpaceBlock(GeyserLocale.getLocaleStringLog("geyser.inventory.unusable_item.creative"));

    public PlayerInventoryTranslator() {
        super(46);
    }

    @Override
    public int getGridSize() {
        return 4;
    }

    @Override
    public void updateInventory(GeyserSession session, Inventory inventory) {
        int i;
        PlayerInventoryTranslator.updateCraftingGrid(session, inventory);
        InventoryContentPacket inventoryContentPacket = new InventoryContentPacket();
        inventoryContentPacket.setContainerId(0);
        ItemData[] contents = new ItemData[36];
        for (i = 9; i < 36; ++i) {
            contents[i] = inventory.getItem(i).getItemData(session);
        }
        for (i = 36; i < 45; ++i) {
            contents[i - 36] = inventory.getItem(i).getItemData(session);
        }
        inventoryContentPacket.setContents(Arrays.asList(contents));
        session.sendUpstreamPacket(inventoryContentPacket);
        InventoryContentPacket armorContentPacket = new InventoryContentPacket();
        armorContentPacket.setContainerId(120);
        contents = new ItemData[4];
        for (int i2 = 5; i2 < 9; ++i2) {
            GeyserItemStack item = inventory.getItem(i2);
            contents[i2 - 5] = item.getItemData(session);
            if (i2 != 5 || item.asItem() != Items.PLAYER_HEAD || item.getComponents() == null) continue;
            FakeHeadProvider.setHead(session, session.getPlayerEntity(), item.getComponents());
        }
        armorContentPacket.setContents(Arrays.asList(contents));
        session.sendUpstreamPacket(armorContentPacket);
        InventoryContentPacket offhandPacket = new InventoryContentPacket();
        offhandPacket.setContainerId(119);
        offhandPacket.setContents(Collections.singletonList(inventory.getItem(45).getItemData(session)));
        session.sendUpstreamPacket(offhandPacket);
    }

    public static void updateCraftingGrid(GeyserSession session, Inventory inventory) {
        for (int i = 1; i < 5; ++i) {
            InventorySlotPacket slotPacket = new InventorySlotPacket();
            slotPacket.setContainerId(124);
            slotPacket.setSlot(i + 27);
            if (session.getGameMode() == GameMode.CREATIVE) {
                slotPacket.setItem(UNUSUABLE_CRAFTING_SPACE_BLOCK.apply(session.getUpstream().getProtocolVersion()));
            } else {
                slotPacket.setItem(ItemTranslator.translateToBedrock(session, inventory.getItem(i).getItemStack()));
            }
            session.sendUpstreamPacket(slotPacket);
        }
    }

    @Override
    public void updateSlot(GeyserSession session, Inventory inventory, int slot) {
        GeyserItemStack javaItem = inventory.getItem(slot);
        ItemData bedrockItem = javaItem.getItemData(session);
        if (slot == 5) {
            if (javaItem.asItem() == Items.PLAYER_HEAD && javaItem.getComponents() != null) {
                FakeHeadProvider.setHead(session, session.getPlayerEntity(), javaItem.getComponents());
            } else {
                FakeHeadProvider.restoreOriginalSkin(session, session.getPlayerEntity());
            }
        }
        if (slot >= 1 && slot <= 44) {
            InventorySlotPacket slotPacket = new InventorySlotPacket();
            if (slot >= 9) {
                slotPacket.setContainerId(0);
                if (slot >= 36) {
                    slotPacket.setSlot(slot - 36);
                } else {
                    slotPacket.setSlot(slot);
                }
            } else if (slot >= 5) {
                slotPacket.setContainerId(120);
                slotPacket.setSlot(slot - 5);
            } else {
                slotPacket.setContainerId(124);
                slotPacket.setSlot(slot + 27);
            }
            slotPacket.setItem(bedrockItem);
            session.sendUpstreamPacket(slotPacket);
        } else if (slot == 45) {
            InventoryContentPacket offhandPacket = new InventoryContentPacket();
            offhandPacket.setContainerId(119);
            offhandPacket.setContents(Collections.singletonList(bedrockItem));
            session.sendUpstreamPacket(offhandPacket);
        }
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        int slotnum = slotInfoData.getSlot();
        switch (slotInfoData.getContainer()) {
            case HOTBAR_AND_INVENTORY: 
            case HOTBAR: 
            case INVENTORY: {
                if (slotnum >= 9 && slotnum <= 35) {
                    return slotnum;
                }
                if (slotnum < 0 || slotnum > 8) break;
                return slotnum + 36;
            }
            case ARMOR: {
                if (slotnum < 0 || slotnum > 3) break;
                return slotnum + 5;
            }
            case OFFHAND: {
                return 45;
            }
            case CRAFTING_INPUT: {
                if (slotnum < 28 || 31 < slotnum) break;
                return slotnum - 27;
            }
            case CREATED_OUTPUT: {
                return 0;
            }
        }
        return slotnum;
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        return -1;
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot) {
        if (slot >= 36 && slot <= 44) {
            return new BedrockContainerSlot(ContainerSlotType.HOTBAR, slot - 36);
        }
        if (slot >= 9 && slot <= 35) {
            return new BedrockContainerSlot(ContainerSlotType.INVENTORY, slot);
        }
        if (slot >= 5 && slot <= 8) {
            return new BedrockContainerSlot(ContainerSlotType.ARMOR, slot - 5);
        }
        if (slot == 45) {
            return new BedrockContainerSlot(ContainerSlotType.OFFHAND, 1);
        }
        if (slot >= 1 && slot <= 4) {
            return new BedrockContainerSlot(ContainerSlotType.CRAFTING_INPUT, slot + 27);
        }
        if (slot == 0) {
            return new BedrockContainerSlot(ContainerSlotType.CRAFTING_OUTPUT, 0);
        }
        throw new IllegalArgumentException("Unknown bedrock slot");
    }

    @Override
    public SlotType getSlotType(int javaSlot) {
        if (javaSlot == 0) {
            return SlotType.OUTPUT;
        }
        return SlotType.NORMAL;
    }

    @Override
    public ItemStackResponse translateRequest(GeyserSession session, Inventory inventory, ItemStackRequest request) {
        if (session.getGameMode() != GameMode.CREATIVE) {
            return super.translateRequest(session, inventory, request);
        }
        PlayerInventory playerInv = session.getPlayerInventory();
        IntOpenHashSet affectedSlots = new IntOpenHashSet();
        block6: for (ItemStackRequestAction action : request.getActions()) {
            switch (action.getType()) {
                case TAKE: 
                case PLACE: {
                    int sourceSlot;
                    TransferItemStackRequestAction transferAction = (TransferItemStackRequestAction)action;
                    if (!this.checkNetId(session, inventory, transferAction.getSource()) || !this.checkNetId(session, inventory, transferAction.getDestination())) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    if (PlayerInventoryTranslator.isCraftingGrid(transferAction.getSource()) || PlayerInventoryTranslator.isCraftingGrid(transferAction.getDestination())) {
                        return PlayerInventoryTranslator.rejectRequest(request, false);
                    }
                    int transferAmount = transferAction.getCount();
                    if (PlayerInventoryTranslator.isCursor(transferAction.getDestination())) {
                        sourceSlot = this.bedrockSlotToJava(transferAction.getSource());
                        GeyserItemStack sourceItem = inventory.getItem(sourceSlot);
                        if (playerInv.getCursor().isEmpty()) {
                            playerInv.setCursor(sourceItem.copy(0), session);
                        } else if (!InventoryUtils.canStack(sourceItem, playerInv.getCursor())) {
                            return PlayerInventoryTranslator.rejectRequest(request);
                        }
                        playerInv.getCursor().add(transferAmount);
                        sourceItem.sub(transferAmount);
                        affectedSlots.add(sourceSlot);
                        continue block6;
                    }
                    if (PlayerInventoryTranslator.isCursor(transferAction.getSource())) {
                        int destSlot = this.bedrockSlotToJava(transferAction.getDestination());
                        GeyserItemStack sourceItem = playerInv.getCursor();
                        if (inventory.getItem(destSlot).isEmpty()) {
                            inventory.setItem(destSlot, sourceItem.copy(0), session);
                        } else if (!InventoryUtils.canStack(sourceItem, inventory.getItem(destSlot))) {
                            return PlayerInventoryTranslator.rejectRequest(request);
                        }
                        inventory.getItem(destSlot).add(transferAmount);
                        sourceItem.sub(transferAmount);
                        affectedSlots.add(destSlot);
                        continue block6;
                    }
                    sourceSlot = this.bedrockSlotToJava(transferAction.getSource());
                    int destSlot = this.bedrockSlotToJava(transferAction.getDestination());
                    GeyserItemStack sourceItem = inventory.getItem(sourceSlot);
                    if (inventory.getItem(destSlot).isEmpty()) {
                        inventory.setItem(destSlot, sourceItem.copy(0), session);
                    } else if (!InventoryUtils.canStack(sourceItem, inventory.getItem(destSlot))) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    inventory.getItem(destSlot).add(transferAmount);
                    sourceItem.sub(transferAmount);
                    affectedSlots.add(sourceSlot);
                    affectedSlots.add(destSlot);
                    continue block6;
                }
                case SWAP: {
                    GeyserItemStack destItem;
                    int sourceSlot;
                    SwapAction swapAction = (SwapAction)action;
                    if (!this.checkNetId(session, inventory, swapAction.getSource()) || !this.checkNetId(session, inventory, swapAction.getDestination())) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    if (PlayerInventoryTranslator.isCraftingGrid(swapAction.getSource()) || PlayerInventoryTranslator.isCraftingGrid(swapAction.getDestination())) {
                        return PlayerInventoryTranslator.rejectRequest(request, false);
                    }
                    if (PlayerInventoryTranslator.isCursor(swapAction.getDestination())) {
                        sourceSlot = this.bedrockSlotToJava(swapAction.getSource());
                        GeyserItemStack sourceItem = inventory.getItem(sourceSlot);
                        destItem = playerInv.getCursor();
                        playerInv.setCursor(sourceItem, session);
                        inventory.setItem(sourceSlot, destItem, session);
                        affectedSlots.add(sourceSlot);
                        continue block6;
                    }
                    if (PlayerInventoryTranslator.isCursor(swapAction.getSource())) {
                        int destSlot = this.bedrockSlotToJava(swapAction.getDestination());
                        GeyserItemStack sourceItem = playerInv.getCursor();
                        destItem = inventory.getItem(destSlot);
                        inventory.setItem(destSlot, sourceItem, session);
                        playerInv.setCursor(destItem, session);
                        affectedSlots.add(destSlot);
                        continue block6;
                    }
                    sourceSlot = this.bedrockSlotToJava(swapAction.getSource());
                    int destSlot = this.bedrockSlotToJava(swapAction.getDestination());
                    GeyserItemStack sourceItem = inventory.getItem(sourceSlot);
                    GeyserItemStack destItem2 = inventory.getItem(destSlot);
                    inventory.setItem(destSlot, sourceItem, session);
                    inventory.setItem(sourceSlot, destItem2, session);
                    affectedSlots.add(sourceSlot);
                    affectedSlots.add(destSlot);
                    continue block6;
                }
                case DROP: {
                    GeyserItemStack sourceItem;
                    DropAction dropAction = (DropAction)action;
                    if (!this.checkNetId(session, inventory, dropAction.getSource())) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    if (PlayerInventoryTranslator.isCraftingGrid(dropAction.getSource())) {
                        return PlayerInventoryTranslator.rejectRequest(request, false);
                    }
                    if (PlayerInventoryTranslator.isCursor(dropAction.getSource())) {
                        sourceItem = playerInv.getCursor();
                    } else {
                        int sourceSlot = this.bedrockSlotToJava(dropAction.getSource());
                        sourceItem = inventory.getItem(sourceSlot);
                        affectedSlots.add(sourceSlot);
                    }
                    if (sourceItem.isEmpty()) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    ServerboundSetCreativeModeSlotPacket creativeDropPacket = new ServerboundSetCreativeModeSlotPacket(-1, sourceItem.getItemStack(dropAction.getCount()));
                    session.sendDownstreamGamePacket(creativeDropPacket);
                    sourceItem.sub(dropAction.getCount());
                    continue block6;
                }
                case DESTROY: {
                    DestroyAction destroyAction = (DestroyAction)action;
                    if (!this.checkNetId(session, inventory, destroyAction.getSource())) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    if (PlayerInventoryTranslator.isCraftingGrid(destroyAction.getSource())) {
                        return PlayerInventoryTranslator.rejectRequest(request, false);
                    }
                    if (!PlayerInventoryTranslator.isCursor(destroyAction.getSource())) {
                        int javaSlot = this.bedrockSlotToJava(destroyAction.getSource());
                        GeyserItemStack existingItem = inventory.getItem(javaSlot);
                        existingItem.sub(destroyAction.getCount());
                        affectedSlots.add(javaSlot);
                        continue block6;
                    }
                    playerInv.getCursor().sub(destroyAction.getCount());
                    continue block6;
                }
                default: {
                    session.getGeyser().getLogger().error("Unknown crafting state induced by " + session.bedrockUsername());
                    return PlayerInventoryTranslator.rejectRequest(request);
                }
            }
        }
        IntIterator it = affectedSlots.iterator();
        while (it.hasNext()) {
            int slot = it.nextInt();
            PlayerInventoryTranslator.sendCreativeAction(session, inventory, slot);
        }
        return PlayerInventoryTranslator.acceptRequest(request, this.makeContainerEntries(session, inventory, affectedSlots));
    }

    @Override
    protected ItemStackResponse translateCreativeRequest(GeyserSession session, Inventory inventory, ItemStackRequest request) {
        ItemStack javaCreativeItem = null;
        IntOpenHashSet affectedSlots = new IntOpenHashSet();
        InventoryTranslator.CraftState craftState = InventoryTranslator.CraftState.START;
        block7: for (ItemStackRequestAction action : request.getActions()) {
            switch (action.getType()) {
                case CRAFT_CREATIVE: {
                    CraftCreativeAction creativeAction = (CraftCreativeAction)action;
                    if (craftState != InventoryTranslator.CraftState.START) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    craftState = InventoryTranslator.CraftState.RECIPE_ID;
                    int creativeId = creativeAction.getCreativeItemNetworkId() - 1;
                    ItemData[] creativeItems = session.getItemMappings().getCreativeItems();
                    if (creativeId < 0 || creativeId >= creativeItems.length) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    ItemData creativeItem = creativeItems[creativeId];
                    javaCreativeItem = ItemTranslator.translateToJava(session, creativeItem);
                    continue block7;
                }
                case CRAFT_RESULTS_DEPRECATED: {
                    if (craftState != InventoryTranslator.CraftState.RECIPE_ID) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    craftState = InventoryTranslator.CraftState.DEPRECATED;
                    continue block7;
                }
                case DESTROY: {
                    DestroyAction destroyAction = (DestroyAction)action;
                    if (craftState != InventoryTranslator.CraftState.DEPRECATED) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    int sourceSlot = this.bedrockSlotToJava(destroyAction.getSource());
                    inventory.setItem(sourceSlot, GeyserItemStack.EMPTY, session);
                    affectedSlots.add(sourceSlot);
                    continue block7;
                }
                case TAKE: 
                case PLACE: {
                    TransferItemStackRequestAction transferAction = (TransferItemStackRequestAction)action;
                    if (craftState != InventoryTranslator.CraftState.DEPRECATED && craftState != InventoryTranslator.CraftState.TRANSFER) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    craftState = InventoryTranslator.CraftState.TRANSFER;
                    if (transferAction.getSource().getContainer() != ContainerSlotType.CREATED_OUTPUT) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    if (PlayerInventoryTranslator.isCursor(transferAction.getDestination())) {
                        if (session.getPlayerInventory().getCursor().isEmpty()) {
                            GeyserItemStack newItemStack = GeyserItemStack.from(javaCreativeItem);
                            newItemStack.setAmount(transferAction.getCount());
                            session.getPlayerInventory().setCursor(newItemStack, session);
                            continue block7;
                        }
                        session.getPlayerInventory().getCursor().add(transferAction.getCount());
                        continue block7;
                    }
                    int destSlot = this.bedrockSlotToJava(transferAction.getDestination());
                    if (inventory.getItem(destSlot).isEmpty()) {
                        GeyserItemStack newItemStack = GeyserItemStack.from(javaCreativeItem);
                        newItemStack.setAmount(transferAction.getCount());
                        inventory.setItem(destSlot, newItemStack, session);
                    } else {
                        inventory.getItem(destSlot).add(transferAction.getCount());
                    }
                    affectedSlots.add(destSlot);
                    continue block7;
                }
                case DROP: {
                    if (craftState != InventoryTranslator.CraftState.DEPRECATED) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    DropAction dropAction = (DropAction)action;
                    if (dropAction.getSource().getContainer() != ContainerSlotType.CREATED_OUTPUT || dropAction.getSource().getSlot() != 50) {
                        return PlayerInventoryTranslator.rejectRequest(request);
                    }
                    ItemStack dropStack = dropAction.getCount() == javaCreativeItem.getAmount() ? javaCreativeItem : new ItemStack(javaCreativeItem.getId(), dropAction.getCount(), javaCreativeItem.getDataComponents());
                    ServerboundSetCreativeModeSlotPacket creativeDropPacket = new ServerboundSetCreativeModeSlotPacket(-1, dropStack);
                    session.sendDownstreamGamePacket(creativeDropPacket);
                    continue block7;
                }
                default: {
                    return PlayerInventoryTranslator.rejectRequest(request);
                }
            }
        }
        IntIterator it = affectedSlots.iterator();
        while (it.hasNext()) {
            int slot = it.nextInt();
            PlayerInventoryTranslator.sendCreativeAction(session, inventory, slot);
        }
        return PlayerInventoryTranslator.acceptRequest(request, this.makeContainerEntries(session, inventory, affectedSlots));
    }

    private static void sendCreativeAction(GeyserSession session, Inventory inventory, int slot) {
        GeyserItemStack item = inventory.getItem(slot);
        ItemStack itemStack = item.isEmpty() ? new ItemStack(-1, 0, null) : item.getItemStack();
        ServerboundSetCreativeModeSlotPacket creativePacket = new ServerboundSetCreativeModeSlotPacket((short)slot, itemStack);
        session.sendDownstreamGamePacket(creativePacket);
    }

    private static boolean isCraftingGrid(ItemStackRequestSlotData slotInfoData) {
        return slotInfoData.getContainer() == ContainerSlotType.CRAFTING_INPUT;
    }

    @Override
    public Inventory createInventory(String name, int windowId, ContainerType containerType, PlayerInventory playerInventory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean prepareInventory(GeyserSession session, Inventory inventory) {
        return true;
    }

    @Override
    public void openInventory(GeyserSession session, Inventory inventory) {
        ContainerOpenPacket containerOpenPacket = new ContainerOpenPacket();
        containerOpenPacket.setId((byte)0);
        containerOpenPacket.setType(org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType.INVENTORY);
        containerOpenPacket.setUniqueEntityId(-1L);
        containerOpenPacket.setBlockPosition(session.getPlayerEntity().getPosition().toInt());
        session.sendUpstreamPacket(containerOpenPacket);
    }

    @Override
    public void closeInventory(GeyserSession session, Inventory inventory) {
        ContainerClosePacket packet = new ContainerClosePacket();
        packet.setServerInitiated(true);
        packet.setId((byte)0);
        packet.setType(org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType.INVENTORY);
        session.sendUpstreamPacket(packet);
    }

    @Override
    public void updateProperty(GeyserSession session, Inventory inventory, int key, int value) {
    }
}

