/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.Arrays;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.IntArrays;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.BlockTag;
import org.geysermc.geyser.session.cache.tags.EnchantmentTag;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.geyser.util.Ordered;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundUpdateTagsPacket;

@ParametersAreNonnullByDefault
public final class TagCache {
    private final int[][] blocks = new int[BlockTag.ALL_BLOCK_TAGS.size()][];
    private final int[][] items = new int[ItemTag.ALL_ITEM_TAGS.size()][];
    private final int[][] enchantments = new int[EnchantmentTag.ALL_ENCHANTMENT_TAGS.size()][];

    public void loadPacket(GeyserSession session, ClientboundUpdateTagsPacket packet) {
        Map<Key, int[]> blockTags = packet.getTags().get(MinecraftKey.key("block"));
        this.loadTags("Block", blockTags, BlockTag.ALL_BLOCK_TAGS, this.blocks);
        GeyserLogger logger = session.getGeyser().getLogger();
        int[] convertableToMud = blockTags.get(MinecraftKey.key("convertable_to_mud"));
        boolean emulatePost1_18Logic = convertableToMud != null && convertableToMud.length != 0;
        session.setEmulatePost1_18Logic(emulatePost1_18Logic);
        if (logger.isDebug()) {
            logger.debug("Emulating post 1.18 block predication logic for " + session.bedrockUsername() + "? " + emulatePost1_18Logic);
        }
        Map<Key, int[]> itemTags = packet.getTags().get(MinecraftKey.key("item"));
        this.loadTags("Item", itemTags, ItemTag.ALL_ITEM_TAGS, this.items);
        boolean emulatePost1_13Logic = itemTags.get(MinecraftKey.key("signs")).length > 1;
        session.setEmulatePost1_13Logic(emulatePost1_13Logic);
        if (logger.isDebug()) {
            logger.debug("Emulating post 1.13 villager logic for " + session.bedrockUsername() + "? " + emulatePost1_13Logic);
        }
        Map<Key, int[]> enchantmentTags = packet.getTags().get(MinecraftKey.key("enchantment"));
        this.loadTags("Enchantment", enchantmentTags, EnchantmentTag.ALL_ENCHANTMENT_TAGS, this.enchantments);
    }

    private <T extends Ordered> void loadTags(String type, @Nullable Map<Key, int[]> packetTags, Map<Key, T> allTags, int[][] localValues) {
        if (packetTags == null) {
            Arrays.fill((Object[])localValues, IntArrays.EMPTY_ARRAY);
            GeyserImpl.getInstance().getLogger().debug("Not loading " + type + " tags; they do not exist here.");
            return;
        }
        allTags.forEach((location, tag) -> {
            int[] values = (int[])packetTags.get(location);
            if (values != null) {
                localValues[tag.ordinal()] = values.length != 0 ? values : IntArrays.EMPTY_ARRAY;
            } else {
                localValues[tag.ordinal()] = IntArrays.EMPTY_ARRAY;
                GeyserImpl.getInstance().getLogger().debug(type + " tag not found from server: " + location);
            }
        });
    }

    public boolean is(BlockTag tag, Block block) {
        int[] values = this.blocks[tag.ordinal()];
        return TagCache.contains(values, block.javaId());
    }

    public boolean is(ItemTag tag, GeyserItemStack itemStack) {
        return this.is(tag, itemStack.asItem());
    }

    public boolean is(ItemTag tag, Item item) {
        int[] values = this.items[tag.ordinal()];
        return TagCache.contains(values, item.javaId());
    }

    public int[] get(ItemTag itemTag) {
        return this.items[itemTag.ordinal()];
    }

    public int[] get(EnchantmentTag enchantmentTag) {
        return this.enchantments[enchantmentTag.ordinal()];
    }

    private static boolean contains(int[] array, int i) {
        for (int item : array) {
            if (item != i) continue;
            return true;
        }
        return false;
    }
}

