/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.codec.v594.Bedrock_v594;
import org.cloudburstmc.protocol.bedrock.data.BlockPropertyData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockPermutation;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.component.BoxComponent;
import org.geysermc.geyser.api.block.custom.component.CustomBlockComponents;
import org.geysermc.geyser.api.block.custom.component.MaterialInstance;
import org.geysermc.geyser.api.block.custom.component.PlacementConditions;
import org.geysermc.geyser.api.block.custom.nonvanilla.JavaBlockState;
import org.geysermc.geyser.api.block.custom.property.CustomBlockProperty;
import org.geysermc.geyser.api.block.custom.property.PropertyType;
import org.geysermc.geyser.api.event.lifecycle.GeyserDefineCustomBlocksEvent;
import org.geysermc.geyser.api.util.CreativeCategory;
import org.geysermc.geyser.level.block.GeyserCustomBlockComponents;
import org.geysermc.geyser.level.block.GeyserCustomBlockData;
import org.geysermc.geyser.level.block.GeyserCustomBlockState;
import org.geysermc.geyser.level.block.GeyserGeometryComponent;
import org.geysermc.geyser.level.block.GeyserMaterialInstance;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.mappings.MappingsConfigReader;
import org.geysermc.geyser.registry.type.CustomSkull;
import org.geysermc.geyser.util.MathUtils;

public class CustomBlockRegistryPopulator {
    public static AtomicInteger BLOCK_ID = new AtomicInteger();
    public static final int START_OFFSET = 10000;
    private static Set<CustomBlockData> CUSTOM_BLOCKS;
    private static Map<String, CustomBlockData> CUSTOM_BLOCK_ITEM_OVERRIDES;
    private static Map<JavaBlockState, CustomBlockState> NON_VANILLA_BLOCK_STATE_OVERRIDES;
    private static Map<String, CustomBlockState> BLOCK_STATE_OVERRIDES_QUEUE;

    public static void populate(Stage stage) {
        if (!GeyserImpl.getInstance().getConfig().isAddNonBedrockItems()) {
            return;
        }
        switch (stage) {
            case DEFINITION: {
                CustomBlockRegistryPopulator.populateBedrock();
                break;
            }
            case VANILLA_REGISTRATION: {
                CustomBlockRegistryPopulator.populateVanilla();
                break;
            }
            case NON_VANILLA_REGISTRATION: {
                CustomBlockRegistryPopulator.populateNonVanilla();
                break;
            }
            case CUSTOM_REGISTRATION: {
                CustomBlockRegistryPopulator.registration();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown stage: " + stage);
            }
        }
    }

    private static void populateBedrock() {
        CUSTOM_BLOCKS = new ObjectOpenHashSet<CustomBlockData>();
        CUSTOM_BLOCK_ITEM_OVERRIDES = new HashMap<String, CustomBlockData>();
        NON_VANILLA_BLOCK_STATE_OVERRIDES = new HashMap<JavaBlockState, CustomBlockState>();
        BLOCK_STATE_OVERRIDES_QUEUE = new HashMap<String, CustomBlockState>();
        final ObjectOpenHashSet customBlockIdentifiers = new ObjectOpenHashSet();
        GeyserImpl.getInstance().getEventBus().fire(new GeyserDefineCustomBlocksEvent(){

            @Override
            public void register(@NonNull CustomBlockData customBlockData) {
                if (customBlockData.name().isEmpty()) {
                    throw new IllegalArgumentException("Custom block name must have at least 1 character.");
                }
                if (!customBlockIdentifiers.add(customBlockData.identifier())) {
                    throw new IllegalArgumentException("Another custom block was already registered under the identifier: " + customBlockData.identifier());
                }
                if (Character.isDigit(customBlockData.name().charAt(0))) {
                    throw new IllegalArgumentException("Custom block can not start with a digit. Name: " + customBlockData.name());
                }
                CUSTOM_BLOCKS.add(customBlockData);
            }

            @Override
            public void registerOverride(@NonNull String javaIdentifier, @NonNull CustomBlockState customBlockState) {
                if (!CUSTOM_BLOCKS.contains(customBlockState.block())) {
                    throw new IllegalArgumentException("Custom block is unregistered. Name: " + customBlockState.name());
                }
                BLOCK_STATE_OVERRIDES_QUEUE.put(javaIdentifier, customBlockState);
            }

            @Override
            public void registerItemOverride(@NonNull String javaIdentifier, @NonNull CustomBlockData customBlockData) {
                if (!CUSTOM_BLOCKS.contains(customBlockData)) {
                    throw new IllegalArgumentException("Custom block is unregistered. Name: " + customBlockData.name());
                }
                CUSTOM_BLOCK_ITEM_OVERRIDES.put(javaIdentifier, customBlockData);
            }

            @Override
            public void registerOverride(@NonNull JavaBlockState javaBlockState, @NonNull CustomBlockState customBlockState) {
                if (!CUSTOM_BLOCKS.contains(customBlockState.block())) {
                    throw new IllegalArgumentException("Custom block is unregistered. Name: " + customBlockState.name());
                }
                NON_VANILLA_BLOCK_STATE_OVERRIDES.put(javaBlockState, customBlockState);
            }
        });
    }

    private static void populateVanilla() {
        Int2ObjectOpenHashMap<CustomBlockState> blockStateOverrides = new Int2ObjectOpenHashMap<CustomBlockState>();
        for (CustomSkull customSkull : ((Map)BlockRegistries.CUSTOM_SKULLS.get()).values()) {
            CUSTOM_BLOCKS.add(customSkull.getCustomBlockData());
        }
        for (Map.Entry entry : BLOCK_STATE_OVERRIDES_QUEUE.entrySet()) {
            int id = BlockRegistries.JAVA_IDENTIFIER_TO_ID.getOrDefault((String)entry.getKey(), -1);
            if (id == -1) {
                GeyserImpl.getInstance().getLogger().warning("Custom block state override for Java Identifier: " + (String)entry.getKey() + " could not be registered as it is not a valid block state.");
                continue;
            }
            CustomBlockState oldBlockState = blockStateOverrides.put(id, (CustomBlockState)entry.getValue());
            if (oldBlockState == null) continue;
            GeyserImpl.getInstance().getLogger().warning("Duplicate block state override for Java Identifier: " + (String)entry.getKey() + " Old override: " + oldBlockState.name() + " New override: " + ((CustomBlockState)entry.getValue()).name());
        }
        BLOCK_STATE_OVERRIDES_QUEUE = null;
        HashMap extendedCollisionBoxes = new HashMap();
        HashMap hashMap = new HashMap();
        MappingsConfigReader mappingsConfigReader = new MappingsConfigReader();
        mappingsConfigReader.loadBlockMappingsFromJson((key, block) -> {
            CUSTOM_BLOCKS.add(block.data());
            if (block.overrideItem()) {
                CUSTOM_BLOCK_ITEM_OVERRIDES.put(block.javaIdentifier(), block.data());
            }
            block.states().forEach((javaIdentifier, customBlockState) -> {
                int id = BlockRegistries.JAVA_IDENTIFIER_TO_ID.getOrDefault((String)javaIdentifier, -1);
                blockStateOverrides.put(id, customBlockState.state());
                BoxComponent extendedCollisionBox = customBlockState.extendedCollisionBox();
                if (extendedCollisionBox != null) {
                    CustomBlockData extendedCollisionBlock = extendedCollisionBoxSet.computeIfAbsent(extendedCollisionBox, box -> {
                        CustomBlockData collisionBlock = CustomBlockRegistryPopulator.createExtendedCollisionBlock(box, extendedCollisionBoxSet.size());
                        CUSTOM_BLOCKS.add(collisionBlock);
                        return collisionBlock;
                    });
                    extendedCollisionBoxes.computeIfAbsent(extendedCollisionBlock, k -> new HashSet()).add(id);
                }
            });
        });
        BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.set(blockStateOverrides);
        if (!blockStateOverrides.isEmpty()) {
            GeyserImpl.getInstance().getLogger().info("Registered " + blockStateOverrides.size() + " custom block overrides.");
        }
        BlockRegistries.CUSTOM_BLOCK_ITEM_OVERRIDES.set(CUSTOM_BLOCK_ITEM_OVERRIDES);
        if (!CUSTOM_BLOCK_ITEM_OVERRIDES.isEmpty()) {
            GeyserImpl.getInstance().getLogger().info("Registered " + CUSTOM_BLOCK_ITEM_OVERRIDES.size() + " custom block item overrides.");
        }
        BlockRegistries.EXTENDED_COLLISION_BOXES.set(extendedCollisionBoxes);
        if (!extendedCollisionBoxes.isEmpty()) {
            GeyserImpl.getInstance().getLogger().info("Registered " + extendedCollisionBoxes.size() + " custom block extended collision boxes.");
        }
    }

    private static void populateNonVanilla() {
        BlockRegistries.NON_VANILLA_BLOCK_STATE_OVERRIDES.set(NON_VANILLA_BLOCK_STATE_OVERRIDES);
        if (!NON_VANILLA_BLOCK_STATE_OVERRIDES.isEmpty()) {
            GeyserImpl.getInstance().getLogger().info("Registered " + NON_VANILLA_BLOCK_STATE_OVERRIDES.size() + " non-vanilla block overrides.");
        }
    }

    private static void registration() {
        BlockRegistries.CUSTOM_BLOCKS.set((CustomBlockData)CUSTOM_BLOCKS.toArray(new CustomBlockData[0]));
        if (!CUSTOM_BLOCKS.isEmpty()) {
            GeyserImpl.getInstance().getLogger().info("Registered " + CUSTOM_BLOCKS.size() + " custom blocks.");
        }
    }

    static void generateCustomBlockStates(CustomBlockData customBlock, List<NbtMap> blockStates, List<CustomBlockState> customExtBlockStates) {
        int totalPermutations = 1;
        for (CustomBlockProperty<?> property : customBlock.properties().values()) {
            totalPermutations *= property.values().size();
        }
        for (int i = 0; i < totalPermutations; ++i) {
            NbtMapBuilder statesBuilder = NbtMap.builder();
            int permIndex = i;
            for (CustomBlockProperty<?> property : customBlock.properties().values()) {
                statesBuilder.put(property.name(), property.values().get(permIndex % property.values().size()));
                permIndex /= property.values().size();
            }
            NbtMap states = statesBuilder.build();
            blockStates.add(NbtMap.builder().putString("name", customBlock.identifier()).putCompound("states", states).build());
            customExtBlockStates.add(new GeyserCustomBlockState(customBlock, states));
        }
    }

    static BlockPropertyData generateBlockPropertyData(CustomBlockData customBlock, int protocolVersion) {
        ArrayList<NbtMap> permutations = new ArrayList<NbtMap>();
        for (CustomBlockPermutation customBlockPermutation : customBlock.permutations()) {
            permutations.add(NbtMap.builder().putCompound("components", CustomBlockRegistryPopulator.convertComponents(customBlockPermutation.components(), protocolVersion)).putString("condition", customBlockPermutation.condition()).build());
        }
        ArrayList<NbtMap> properties = new ArrayList<NbtMap>();
        for (CustomBlockProperty<?> customBlockProperty : customBlock.properties().values()) {
            NbtMapBuilder propertyBuilder = NbtMap.builder().putString("name", customBlockProperty.name());
            if (customBlockProperty.type() == PropertyType.booleanProp()) {
                propertyBuilder.putList("enum", NbtType.BYTE, List.of(Byte.valueOf((byte)0), Byte.valueOf((byte)1)));
            } else if (customBlockProperty.type() == PropertyType.integerProp()) {
                propertyBuilder.putList("enum", NbtType.INT, customBlockProperty.values());
            } else if (customBlockProperty.type() == PropertyType.stringProp()) {
                propertyBuilder.putList("enum", NbtType.STRING, customBlockProperty.values());
            }
            properties.add(propertyBuilder.build());
        }
        CreativeCategory creativeCategory = customBlock.creativeCategory() != null ? customBlock.creativeCategory() : CreativeCategory.NONE;
        String string = customBlock.creativeGroup() != null ? customBlock.creativeGroup() : "";
        NbtMapBuilder propertyTag = NbtMap.builder().putCompound("components", CustomBlockRegistryPopulator.convertComponents(customBlock.components(), protocolVersion)).putCompound("menu_category", NbtMap.builder().putString("category", creativeCategory.internalName()).putString("group", string).putBoolean("is_hidden_in_commands", false).build()).putInt("molangVersion", 1).putList("permutations", NbtType.COMPOUND, permutations).putList("properties", NbtType.COMPOUND, properties).putCompound("vanilla_block_data", NbtMap.builder().putInt("block_id", BLOCK_ID.getAndIncrement()).build());
        return new BlockPropertyData(customBlock.identifier(), propertyTag.build());
    }

    private static NbtMap convertComponents(CustomBlockComponents components, int protocolVersion) {
        if (components == null) {
            return NbtMap.EMPTY;
        }
        NbtMapBuilder builder = NbtMap.builder();
        if (components.displayName() != null) {
            builder.putCompound("minecraft:display_name", NbtMap.builder().putString("value", components.displayName()).build());
        }
        if (components.selectionBox() != null) {
            builder.putCompound("minecraft:selection_box", CustomBlockRegistryPopulator.convertBox(components.selectionBox()));
        }
        if (components.collisionBox() != null) {
            builder.putCompound("minecraft:collision_box", CustomBlockRegistryPopulator.convertBox(components.collisionBox()));
        }
        if (components.geometry() != null) {
            NbtMapBuilder geometryBuilder = NbtMap.builder();
            if (protocolVersion >= Bedrock_v594.CODEC.getProtocolVersion()) {
                geometryBuilder.putString("identifier", components.geometry().identifier());
                if (components.geometry().boneVisibility() != null) {
                    NbtMapBuilder boneVisibilityBuilder = NbtMap.builder();
                    components.geometry().boneVisibility().entrySet().forEach(entry -> boneVisibilityBuilder.putString((String)entry.getKey(), (String)entry.getValue()));
                    geometryBuilder.putCompound("bone_visibility", boneVisibilityBuilder.build());
                }
            } else {
                geometryBuilder.putString("value", components.geometry().identifier());
            }
            builder.putCompound("minecraft:geometry", geometryBuilder.build());
        }
        if (!components.materialInstances().isEmpty()) {
            NbtMapBuilder materialsBuilder = NbtMap.builder();
            for (Map.Entry<String, MaterialInstance> entry2 : components.materialInstances().entrySet()) {
                MaterialInstance materialInstance = entry2.getValue();
                NbtMapBuilder materialBuilder = NbtMap.builder().putString("render_method", materialInstance.renderMethod()).putBoolean("face_dimming", materialInstance.faceDimming()).putBoolean("ambient_occlusion", materialInstance.faceDimming());
                if (materialInstance.texture() != null) {
                    materialBuilder.putString("texture", materialInstance.texture());
                }
                materialsBuilder.putCompound(entry2.getKey(), materialBuilder.build());
            }
            builder.putCompound("minecraft:material_instances", NbtMap.builder().putCompound("mappings", NbtMap.EMPTY).putCompound("materials", materialsBuilder.build()).build());
        }
        if (components.placementFilter() != null) {
            builder.putCompound("minecraft:placement_filter", NbtMap.builder().putList("conditions", NbtType.COMPOUND, CustomBlockRegistryPopulator.convertPlacementFilter(components.placementFilter())).build());
        }
        if (components.destructibleByMining() != null) {
            builder.putCompound("minecraft:destructible_by_mining", NbtMap.builder().putFloat("value", components.destructibleByMining().floatValue()).build());
        }
        if (components.friction() != null) {
            builder.putCompound("minecraft:friction", NbtMap.builder().putFloat("value", components.friction().floatValue()).build());
        }
        if (components.lightEmission() != null) {
            builder.putCompound("minecraft:light_emission", NbtMap.builder().putByte("emission", components.lightEmission().byteValue()).build());
        }
        if (components.lightDampening() != null) {
            builder.putCompound("minecraft:light_dampening", NbtMap.builder().putByte("lightLevel", components.lightDampening().byteValue()).build());
        }
        if (components.transformation() != null) {
            builder.putCompound("minecraft:transformation", NbtMap.builder().putInt("RX", MathUtils.unwrapDegreesToInt(components.transformation().rx()) / 90).putInt("RY", MathUtils.unwrapDegreesToInt(components.transformation().ry()) / 90).putInt("RZ", MathUtils.unwrapDegreesToInt(components.transformation().rz()) / 90).putFloat("SX", components.transformation().sx()).putFloat("SY", components.transformation().sy()).putFloat("SZ", components.transformation().sz()).putFloat("TX", components.transformation().tx()).putFloat("TY", components.transformation().ty()).putFloat("TZ", components.transformation().tz()).build());
        }
        if (components.placeAir()) {
            builder.putCompound("minecraft:on_player_placing", NbtMap.builder().putString("triggerType", "geyser:place_event").build());
        }
        if (!components.tags().isEmpty()) {
            components.tags().forEach(tag -> builder.putCompound("tag:" + tag, NbtMap.EMPTY));
        }
        return builder.build();
    }

    private static NbtMap convertBox(BoxComponent boxComponent) {
        return NbtMap.builder().putBoolean("enabled", !boxComponent.isEmpty()).putList("origin", NbtType.FLOAT, Float.valueOf(boxComponent.originX()), Float.valueOf(boxComponent.originY()), Float.valueOf(boxComponent.originZ())).putList("size", NbtType.FLOAT, Float.valueOf(boxComponent.sizeX()), Float.valueOf(boxComponent.sizeY()), Float.valueOf(boxComponent.sizeZ())).build();
    }

    private static List<NbtMap> convertPlacementFilter(List<PlacementConditions> placementFilter) {
        ArrayList<NbtMap> conditions = new ArrayList<NbtMap>();
        placementFilter.forEach(condition -> {
            NbtMapBuilder conditionBuilder = NbtMap.builder();
            byte allowedFaces = 0;
            for (PlacementConditions.Face face : condition.allowedFaces()) {
                allowedFaces = (byte)(allowedFaces | 1 << face.ordinal());
            }
            conditionBuilder.putByte("allowed_faces", allowedFaces);
            ArrayList blockFilters = new ArrayList();
            condition.blockFilters().forEach((value, type) -> {
                NbtMapBuilder blockFilterBuilder = NbtMap.builder();
                switch (type) {
                    case BLOCK: {
                        blockFilterBuilder.putString("name", (String)value);
                        break;
                    }
                    case TAG: {
                        blockFilterBuilder.putString("tags", (String)value).putInt("tags_version", 6);
                    }
                }
                blockFilters.add(blockFilterBuilder.build());
            });
            conditionBuilder.putList("block_filters", NbtType.COMPOUND, blockFilters);
            conditions.add(conditionBuilder.build());
        });
        return conditions;
    }

    private static CustomBlockData createExtendedCollisionBlock(BoxComponent boxComponent, int extendedCollisionBlock) {
        return new GeyserCustomBlockData.Builder().name("extended_collision_" + extendedCollisionBlock).components(new GeyserCustomBlockComponents.Builder().collisionBox(boxComponent).selectionBox(BoxComponent.emptyBox()).materialInstance("*", new GeyserMaterialInstance.Builder().texture("glass").renderMethod("alpha_test").faceDimming(false).ambientOcclusion(false).build()).lightDampening(0).geometry(new GeyserGeometryComponent.Builder().identifier("geometry.invisible").build()).build()).build();
    }

    public static enum Stage {
        DEFINITION,
        VANILLA_REGISTRATION,
        NON_VANILLA_REGISTRATION,
        CUSTOM_REGISTRATION;

    }
}

