/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block.type;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.level.block.property.Property;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.registry.BlockRegistries;

public final class BlockState {
    private final Block block;
    private final int javaId;
    private final Comparable<?>[] states;

    public BlockState(Block block, int javaId) {
        this(block, javaId, null);
    }

    BlockState(Block block, int javaId, Comparable<?>[] states) {
        this.block = block;
        this.javaId = javaId;
        this.states = states;
    }

    public <T extends Comparable<T>> T getValue(Property<T> property) {
        return (T)this.get(property);
    }

    public <T extends Comparable<T>> T getValueNullable(Property<T> property) {
        Comparable<?> value = this.get(property);
        if (value == null) {
            return null;
        }
        return (T)this.get(property);
    }

    public <T extends Comparable<T>> T getValue(Property<T> property, T def) {
        Comparable<?> value = this.get(property);
        if (value == null) {
            return def;
        }
        return (T)value;
    }

    private @Nullable Comparable<?> get(Property<?> property) {
        Property<?>[] keys = this.block.propertyKeys();
        if (keys == null) {
            return null;
        }
        int i = keys.length;
        while (i-- != 0) {
            if (keys[i] != property) continue;
            return this.states[i];
        }
        return null;
    }

    public <T extends Comparable<T>> BlockState withValue(Property<T> property, T value) {
        Property<?>[] keys = this.block.propertyKeys();
        if (keys == null) {
            throw new IllegalStateException(this + " does not have any different states!");
        }
        T currentValue = this.getValue(property);
        if (currentValue == null) {
            throw new IllegalArgumentException("This BlockState does not have the property " + property);
        }
        if (currentValue.equals(value)) {
            return this;
        }
        int diff = 0;
        for (int i = keys.length - 1; i >= 0 && keys[i] != property; --i) {
            diff += keys[i].valuesCount();
        }
        int thatOffset = property.indexOf(value);
        int thisOffset = property.indexOf(currentValue);
        if (diff == 0) {
            diff = 1;
        }
        return BlockState.of(this.javaId + (thatOffset - thisOffset) * diff);
    }

    public Block block() {
        return this.block;
    }

    public int javaId() {
        return this.javaId;
    }

    public boolean is(Block block) {
        return this.block == block;
    }

    public String toString() {
        if (this.states == null) {
            return this.block.javaIdentifier().toString();
        }
        return this.block.javaIdentifier().toString() + "[" + this.paramsToString() + "]";
    }

    private String paramsToString() {
        StringBuilder builder = new StringBuilder();
        Property<?>[] propertyKeys = this.block.propertyKeys();
        if (propertyKeys != null) {
            for (int i = 0; i < propertyKeys.length; ++i) {
                builder.append(propertyKeys[i].name()).append("=").append(this.states[i].toString().toLowerCase(Locale.ROOT));
                if (i >= propertyKeys.length - 1) continue;
                builder.append(",");
            }
        }
        return builder.toString();
    }

    public static @NonNull BlockState of(int javaId) {
        return BlockRegistries.BLOCK_STATES.getOrDefault(javaId, BlockRegistries.BLOCK_STATES.get(0));
    }
}

