/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.impl.camera;

import java.util.List;
import org.cloudburstmc.protocol.bedrock.data.camera.CameraAudioListener;
import org.cloudburstmc.protocol.bedrock.data.camera.CameraPreset;
import org.cloudburstmc.protocol.common.DefinitionRegistry;
import org.cloudburstmc.protocol.common.NamedDefinition;
import org.cloudburstmc.protocol.common.SimpleDefinitionRegistry;
import org.cloudburstmc.protocol.common.util.OptionalBoolean;
import org.geysermc.geyser.api.bedrock.camera.CameraPerspective;

public class CameraDefinitions {
    public static final DefinitionRegistry<NamedDefinition> CAMERA_DEFINITIONS;
    public static final List<CameraPreset> CAMERA_PRESETS;

    public static NamedDefinition getById(int id) {
        return CAMERA_DEFINITIONS.getDefinition(id);
    }

    public static NamedDefinition getByFunctionality(boolean audio, boolean effects) {
        if (!audio && !effects) {
            return CameraDefinitions.getById(1);
        }
        if (audio) {
            if (effects) {
                return CameraDefinitions.getById(6);
            }
            return CameraDefinitions.getById(4);
        }
        return CameraDefinitions.getById(5);
    }

    static {
        CAMERA_PRESETS = List.of(new CameraPreset(CameraPerspective.FIRST_PERSON.id(), "", null, null, null, null, OptionalBoolean.empty()), new CameraPreset(CameraPerspective.FREE.id(), "", null, null, null, null, OptionalBoolean.empty()), new CameraPreset(CameraPerspective.THIRD_PERSON.id(), "", null, null, null, null, OptionalBoolean.empty()), new CameraPreset(CameraPerspective.THIRD_PERSON_FRONT.id(), "", null, null, null, null, OptionalBoolean.empty()), new CameraPreset("geyser:free_audio", "minecraft:free", null, null, null, CameraAudioListener.PLAYER, OptionalBoolean.of(false)), new CameraPreset("geyser:free_effects", "minecraft:free", null, null, null, CameraAudioListener.CAMERA, OptionalBoolean.of(true)), new CameraPreset("geyser:free_audio_effects", "minecraft:free", null, null, null, CameraAudioListener.PLAYER, OptionalBoolean.of(true)));
        SimpleDefinitionRegistry.Builder<CameraDefinition> builder = SimpleDefinitionRegistry.builder();
        for (int i = 0; i < CAMERA_PRESETS.size(); ++i) {
            builder.add(CameraDefinition.of(CAMERA_PRESETS.get(i).getIdentifier(), i));
        }
        CAMERA_DEFINITIONS = builder.build();
    }

    public record CameraDefinition(String identifier, int runtimeId) implements NamedDefinition
    {
        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public int getRuntimeId() {
            return this.runtimeId;
        }

        public static CameraDefinition of(String identifier, int runtimeId) {
            return new CameraDefinition(identifier, runtimeId);
        }
    }
}

