/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.status.clientbound;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.DefaultComponentSerializer;
import org.geysermc.mcprotocollib.protocol.data.status.PlayerInfo;
import org.geysermc.mcprotocollib.protocol.data.status.ServerStatusInfo;
import org.geysermc.mcprotocollib.protocol.data.status.VersionInfo;

public class ClientboundStatusResponsePacket
implements MinecraftPacket {
    private static final boolean ENFORCES_SECURE_CHAT_DEFAULT = false;
    @NonNull
    private final JsonObject data;

    public ClientboundStatusResponsePacket(@NonNull ServerStatusInfo info) {
        this(ClientboundStatusResponsePacket.toJson(info));
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
    }

    public ClientboundStatusResponsePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.data = (JsonObject)new Gson().fromJson(helper.readString(in), JsonObject.class);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeString(out, this.data.toString());
    }

    public ServerStatusInfo parseInfo() {
        JsonElement desc = this.data.get("description");
        Component description = DefaultComponentSerializer.get().deserializeFromTree(desc);
        PlayerInfo players = null;
        if (this.data.has("players")) {
            JsonArray prof;
            JsonObject plrs = this.data.get("players").getAsJsonObject();
            ArrayList<GameProfile> profiles = new ArrayList<GameProfile>();
            if (plrs.has("sample") && (prof = plrs.get("sample").getAsJsonArray()).size() > 0) {
                for (int index = 0; index < prof.size(); ++index) {
                    JsonObject o = prof.get(index).getAsJsonObject();
                    profiles.add(new GameProfile(o.get("id").getAsString(), o.get("name").getAsString()));
                }
            }
            players = new PlayerInfo(plrs.get("max").getAsInt(), plrs.get("online").getAsInt(), profiles);
        }
        VersionInfo version = null;
        if (this.data.has("version")) {
            JsonObject ver = this.data.get("version").getAsJsonObject();
            version = new VersionInfo(ver.get("name").getAsString(), ver.get("protocol").getAsInt());
        }
        byte[] icon = null;
        if (this.data.has("favicon")) {
            icon = ClientboundStatusResponsePacket.stringToIcon(this.data.get("favicon").getAsString());
        }
        boolean enforcesSecureChat = false;
        if (this.data.has("enforcesSecureChat")) {
            enforcesSecureChat = this.data.get("enforcesSecureChat").getAsBoolean();
        }
        return new ServerStatusInfo(description, players, version, icon, enforcesSecureChat);
    }

    public ClientboundStatusResponsePacket withInfo(@NonNull ServerStatusInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return this.withData(ClientboundStatusResponsePacket.toJson(info));
    }

    private static JsonObject toJson(ServerStatusInfo info) {
        JsonObject obj = new JsonObject();
        obj.add("description", DefaultComponentSerializer.get().serializeToTree(info.getDescription()));
        if (info.getPlayerInfo() != null) {
            JsonObject plrs = new JsonObject();
            plrs.addProperty("max", (Number)info.getPlayerInfo().getMaxPlayers());
            plrs.addProperty("online", (Number)info.getPlayerInfo().getOnlinePlayers());
            if (!info.getPlayerInfo().getPlayers().isEmpty()) {
                JsonArray array = new JsonArray();
                for (GameProfile profile : info.getPlayerInfo().getPlayers()) {
                    JsonObject o = new JsonObject();
                    o.addProperty("name", profile.getName());
                    o.addProperty("id", profile.getIdAsString());
                    array.add((JsonElement)o);
                }
                plrs.add("sample", (JsonElement)array);
            }
            obj.add("players", (JsonElement)plrs);
        }
        if (info.getVersionInfo() != null) {
            JsonObject ver = new JsonObject();
            ver.addProperty("name", info.getVersionInfo().getVersionName());
            ver.addProperty("protocol", (Number)info.getVersionInfo().getProtocolVersion());
            obj.add("version", (JsonElement)ver);
        }
        if (info.getIconPng() != null) {
            obj.addProperty("favicon", ClientboundStatusResponsePacket.iconToString(info.getIconPng()));
        }
        obj.addProperty("enforcesSecureChat", Boolean.valueOf(info.isEnforcesSecureChat()));
        return obj;
    }

    public static byte[] stringToIcon(String str) {
        if (str.startsWith("data:image/png;base64,")) {
            str = str.substring("data:image/png;base64,".length());
        }
        return Base64.getDecoder().decode(str.getBytes(StandardCharsets.UTF_8));
    }

    public static String iconToString(byte[] icon) {
        return "data:image/png;base64," + new String(Base64.getEncoder().encode(icon), StandardCharsets.UTF_8);
    }

    @NonNull
    public JsonObject getData() {
        return this.data;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundStatusResponsePacket)) {
            return false;
        }
        ClientboundStatusResponsePacket other = (ClientboundStatusResponsePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JsonObject this$data = this.getData();
        JsonObject other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundStatusResponsePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JsonObject $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public @org.checkerframework.checker.nullness.qual.NonNull String toString() {
        return "ClientboundStatusResponsePacket(data=" + this.getData() + ")";
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ClientboundStatusResponsePacket withData(@NonNull JsonObject data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return this.data == data ? this : new ClientboundStatusResponsePacket(data);
    }

    public ClientboundStatusResponsePacket(@NonNull JsonObject data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
    }
}

