/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.login.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundCustomQueryPacket
implements MinecraftPacket {
    private final int messageId;
    @lombok.NonNull
    private final Key channel;
    private final byte @lombok.NonNull [] data;

    public ClientboundCustomQueryPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.messageId = helper.readVarInt(in);
        this.channel = helper.readResourceLocation(in);
        this.data = helper.readByteArray(in, ByteBuf::readableBytes);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.messageId);
        helper.writeResourceLocation(out, this.channel);
        out.writeBytes(this.data);
    }

    public int getMessageId() {
        return this.messageId;
    }

    @lombok.NonNull
    public Key getChannel() {
        return this.channel;
    }

    public byte @lombok.NonNull [] getData() {
        return this.data;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundCustomQueryPacket)) {
            return false;
        }
        ClientboundCustomQueryPacket other = (ClientboundCustomQueryPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMessageId() != other.getMessageId()) {
            return false;
        }
        Key this$channel = this.getChannel();
        Key other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundCustomQueryPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMessageId();
        Key $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundCustomQueryPacket(messageId=" + this.getMessageId() + ", channel=" + this.getChannel() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    public @NonNull ClientboundCustomQueryPacket withMessageId(int messageId) {
        return this.messageId == messageId ? this : new ClientboundCustomQueryPacket(messageId, this.channel, this.data);
    }

    public @NonNull ClientboundCustomQueryPacket withChannel(@lombok.NonNull Key channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        return this.channel == channel ? this : new ClientboundCustomQueryPacket(this.messageId, channel, this.data);
    }

    public @NonNull ClientboundCustomQueryPacket withData(byte @lombok.NonNull [] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return this.data == data ? this : new ClientboundCustomQueryPacket(this.messageId, this.channel, data);
    }

    public ClientboundCustomQueryPacket(int messageId, @lombok.NonNull Key channel, byte @lombok.NonNull [] data) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.messageId = messageId;
        this.channel = channel;
        this.data = data;
    }
}

