/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundTagQueryPacket
implements MinecraftPacket {
    private final int transactionId;
    private final @Nullable NbtMap nbt;

    public ClientboundTagQueryPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.transactionId = helper.readVarInt(in);
        this.nbt = helper.readCompoundTag(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.transactionId);
        helper.writeAnyTag(out, this.nbt);
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public @Nullable NbtMap getNbt() {
        return this.nbt;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundTagQueryPacket)) {
            return false;
        }
        ClientboundTagQueryPacket other = (ClientboundTagQueryPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTransactionId() != other.getTransactionId()) {
            return false;
        }
        NbtMap this$nbt = this.getNbt();
        NbtMap other$nbt = other.getNbt();
        return !(this$nbt == null ? other$nbt != null : !((Object)this$nbt).equals(other$nbt));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundTagQueryPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTransactionId();
        NbtMap $nbt = this.getNbt();
        result = result * 59 + ($nbt == null ? 43 : ((Object)$nbt).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundTagQueryPacket(transactionId=" + this.getTransactionId() + ", nbt=" + this.getNbt() + ")";
    }

    public @NonNull ClientboundTagQueryPacket withTransactionId(int transactionId) {
        return this.transactionId == transactionId ? this : new ClientboundTagQueryPacket(transactionId, this.nbt);
    }

    public @NonNull ClientboundTagQueryPacket withNbt(@Nullable NbtMap nbt) {
        return this.nbt == nbt ? this : new ClientboundTagQueryPacket(this.transactionId, nbt);
    }

    public ClientboundTagQueryPacket(int transactionId, @Nullable NbtMap nbt) {
        this.transactionId = transactionId;
        this.nbt = nbt;
    }
}

