/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.SoundCategory;

public class ClientboundStopSoundPacket
implements MinecraftPacket {
    private static final int FLAG_CATEGORY = 1;
    private static final int FLAG_SOUND = 2;
    private final @Nullable SoundCategory category;
    private final @Nullable Key sound;

    public ClientboundStopSoundPacket(ByteBuf in, MinecraftCodecHelper helper) {
        byte flags = in.readByte();
        this.category = (flags & 1) != 0 ? helper.readSoundCategory(in) : null;
        this.sound = (flags & 2) != 0 ? helper.readResourceLocation(in) : null;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        int flags = 0;
        if (this.category != null) {
            flags |= 1;
        }
        if (this.sound != null) {
            flags |= 2;
        }
        out.writeByte(flags);
        if (this.category != null) {
            out.writeByte(this.category.ordinal());
        }
        if (this.sound != null) {
            helper.writeResourceLocation(out, this.sound);
        }
    }

    public @Nullable SoundCategory getCategory() {
        return this.category;
    }

    public @Nullable Key getSound() {
        return this.sound;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundStopSoundPacket)) {
            return false;
        }
        ClientboundStopSoundPacket other = (ClientboundStopSoundPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SoundCategory this$category = this.getCategory();
        SoundCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category)) {
            return false;
        }
        Key this$sound = this.getSound();
        Key other$sound = other.getSound();
        return !(this$sound == null ? other$sound != null : !this$sound.equals(other$sound));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundStopSoundPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SoundCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        Key $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundStopSoundPacket(category=" + this.getCategory() + ", sound=" + this.getSound() + ")";
    }

    public @NonNull ClientboundStopSoundPacket withCategory(@Nullable SoundCategory category) {
        return this.category == category ? this : new ClientboundStopSoundPacket(category, this.sound);
    }

    public @NonNull ClientboundStopSoundPacket withSound(@Nullable Key sound) {
        return this.sound == sound ? this : new ClientboundStopSoundPacket(this.category, sound);
    }

    public ClientboundStopSoundPacket(@Nullable SoundCategory category, @Nullable Key sound) {
        this.category = category;
        this.sound = sound;
    }
}

