/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.scoreboard;

import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.scoreboard.ScoreboardUpdater;
import org.geysermc.geyser.scoreboard.UpdateType;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.WorldCache;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ObjectiveAction;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ScoreboardPosition;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.scoreboard.ClientboundSetObjectivePacket;

@Translator(packet=ClientboundSetObjectivePacket.class)
public class JavaSetObjectiveTranslator
extends PacketTranslator<ClientboundSetObjectivePacket> {
    private final GeyserLogger logger = GeyserImpl.getInstance().getLogger();

    @Override
    public void translate(GeyserSession session, ClientboundSetObjectivePacket packet) {
        WorldCache worldCache = session.getWorldCache();
        Scoreboard scoreboard = worldCache.getScoreboard();
        int pps = worldCache.increaseAndGetScoreboardPacketsPerSecond();
        Objective objective = scoreboard.getObjective(packet.getName());
        if (objective != null && objective.getUpdateType() != UpdateType.REMOVE && packet.getAction() == ObjectiveAction.ADD) {
            this.logger.warning("An objective with the same name '" + packet.getName() + "' already exists! Ignoring packet");
            return;
        }
        if ((objective == null || objective.getUpdateType() == UpdateType.REMOVE) && packet.getAction() != ObjectiveAction.REMOVE) {
            objective = scoreboard.registerNewObjective(packet.getName());
        }
        switch (packet.getAction()) {
            case ADD: 
            case UPDATE: {
                objective.setDisplayName(MessageTranslator.convertMessage(packet.getDisplayName())).setNumberFormat(packet.getNumberFormat()).setType(packet.getType().ordinal());
                if (objective != scoreboard.getObjectiveSlots().get((Object)ScoreboardPosition.BELOW_NAME)) break;
                for (PlayerEntity entity : session.getEntityCache().getAllPlayerEntities()) {
                    if (!entity.isValid()) continue;
                    entity.setBelowNameText(objective);
                }
                break;
            }
            case REMOVE: {
                scoreboard.unregisterObjective(packet.getName());
                if (objective == null || objective != scoreboard.getObjectiveSlots().get((Object)ScoreboardPosition.BELOW_NAME)) break;
                for (PlayerEntity entity : session.getEntityCache().getAllPlayerEntities()) {
                    entity.setBelowNameText(null);
                }
                break;
            }
        }
        if (objective == null || !objective.isActive()) {
            return;
        }
        if (pps < ScoreboardUpdater.FIRST_SCORE_PACKETS_PER_SECOND_THRESHOLD) {
            scoreboard.onUpdate();
        }
    }
}

