/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.packet.BlockPickRequestPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.BannerBlock;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.SkullBlock;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.InventoryUtils;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

@Translator(packet=BlockPickRequestPacket.class)
public class BedrockBlockPickRequestTranslator
extends PacketTranslator<BlockPickRequestPacket> {
    @Override
    public void translate(GeyserSession session, BlockPickRequestPacket packet) {
        Block block;
        boolean addExtraData;
        Vector3i vector = packet.getBlockPosition();
        BlockState blockToPick = session.getGeyser().getWorldManager().blockAt(session, vector.getX(), vector.getY(), vector.getZ());
        if (blockToPick.is(Blocks.AIR)) {
            ItemFrameEntity entity = ItemFrameEntity.getItemFrameEntity(session, packet.getBlockPosition());
            if (entity != null) {
                if (!InventoryUtils.isEmpty(entity.getHeldItem())) {
                    InventoryUtils.findOrCreateItem(session, entity.getHeldItem());
                } else {
                    InventoryUtils.findOrCreateItem(session, entity.getDefinition() == EntityDefinitions.GLOW_ITEM_FRAME ? Items.GLOW_ITEM_FRAME : Items.ITEM_FRAME);
                }
            }
            return;
        }
        boolean bl = addExtraData = packet.isAddUserData() && blockToPick.block().hasBlockEntity();
        if (session.isInstabuild() && addExtraData && (block = blockToPick.block()) instanceof SkullBlock) {
            SkullBlock skull = (SkullBlock)block;
            InventoryUtils.findOrCreateItem(session, skull.pickItem(session, blockToPick, vector));
            return;
        }
        if (blockToPick.block() instanceof BannerBlock) {
            session.getGeyser().getWorldManager().getPickItemComponents(session, vector.getX(), vector.getY(), vector.getZ(), addExtraData).whenComplete((components, ex) -> session.ensureInEventLoop(() -> {
                if (components == null) {
                    this.pickItem(session, blockToPick);
                    return;
                }
                ItemStack itemStack = new ItemStack(blockToPick.block().asItem().javaId(), 1, (DataComponents)components);
                InventoryUtils.findOrCreateItem(session, itemStack);
            }));
            return;
        }
        this.pickItem(session, blockToPick);
    }

    private void pickItem(GeyserSession session, BlockState state) {
        InventoryUtils.findOrCreateItem(session, state.block().pickItem(state));
    }
}

