/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.chest;

import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.holder.BlockInventoryHolder;
import org.geysermc.geyser.inventory.holder.InventoryHolder;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.ChestType;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.chest.ChestInventoryTranslator;

public class SingleChestInventoryTranslator
extends ChestInventoryTranslator {
    private final InventoryHolder holder = new BlockInventoryHolder(Blocks.CHEST.defaultBlockState().withValue(Properties.CHEST_TYPE, ChestType.SINGLE), ContainerType.CONTAINER, new Block[]{Blocks.ENDER_CHEST, Blocks.TRAPPED_CHEST}){

        @Override
        protected boolean isValidBlock(BlockState blockState) {
            if (blockState.is(Blocks.ENDER_CHEST)) {
                return true;
            }
            return super.isValidBlock(blockState) && blockState.getValue(Properties.CHEST_TYPE) == ChestType.SINGLE;
        }
    };

    public SingleChestInventoryTranslator(int size) {
        super(size, 27);
    }

    @Override
    public boolean prepareInventory(GeyserSession session, Inventory inventory) {
        return this.holder.prepareInventory(this, session, inventory);
    }

    @Override
    public void openInventory(GeyserSession session, Inventory inventory) {
        this.holder.openInventory(this, session, inventory);
    }

    @Override
    public void closeInventory(GeyserSession session, Inventory inventory) {
        this.holder.closeInventory(this, session, inventory);
    }
}

