/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.NamedTextColor;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.Style;
import org.geysermc.geyser.session.cache.registry.RegistryEntryContext;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatType;
import org.geysermc.mcprotocollib.protocol.data.game.chat.ChatTypeDecoration;

public record TextDecoration(String translationKey, List<ChatTypeDecoration.Parameter> parameters, Style deserializedStyle) implements ChatTypeDecoration
{
    @Override
    public NbtMap style() {
        throw new UnsupportedOperationException();
    }

    public static ChatType readChatType(RegistryEntryContext context) {
        NbtMap tag = context.data();
        NbtMap chat = tag.getCompound("chat", null);
        if (chat != null) {
            String translationKey = chat.getString("translation_key");
            NbtMap styleTag = chat.getCompound("style");
            Style style = TextDecoration.deserializeStyle(styleTag);
            ArrayList<ChatTypeDecoration.Parameter> parameters = new ArrayList<ChatTypeDecoration.Parameter>();
            List<String> parametersNbt = chat.getList("parameters", NbtType.STRING);
            for (String parameter : parametersNbt) {
                parameters.add(ChatTypeDecoration.Parameter.valueOf(parameter.toUpperCase(Locale.ROOT)));
            }
            return new ChatType(new TextDecoration(translationKey, parameters, style), null);
        }
        return new ChatType(null, null);
    }

    public static Style getStyle(ChatTypeDecoration decoration) {
        if (decoration instanceof TextDecoration) {
            TextDecoration textDecoration = (TextDecoration)decoration;
            return textDecoration.deserializedStyle();
        }
        return TextDecoration.deserializeStyle(decoration.style());
    }

    private static Style deserializeStyle(NbtMap styleTag) {
        Style.Builder builder = Style.style();
        if (!styleTag.isEmpty()) {
            boolean italic;
            String color = styleTag.getString("color", null);
            if (color != null) {
                builder.color(NamedTextColor.NAMES.value(color));
            }
            if (italic = styleTag.getBoolean("italic")) {
                builder.decorate(org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.text.format.TextDecoration.ITALIC);
            }
        }
        return builder.build();
    }
}

