/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.raphimc.minecraftauth.step.java.StepMCProfile;
import net.raphimc.minecraftauth.step.java.StepMCToken;
import net.raphimc.minecraftauth.step.java.session.StepFullJavaSession;
import net.raphimc.minecraftauth.util.logging.ILogger;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.value.qual.IntRange;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector2i;
import org.cloudburstmc.math.vector.Vector3d;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.BedrockServerSession;
import org.cloudburstmc.protocol.bedrock.data.Ability;
import org.cloudburstmc.protocol.bedrock.data.AbilityLayer;
import org.cloudburstmc.protocol.bedrock.data.AuthoritativeMovementMode;
import org.cloudburstmc.protocol.bedrock.data.ChatRestrictionLevel;
import org.cloudburstmc.protocol.bedrock.data.ExperimentData;
import org.cloudburstmc.protocol.bedrock.data.GamePublishSetting;
import org.cloudburstmc.protocol.bedrock.data.GameRuleData;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.PlayerPermission;
import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.cloudburstmc.protocol.bedrock.data.SpawnBiomeType;
import org.cloudburstmc.protocol.bedrock.data.command.CommandEnumData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandPermission;
import org.cloudburstmc.protocol.bedrock.data.command.SoftEnumUpdateType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.crafting.PotionMixData;
import org.cloudburstmc.protocol.bedrock.packet.AvailableEntityIdentifiersPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BiomeDefinitionListPacket;
import org.cloudburstmc.protocol.bedrock.packet.CameraPresetsPacket;
import org.cloudburstmc.protocol.bedrock.packet.ChunkRadiusUpdatedPacket;
import org.cloudburstmc.protocol.bedrock.packet.CraftingDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.CreativeContentPacket;
import org.cloudburstmc.protocol.bedrock.packet.EmoteListPacket;
import org.cloudburstmc.protocol.bedrock.packet.GameRulesChangedPacket;
import org.cloudburstmc.protocol.bedrock.packet.ItemComponentPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelSoundEvent2Packet;
import org.cloudburstmc.protocol.bedrock.packet.PlayStatusPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetTimePacket;
import org.cloudburstmc.protocol.bedrock.packet.StartGamePacket;
import org.cloudburstmc.protocol.bedrock.packet.SyncEntityPropertyPacket;
import org.cloudburstmc.protocol.bedrock.packet.TextPacket;
import org.cloudburstmc.protocol.bedrock.packet.TransferPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAbilitiesPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAdventureSettingsPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateClientInputLocksPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateSoftEnumPacket;
import org.cloudburstmc.protocol.common.util.OptionalBoolean;
import org.geysermc.api.util.BedrockPlatform;
import org.geysermc.api.util.InputMode;
import org.geysermc.api.util.UiProfile;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.util.FormBuilder;
import org.geysermc.floodgate.crypto.FloodgateCipher;
import org.geysermc.floodgate.util.BedrockData;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.bedrock.camera.CameraData;
import org.geysermc.geyser.api.bedrock.camera.CameraShake;
import org.geysermc.geyser.api.connection.GeyserConnection;
import org.geysermc.geyser.api.entity.EntityData;
import org.geysermc.geyser.api.entity.type.GeyserEntity;
import org.geysermc.geyser.api.entity.type.player.GeyserPlayerEntity;
import org.geysermc.geyser.api.event.bedrock.SessionDisconnectEvent;
import org.geysermc.geyser.api.event.bedrock.SessionLoginEvent;
import org.geysermc.geyser.api.network.AuthType;
import org.geysermc.geyser.api.network.RemoteServer;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.configuration.EmoteOffhandWorkaroundOption;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.GeyserEntityData;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.ItemFrameEntity;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.erosion.AbstractGeyserboundPacketHandler;
import org.geysermc.geyser.erosion.GeyserboundHandshakePacketHandler;
import org.geysermc.geyser.impl.camera.CameraDefinitions;
import org.geysermc.geyser.impl.camera.GeyserCameraData;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserStonecutterData;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.level.JavaDimension;
import org.geysermc.geyser.level.physics.CollisionManager;
import org.geysermc.geyser.network.netty.LocalSession;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.type.BlockMappings;
import org.geysermc.geyser.registry.type.ItemMappings;
import org.geysermc.geyser.session.DownstreamSession;
import org.geysermc.geyser.session.PendingMicrosoftAuthentication;
import org.geysermc.geyser.session.UpstreamSession;
import org.geysermc.geyser.session.auth.AuthData;
import org.geysermc.geyser.session.auth.BedrockClientData;
import org.geysermc.geyser.session.cache.AdvancementsCache;
import org.geysermc.geyser.session.cache.BookEditCache;
import org.geysermc.geyser.session.cache.ChunkCache;
import org.geysermc.geyser.session.cache.EntityCache;
import org.geysermc.geyser.session.cache.EntityEffectCache;
import org.geysermc.geyser.session.cache.FormCache;
import org.geysermc.geyser.session.cache.LodestoneCache;
import org.geysermc.geyser.session.cache.PistonCache;
import org.geysermc.geyser.session.cache.PreferencesCache;
import org.geysermc.geyser.session.cache.RegistryCache;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.session.cache.StructureBlockCache;
import org.geysermc.geyser.session.cache.TagCache;
import org.geysermc.geyser.session.cache.TeleportCache;
import org.geysermc.geyser.session.cache.WorldBorder;
import org.geysermc.geyser.session.cache.WorldCache;
import org.geysermc.geyser.skin.FloodgateSkinUploader;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.geyser.util.DimensionUtils;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.LoginEncryptionUtils;
import org.geysermc.geyser.util.MinecraftAuthLogger;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.network.BuiltinFlags;
import org.geysermc.mcprotocollib.network.Session;
import org.geysermc.mcprotocollib.network.event.session.ConnectedEvent;
import org.geysermc.mcprotocollib.network.event.session.DisconnectedEvent;
import org.geysermc.mcprotocollib.network.event.session.PacketErrorEvent;
import org.geysermc.mcprotocollib.network.event.session.PacketSendingEvent;
import org.geysermc.mcprotocollib.network.event.session.SessionAdapter;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.network.tcp.TcpClientSession;
import org.geysermc.mcprotocollib.network.tcp.TcpSession;
import org.geysermc.mcprotocollib.protocol.ClientListener;
import org.geysermc.mcprotocollib.protocol.MinecraftConstants;
import org.geysermc.mcprotocollib.protocol.MinecraftProtocol;
import org.geysermc.mcprotocollib.protocol.data.ProtocolState;
import org.geysermc.mcprotocollib.protocol.data.UnexpectedEncryptionException;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.HandPreference;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.PlayerAction;
import org.geysermc.mcprotocollib.protocol.data.game.setting.ChatVisibility;
import org.geysermc.mcprotocollib.protocol.data.game.setting.SkinPart;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.CustomStatistic;
import org.geysermc.mcprotocollib.protocol.data.game.statistic.Statistic;
import org.geysermc.mcprotocollib.protocol.packet.common.serverbound.ServerboundClientInformationPacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundFinishConfigurationPacket;
import org.geysermc.mcprotocollib.protocol.packet.configuration.serverbound.ServerboundFinishConfigurationPacket;
import org.geysermc.mcprotocollib.protocol.packet.handshake.serverbound.ClientIntentionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundChatCommandSignedPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.ServerboundChatPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundMovePlayerPosPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerAbilitiesPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundPlayerActionPacket;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player.ServerboundUseItemPacket;
import org.geysermc.mcprotocollib.protocol.packet.login.serverbound.ServerboundCustomQueryAnswerPacket;

public class GeyserSession
implements GeyserConnection,
GeyserCommandSource {
    private static final Gson GSON = new Gson();
    private final GeyserImpl geyser;
    private final UpstreamSession upstream;
    private DownstreamSession downstream;
    private final EventLoop eventLoop;
    private AuthData authData;
    private BedrockClientData clientData;
    private List<String> certChainData;
    private @NonNull AbstractGeyserboundPacketHandler erosionHandler;
    private RemoteServer remoteServer;
    private final SessionPlayerEntity playerEntity;
    private final AdvancementsCache advancementsCache;
    private final BookEditCache bookEditCache;
    private final ChunkCache chunkCache;
    private final EntityCache entityCache;
    private final EntityEffectCache effectCache;
    private final FormCache formCache;
    private final LodestoneCache lodestoneCache;
    private final PistonCache pistonCache;
    private final PreferencesCache preferencesCache;
    private final RegistryCache registryCache;
    private final SkullCache skullCache;
    private final StructureBlockCache structureBlockCache;
    private final TagCache tagCache;
    private final WorldCache worldCache;
    private TeleportCache unconfirmedTeleport;
    private final WorldBorder worldBorder;
    private boolean isInWorldBorderWarningArea = false;
    private final PlayerInventory playerInventory;
    private Inventory openInventory;
    private boolean closingInventory;
    private @NonNull InventoryTranslator inventoryTranslator = InventoryTranslator.PLAYER_INVENTORY_TRANSLATOR;
    private final AtomicInteger itemNetId = new AtomicInteger(2);
    private ScheduledFuture<?> craftingGridFuture;
    private final CollisionManager collisionManager;
    private BlockMappings blockMappings;
    private ItemMappings itemMappings;
    private final Map<Vector3i, ItemFrameEntity> itemFrameCache = new Object2ObjectOpenHashMap<Vector3i, ItemFrameEntity>();
    private final Set<UUID> playerWithCustomHeads = new ObjectOpenHashSet<UUID>();
    private boolean droppingLecternBook;
    private Vector2i lastChunkPosition = null;
    private int clientRenderDistance = -1;
    private int serverRenderDistance = -1;
    protected boolean sentSpawnPacket;
    private boolean loggedIn;
    private boolean loggingIn;
    private boolean spawned;
    private volatile boolean closed;
    private GameMode gameMode = GameMode.SURVIVAL;
    private Key worldName = null;
    private String[] levels;
    private boolean sneaking;
    private Pose pose = Pose.STANDING;
    private boolean sprinting;
    private int dimension = 0;
    private @MonotonicNonNull JavaDimension dimensionType = null;
    private int breakingBlock;
    private Vector3i lastBlockPlacePosition;
    private BlockItem lastBlockPlaced;
    private boolean interacting;
    private Vector3i lastInteractionBlockPosition = Vector3i.ZERO;
    private Vector3f lastInteractionPlayerPosition = Vector3f.ZERO;
    private Entity mouseoverEntity;
    private final Map<String, List<String>> javaToBedrockRecipeIds;
    private Int2ObjectMap<GeyserRecipe> craftingRecipes;
    private final AtomicInteger lastRecipeNetId;
    private Int2ObjectMap<GeyserStonecutterData> stonecutterRecipes;
    private boolean emulatePost1_13Logic = true;
    private boolean emulatePost1_16Logic = true;
    private boolean emulatePost1_18Logic = true;
    private boolean oldSmithingTable = false;
    private double attackSpeed = 4.0;
    private long lastHitTime;
    private boolean steeringLeft;
    private boolean steeringRight;
    private long lastInteractionTime;
    private long blockBreakStartTime;
    private boolean placedBucket;
    private long lastMovementTimestamp = System.currentTimeMillis();
    private long lastVehicleMoveTimestamp = System.currentTimeMillis();
    private int armAnimationTicks = -1;
    private boolean daylightCycle = true;
    private boolean reducedDebugInfo = false;
    private int opPermissionLevel = 0;
    private boolean canFly = false;
    private boolean flying = false;
    private boolean instabuild = false;
    private float flySpeed;
    private float walkSpeed;
    private boolean raining = false;
    private boolean thunder = false;
    private final Object2IntMap<Statistic> statistics = new Object2IntOpenHashMap<Statistic>(0);
    private boolean waitingForStatistics = false;
    private final Set<UUID> emotes;
    private boolean advancedTooltips = false;
    private ScheduledFuture<?> tickThread = null;
    private ScheduledFuture<?> lookBackScheduledFuture = null;
    private ScheduledFuture<?> mountVehicleScheduledFuture = null;
    private final Queue<Long> keepAliveCache = new ConcurrentLinkedQueue<Long>();
    private @Nullable ItemData currentBook = null;
    private Map<String, byte[]> cookies = new Object2ObjectOpenHashMap<String, byte[]>();
    private final GeyserCameraData cameraData;
    private final GeyserEntityData entityData;
    private MinecraftProtocol protocol;
    private static final Ability[] USED_ABILITIES = Ability.values();
    private static final List<SkinPart> SKIN_PARTS = Arrays.asList(SkinPart.values());

    public GeyserSession(GeyserImpl geyser, BedrockServerSession bedrockServerSession, EventLoop eventLoop) {
        this.geyser = geyser;
        this.upstream = new UpstreamSession(bedrockServerSession);
        this.eventLoop = eventLoop;
        this.erosionHandler = new GeyserboundHandshakePacketHandler(this);
        this.advancementsCache = new AdvancementsCache(this);
        this.bookEditCache = new BookEditCache(this);
        this.chunkCache = new ChunkCache(this);
        this.entityCache = new EntityCache(this);
        this.effectCache = new EntityEffectCache();
        this.formCache = new FormCache(this);
        this.lodestoneCache = new LodestoneCache();
        this.pistonCache = new PistonCache(this);
        this.preferencesCache = new PreferencesCache(this);
        this.registryCache = new RegistryCache(this);
        this.skullCache = new SkullCache(this);
        this.structureBlockCache = new StructureBlockCache();
        this.tagCache = new TagCache();
        this.worldCache = new WorldCache(this);
        this.cameraData = new GeyserCameraData(this);
        this.entityData = new GeyserEntityData(this);
        this.worldBorder = new WorldBorder(this);
        this.collisionManager = new CollisionManager(this);
        this.playerEntity = new SessionPlayerEntity(this);
        this.collisionManager.updatePlayerBoundingBox(this.playerEntity.getPosition());
        this.playerInventory = new PlayerInventory();
        this.openInventory = null;
        this.craftingRecipes = new Int2ObjectOpenHashMap<GeyserRecipe>();
        this.javaToBedrockRecipeIds = new Object2ObjectOpenHashMap<String, List<String>>();
        this.lastRecipeNetId = new AtomicInteger(1);
        this.spawned = false;
        this.loggedIn = false;
        if (geyser.getConfig().getEmoteOffhandWorkaround() != EmoteOffhandWorkaroundOption.NO_EMOTES) {
            this.emotes = new HashSet<UUID>();
            geyser.getSessionManager().getSessions().values().forEach(player -> this.emotes.addAll(player.getEmotes()));
        } else {
            this.emotes = null;
        }
        this.remoteServer = geyser.defaultRemoteServer();
    }

    public void connect() {
        this.startGame();
        this.sentSpawnPacket = true;
        this.syncEntityProperties();
        if (GeyserImpl.getInstance().getConfig().isAddNonBedrockItems()) {
            ItemComponentPacket componentPacket = new ItemComponentPacket();
            componentPacket.getItems().addAll(this.itemMappings.getComponentItemData());
            this.upstream.sendPacket(componentPacket);
        }
        ChunkUtils.sendEmptyChunks(this, this.playerEntity.getPosition().toInt(), 0, false);
        BiomeDefinitionListPacket biomeDefinitionListPacket = new BiomeDefinitionListPacket();
        biomeDefinitionListPacket.setDefinitions((NbtMap)Registries.BIOMES_NBT.get());
        this.upstream.sendPacket(biomeDefinitionListPacket);
        AvailableEntityIdentifiersPacket entityPacket = new AvailableEntityIdentifiersPacket();
        entityPacket.setIdentifiers((NbtMap)Registries.BEDROCK_ENTITY_IDENTIFIERS.get());
        this.upstream.sendPacket(entityPacket);
        CameraPresetsPacket cameraPresetsPacket = new CameraPresetsPacket();
        cameraPresetsPacket.getPresets().addAll(CameraDefinitions.CAMERA_PRESETS);
        this.upstream.sendPacket(cameraPresetsPacket);
        CreativeContentPacket creativePacket = new CreativeContentPacket();
        creativePacket.setContents(this.itemMappings.getCreativeItems());
        this.upstream.sendPacket(creativePacket);
        CraftingDataPacket craftingDataPacket = new CraftingDataPacket();
        craftingDataPacket.setCleanRecipes(true);
        craftingDataPacket.getPotionMixData().addAll((Collection<PotionMixData>)Registries.POTION_MIXES.forVersion(this.upstream.getProtocolVersion()));
        this.upstream.sendPacket(craftingDataPacket);
        PlayStatusPacket playStatusPacket = new PlayStatusPacket();
        playStatusPacket.setStatus(PlayStatusPacket.Status.PLAYER_SPAWN);
        this.upstream.sendPacket(playStatusPacket);
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.getPlayerEntity().getGeyserId());
        attributesPacket.setAttributes(Collections.singletonList(GeyserAttributeType.MOVEMENT_SPEED.getAttribute()));
        this.upstream.sendPacket(attributesPacket);
        GameRulesChangedPacket gamerulePacket = new GameRulesChangedPacket();
        gamerulePacket.getGameRules().add(new GameRuleData<Boolean>("naturalregeneration", false));
        gamerulePacket.getGameRules().add(new GameRuleData<Boolean>("keepinventory", true));
        gamerulePacket.getGameRules().add(new GameRuleData<Integer>("spawnradius", 0));
        gamerulePacket.getGameRules().add(new GameRuleData<Boolean>("recipesunlock", true));
        this.upstream.sendPacket(gamerulePacket);
    }

    public void authenticate(String username) {
        if (this.loggedIn) {
            this.geyser.getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.auth.already_loggedin", username));
            return;
        }
        this.loggingIn = true;
        this.protocol = new MinecraftProtocol(username.replace(' ', '_'));
        try {
            this.connectDownstream();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void authenticateWithAuthChain(String authChain) {
        if (this.loggedIn) {
            this.geyser.getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.auth.already_loggedin", this.getAuthData().name()));
            return;
        }
        this.loggingIn = true;
        CompletableFuture.supplyAsync(() -> {
            StepFullJavaSession.FullJavaSession response;
            StepFullJavaSession step = PendingMicrosoftAuthentication.AUTH_FLOW.apply(true, 30);
            try {
                response = step.refresh((ILogger)MinecraftAuthLogger.INSTANCE, PendingMicrosoftAuthentication.AUTH_CLIENT, (StepFullJavaSession.FullJavaSession)step.fromJson((JsonObject)GSON.fromJson(authChain, JsonObject.class)));
            }
            catch (Exception e) {
                this.geyser.getLogger().error("Error while attempting to use auth chain for " + this.bedrockUsername() + "!", e);
                return Boolean.FALSE;
            }
            StepMCProfile.MCProfile mcProfile = response.getMcProfile();
            StepMCToken.MCToken mcToken = mcProfile.getMcToken();
            this.protocol = new MinecraftProtocol(new GameProfile(mcProfile.getId(), mcProfile.getName()), mcToken.getAccessToken());
            this.geyser.saveAuthChain(this.bedrockUsername(), GSON.toJson((JsonElement)step.toJson(response)));
            return Boolean.TRUE;
        }).whenComplete((successful, ex) -> {
            if (this.closed) {
                return;
            }
            if (successful == Boolean.FALSE) {
                this.connect();
                LoginEncryptionUtils.buildAndShowTokenExpiredWindow(this);
                return;
            }
            try {
                this.connectDownstream();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
    }

    public void authenticateWithMicrosoftCode() {
        this.authenticateWithMicrosoftCode(false);
    }

    public void authenticateWithMicrosoftCode(boolean offlineAccess) {
        if (this.loggedIn) {
            this.geyser.getLogger().severe(GeyserLocale.getLocaleStringLog("geyser.auth.already_loggedin", this.getAuthData().name()));
            return;
        }
        this.loggingIn = true;
        SetTimePacket packet = new SetTimePacket();
        packet.setTime(16000);
        this.sendUpstreamPacket(packet);
        PendingMicrosoftAuthentication.AuthenticationTask task = this.geyser.getPendingMicrosoftAuthentication().getOrCreateTask(this.getAuthData().xuid());
        if (task.getAuthentication() != null && task.getAuthentication().isDone()) {
            this.onMicrosoftLoginComplete(task);
        } else {
            task.resetRunningFlow();
            task.performLoginAttempt(offlineAccess, code -> {
                if (!this.closed) {
                    LoginEncryptionUtils.buildAndShowMicrosoftCodeWindow(this, code);
                }
            }).handle((r, e) -> this.onMicrosoftLoginComplete(task));
        }
    }

    public boolean onMicrosoftLoginComplete(PendingMicrosoftAuthentication.AuthenticationTask task) {
        if (this.closed) {
            return false;
        }
        task.cleanup();
        return ((CompletableFuture)task.getAuthentication().handle((result, ex) -> {
            if (ex != null) {
                this.geyser.getLogger().error("Failed to log in with Microsoft code!", (Throwable)ex);
                this.disconnect(ex.toString());
                return false;
            }
            StepMCProfile.MCProfile mcProfile = result.session().getMcProfile();
            StepMCToken.MCToken mcToken = mcProfile.getMcToken();
            this.protocol = new MinecraftProtocol(new GameProfile(mcProfile.getId(), mcProfile.getName()), mcToken.getAccessToken());
            try {
                this.connectDownstream();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return false;
            }
            this.geyser.saveAuthChain(this.bedrockUsername(), GSON.toJson((JsonElement)result.step().toJson(result.session())));
            return true;
        })).getNow(false);
    }

    private void connectDownstream() {
        TcpSession downstream;
        SessionLoginEvent loginEvent = new SessionLoginEvent(this, this.remoteServer, new Object2ObjectOpenHashMap<String, byte[]>());
        GeyserImpl.getInstance().eventBus().fire(loginEvent);
        if (loginEvent.isCancelled()) {
            String disconnectReason = loginEvent.disconnectReason() == null ? "disconnect.disconnected" : loginEvent.disconnectReason();
            this.disconnect(disconnectReason);
            return;
        }
        this.cookies = loginEvent.cookies();
        this.remoteServer = loginEvent.remoteServer();
        final boolean floodgate = this.remoteServer.authType() == AuthType.FLOODGATE;
        this.tickThread = this.eventLoop.scheduleAtFixedRate(this::tick, 50L, 50L, TimeUnit.MILLISECONDS);
        this.protocol.setUseDefaultListeners(false);
        if (this.geyser.getBootstrap().getSocketAddress() != null) {
            downstream = new LocalSession(this.remoteServer.address(), this.remoteServer.port(), this.geyser.getBootstrap().getSocketAddress(), this.upstream.getAddress().getAddress().getHostAddress(), this.protocol, this.protocol.createHelper());
            this.downstream = new DownstreamSession(downstream);
        } else {
            downstream = new TcpClientSession(this.remoteServer.address(), this.remoteServer.port(), this.protocol);
            this.downstream = new DownstreamSession(downstream);
            boolean resolveSrv = false;
            try {
                resolveSrv = this.remoteServer.resolveSrv();
            }
            catch (AbstractMethodError | NoSuchMethodError incompatibleClassChangeError) {
                // empty catch block
            }
            this.downstream.getSession().setFlag(BuiltinFlags.ATTEMPT_SRV_RESOLVE, resolveSrv);
        }
        this.downstream.getSession().setFlag(MinecraftConstants.FOLLOW_TRANSFERS, false);
        if (this.geyser.getConfig().getRemote().isUseProxyProtocol()) {
            downstream.setFlag(BuiltinFlags.ENABLE_CLIENT_PROXY_PROTOCOL, true);
            downstream.setFlag(BuiltinFlags.CLIENT_PROXIED_ADDRESS, this.upstream.getAddress());
        }
        if (this.geyser.getConfig().isForwardPlayerPing()) {
            downstream.setFlag(MinecraftConstants.AUTOMATIC_KEEP_ALIVE_MANAGEMENT, false);
        }
        downstream.setFlag(MinecraftConstants.SEND_BLANK_KNOWN_PACKS_RESPONSE, false);
        this.downstream.getSession().addListener(new ClientListener(ProtocolState.LOGIN, loginEvent.transferring()){

            @Override
            public void packetReceived(Session session, Packet packet) {
                if (GeyserSession.this.protocol.getState() == ProtocolState.CONFIGURATION && packet instanceof ClientboundFinishConfigurationPacket) {
                    GeyserSession.this.ensureInEventLoop(() -> GeyserSession.this.sendDownstreamPacket(new ServerboundFinishConfigurationPacket()));
                    return;
                }
                super.packetReceived(session, packet);
            }
        });
        downstream.addListener(new SessionAdapter(){

            @Override
            public void packetSending(PacketSendingEvent event) {
                if (event.getPacket() instanceof ClientIntentionPacket) {
                    Object addressSuffix;
                    if (floodgate) {
                        byte[] encryptedData;
                        try {
                            FloodgateSkinUploader skinUploader = GeyserSession.this.geyser.getSkinUploader();
                            FloodgateCipher cipher = GeyserSession.this.geyser.getCipher();
                            String bedrockAddress = GeyserSession.this.upstream.getAddress().getAddress().getHostAddress();
                            int ipv6ScopeIndex = bedrockAddress.indexOf(37);
                            if (ipv6ScopeIndex != -1) {
                                bedrockAddress = bedrockAddress.substring(0, ipv6ScopeIndex);
                            }
                            encryptedData = cipher.encryptFromString(BedrockData.of(GeyserSession.this.clientData.getGameVersion(), GeyserSession.this.authData.name(), GeyserSession.this.authData.xuid(), GeyserSession.this.clientData.getDeviceOs().ordinal(), GeyserSession.this.clientData.getLanguageCode(), GeyserSession.this.clientData.getUiProfile().ordinal(), GeyserSession.this.clientData.getCurrentInputMode().ordinal(), bedrockAddress, skinUploader.getId(), skinUploader.getVerifyCode()).toString());
                        }
                        catch (Exception e) {
                            GeyserSession.this.geyser.getLogger().error(GeyserLocale.getLocaleStringLog("geyser.auth.floodgate.encrypt_fail"), e);
                            GeyserSession.this.disconnect(GeyserLocale.getPlayerLocaleString("geyser.auth.floodgate.encrypt_fail", GeyserSession.this.getClientData().getLanguageCode()));
                            return;
                        }
                        addressSuffix = "\u0000" + new String(encryptedData, StandardCharsets.UTF_8);
                    } else {
                        addressSuffix = "";
                    }
                    ClientIntentionPacket intentionPacket = (ClientIntentionPacket)event.getPacket();
                    String address = GeyserSession.this.geyser.getConfig().getRemote().isForwardHost() ? GeyserSession.this.clientData.getServerAddress().split(":")[0] : intentionPacket.getHostname();
                    event.setPacket(intentionPacket.withHostname(address + (String)addressSuffix));
                }
            }

            @Override
            public void connected(ConnectedEvent event) {
                GeyserSession.this.loggingIn = false;
                GeyserSession.this.loggedIn = true;
                if (downstream instanceof LocalSession) {
                    GeyserSession.this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.remote.connect_internal", GeyserSession.this.authData.name(), GeyserSession.this.protocol.getProfile().getName()));
                } else {
                    GeyserSession.this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.remote.connect", GeyserSession.this.authData.name(), GeyserSession.this.protocol.getProfile().getName(), GeyserSession.this.remoteServer.address()));
                }
                UUID uuid = GeyserSession.this.protocol.getProfile().getId();
                if (uuid == null) {
                    uuid = GeyserSession.this.remoteServer.authType() == AuthType.FLOODGATE ? new UUID(0L, Long.parseLong(GeyserSession.this.authData.xuid())) : UUID.nameUUIDFromBytes(("OfflinePlayer:" + GeyserSession.this.protocol.getProfile().getName()).getBytes(StandardCharsets.UTF_8));
                }
                GeyserSession.this.playerEntity.setUuid(uuid);
                GeyserSession.this.playerEntity.setUsername(GeyserSession.this.protocol.getProfile().getName());
                String locale = GeyserSession.this.clientData.getLanguageCode();
                if (locale.equalsIgnoreCase("en_us") && !MinecraftLocale.LOCALE_MAPPINGS.containsKey("en_us")) {
                    GeyserSession.this.sendMessage("Loading your locale (en_us); if this isn't already downloaded, this may take some time");
                }
                MinecraftLocale.downloadAndLoadLocale(locale);
            }

            @Override
            public void disconnected(DisconnectedEvent event) {
                String disconnectMessage;
                GeyserSession.this.loggingIn = false;
                Throwable cause = event.getCause();
                if (cause instanceof UnexpectedEncryptionException) {
                    if (GeyserSession.this.remoteServer.authType() != AuthType.FLOODGATE) {
                        disconnectMessage = GeyserLocale.getPlayerLocaleString("geyser.network.remote.authentication_type_mismatch", GeyserSession.this.locale());
                        GeyserSession.this.geyser.getLogger().warning(GeyserLocale.getLocaleStringLog(GeyserSession.this.geyser.getPlatformType() == PlatformType.STANDALONE ? "geyser.network.remote.floodgate_explanation_standalone" : "geyser.network.remote.floodgate_explanation_plugin", "https://geysermc.org/download#floodgate"));
                    } else {
                        disconnectMessage = GeyserLocale.getPlayerLocaleString("geyser.network.remote.floodgate_login_error", GeyserSession.this.locale());
                        if (GeyserSession.this.geyser.getPlatformType() == PlatformType.STANDALONE) {
                            GeyserSession.this.geyser.getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.network.remote.floodgate_login_error_standalone"));
                        }
                    }
                } else {
                    disconnectMessage = cause instanceof ConnectException ? GeyserLocale.getPlayerLocaleString("geyser.network.remote.server_offline", GeyserSession.this.locale()) : MessageTranslator.convertMessage(event.getReason());
                }
                if (downstream instanceof LocalSession) {
                    GeyserSession.this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.remote.disconnect_internal", GeyserSession.this.authData.name(), disconnectMessage));
                } else {
                    GeyserSession.this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.remote.disconnect", GeyserSession.this.authData.name(), GeyserSession.this.remoteServer.address(), disconnectMessage));
                }
                if (cause != null) {
                    if (cause.getMessage() != null) {
                        GeyserImpl.getInstance().getLogger().error(cause.getMessage());
                    } else {
                        GeyserImpl.getInstance().getLogger().error("An exception occurred: ", cause);
                    }
                    if (GeyserSession.this.geyser.getConfig().isDebugMode()) {
                        cause.printStackTrace();
                    }
                }
                if (!GeyserSession.this.closed && GeyserSession.this.loggedIn || cause != null) {
                    GeyserSession.this.disconnect(disconnectMessage);
                }
                GeyserSession.this.loggedIn = false;
            }

            @Override
            public void packetReceived(Session session, Packet packet) {
                Registries.JAVA_PACKET_TRANSLATORS.translate(packet.getClass(), packet, GeyserSession.this);
            }

            @Override
            public void packetError(PacketErrorEvent event) {
                GeyserSession.this.geyser.getLogger().warning(GeyserLocale.getLocaleStringLog("geyser.network.downstream_error", event.getCause().getMessage()));
                if (GeyserSession.this.geyser.getConfig().isDebugMode()) {
                    event.getCause().printStackTrace();
                }
                event.setSuppress(true);
            }
        });
        if (!this.daylightCycle) {
            this.setDaylightCycle(true);
        }
        downstream.connect(false, loginEvent.transferring());
    }

    public void disconnect(String reason) {
        if (!this.closed) {
            PendingMicrosoftAuthentication.AuthenticationTask task;
            this.loggedIn = false;
            SessionDisconnectEvent disconnectEvent = new SessionDisconnectEvent(this, reason);
            if (this.authData != null && this.clientData != null) {
                this.geyser.getEventBus().fire(disconnectEvent);
            }
            if (this.downstream != null) {
                if (!this.downstream.isClosed()) {
                    this.downstream.disconnect(reason);
                }
            } else {
                String address = this.geyser.getConfig().isLogPlayerIpAddresses() ? this.upstream.getAddress().getAddress().toString() : "<IP address withheld>";
                this.geyser.getLogger().info(GeyserLocale.getLocaleStringLog("geyser.network.disconnect", address, reason));
            }
            if (!this.upstream.isClosed()) {
                this.upstream.disconnect(disconnectEvent.disconnectReason());
            }
            this.geyser.getSessionManager().removeSession(this);
            if (this.authData != null && (task = this.geyser.getPendingMicrosoftAuthentication().getTask(this.authData.xuid())) != null) {
                task.resetRunningFlow();
            }
        }
        if (this.tickThread != null) {
            this.tickThread.cancel(false);
        }
        this.erosionHandler.close();
        this.closed = true;
    }

    public void ensureInEventLoop(Runnable runnable) {
        if (this.eventLoop.inEventLoop()) {
            runnable.run();
            return;
        }
        this.executeInEventLoop(runnable);
    }

    public void executeInEventLoop(Runnable runnable) {
        this.eventLoop.execute(() -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                this.geyser.getLogger().error("Error thrown in " + this.bedrockUsername() + "'s event loop!", e);
            }
        });
    }

    public ScheduledFuture<?> scheduleInEventLoop(Runnable runnable, long duration, TimeUnit timeUnit) {
        return this.eventLoop.schedule(() -> {
            try {
                if (!this.closed) {
                    runnable.run();
                }
            }
            catch (Throwable e) {
                this.geyser.getLogger().error("Error thrown in " + this.bedrockUsername() + "'s event loop!", e);
            }
        }, duration, timeUnit);
    }

    protected void tick() {
        try {
            int miningFatigueLevel;
            int hasteLevel;
            int swingTotalDuration;
            boolean shouldShowFog;
            this.pistonCache.tick();
            if (this.spawned && System.currentTimeMillis() - this.lastMovementTimestamp > 3000L) {
                Vector3d position = this.collisionManager.adjustBedrockPosition(this.playerEntity.getPosition(), this.playerEntity.isOnGround(), false);
                if (position != null) {
                    ServerboundMovePlayerPosPacket packet = new ServerboundMovePlayerPosPacket(this.playerEntity.isOnGround(), position.getX(), position.getY(), position.getZ());
                    this.sendDownstreamGamePacket(packet);
                }
                this.lastMovementTimestamp = System.currentTimeMillis();
            }
            if (this.worldBorder.isResizing()) {
                this.worldBorder.resize();
            }
            boolean bl = shouldShowFog = !this.worldBorder.isWithinWarningBoundaries();
            if (shouldShowFog || this.worldBorder.isCloseToBorderBoundaries()) {
                this.worldBorder.drawWall();
                if (shouldShowFog && !this.isInWorldBorderWarningArea) {
                    this.isInWorldBorderWarningArea = true;
                    this.camera().sendFog("minecraft:fog_crimson_forest");
                }
            }
            if (!shouldShowFog && this.isInWorldBorderWarningArea) {
                this.camera().removeFog("minecraft:fog_crimson_forest");
                this.isInWorldBorderWarningArea = false;
            }
            for (Tickable entity : this.entityCache.getTickableEntities()) {
                entity.tick();
            }
            if (this.armAnimationTicks >= 0 && ++this.armAnimationTicks >= (swingTotalDuration = (hasteLevel = Math.max(this.effectCache.getHaste(), this.effectCache.getConduitPower())) > 0 ? 6 - hasteLevel : ((miningFatigueLevel = this.effectCache.getMiningFatigue()) > 0 ? 6 + miningFatigueLevel * 2 : 6))) {
                if (this.sneaking && this.attemptToBlock()) {
                    this.playerEntity.updateBedrockMetadata();
                }
                this.armAnimationTicks = -1;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setAuthenticationData(AuthData authData) {
        this.authData = authData;
    }

    public void startSneaking() {
        if (this.armAnimationTicks < 0) {
            this.attemptToBlock();
        }
        this.setSneaking(true);
    }

    public void stopSneaking() {
        this.disableBlocking();
        this.setSneaking(false);
    }

    private void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
        if (!this.flying) {
            this.setSneakingPose(sneaking);
        }
        this.collisionManager.updateScaffoldingFlags(false);
        this.playerEntity.updateBedrockMetadata();
        if (this.mouseoverEntity != null) {
            this.mouseoverEntity.updateInteractiveTag();
        }
    }

    private void setSneakingPose(boolean sneaking) {
        if (this.pose == Pose.SNEAKING && !sneaking) {
            this.pose = Pose.STANDING;
            this.playerEntity.setBoundingBoxHeight(this.playerEntity.getDefinition().height());
        } else if (sneaking) {
            this.pose = Pose.SNEAKING;
            this.playerEntity.setBoundingBoxHeight(1.5f);
        }
        this.playerEntity.setFlag(EntityFlag.SNEAKING, sneaking);
    }

    public void setSwimming(boolean swimming) {
        if (swimming) {
            this.pose = Pose.SWIMMING;
            this.playerEntity.setBoundingBoxHeight(0.6f);
        } else {
            this.pose = Pose.STANDING;
            this.playerEntity.setBoundingBoxHeight(this.playerEntity.getDefinition().height());
        }
        this.playerEntity.setFlag(EntityFlag.SWIMMING, swimming);
        this.playerEntity.updateBedrockMetadata();
    }

    public void setFlying(boolean flying) {
        this.flying = flying;
        if (this.sneaking) {
            this.setSneakingPose(!flying);
            this.playerEntity.updateBedrockMetadata();
        }
    }

    public void setGameMode(GameMode newGamemode) {
        boolean currentlySpectator = this.gameMode == GameMode.SPECTATOR;
        this.gameMode = newGamemode;
        this.cameraData.handleGameModeChange(currentlySpectator, newGamemode);
    }

    public void useItem(Hand hand) {
        this.sendDownstreamGamePacket(new ServerboundUseItemPacket(hand, this.worldCache.nextPredictionSequence(), this.playerEntity.getYaw(), this.playerEntity.getPitch()));
    }

    private boolean attemptToBlock() {
        if (this.playerInventory.getItemInHand().asItem() == Items.SHIELD) {
            this.useItem(Hand.MAIN_HAND);
        } else if (this.playerInventory.getOffhand().asItem() == Items.SHIELD) {
            this.useItem(Hand.OFF_HAND);
        } else {
            return false;
        }
        this.playerEntity.setFlag(EntityFlag.BLOCKING, true);
        return true;
    }

    public void activateArmAnimationTicking() {
        this.armAnimationTicks = 0;
        if (this.disableBlocking()) {
            this.playerEntity.updateBedrockMetadata();
        }
    }

    public void armSwingPending() {
        if (this.armAnimationTicks == -1) {
            this.armAnimationTicks = -2;
        }
    }

    private boolean disableBlocking() {
        if (this.playerEntity.getFlag(EntityFlag.BLOCKING)) {
            ServerboundPlayerActionPacket releaseItemPacket = new ServerboundPlayerActionPacket(PlayerAction.RELEASE_USE_ITEM, Vector3i.ZERO, Direction.DOWN, 0);
            this.sendDownstreamGamePacket(releaseItemPacket);
            this.playerEntity.setFlag(EntityFlag.BLOCKING, false);
            return true;
        }
        return false;
    }

    public void requestOffhandSwap() {
        ServerboundPlayerActionPacket swapHandsPacket = new ServerboundPlayerActionPacket(PlayerAction.SWAP_HANDS, Vector3i.ZERO, Direction.DOWN, 0);
        this.sendDownstreamGamePacket(swapHandsPacket);
    }

    @Override
    public String name() {
        return this.playerEntity != null ? this.javaUsername() : this.bedrockUsername();
    }

    @Override
    public void sendMessage(@NonNull String message) {
        TextPacket textPacket = new TextPacket();
        textPacket.setPlatformChatId("");
        textPacket.setSourceName("");
        textPacket.setXuid("");
        textPacket.setType(TextPacket.Type.CHAT);
        textPacket.setNeedsTranslation(false);
        textPacket.setMessage(message);
        this.upstream.sendPacket(textPacket);
    }

    @Override
    public boolean isConsole() {
        return false;
    }

    @Override
    public String locale() {
        return this.clientData.getLanguageCode();
    }

    public void sendChat(String message) {
        this.sendDownstreamGamePacket(new ServerboundChatPacket(message, Instant.now().toEpochMilli(), 0L, null, 0, new BitSet()));
    }

    public void sendCommand(String command) {
        this.sendDownstreamGamePacket(new ServerboundChatCommandSignedPacket(command, Instant.now().toEpochMilli(), 0L, Collections.emptyList(), 0, new BitSet()));
    }

    public void setServerRenderDistance(int renderDistance) {
        this.serverRenderDistance = renderDistance = Math.min(renderDistance, 96);
        ChunkRadiusUpdatedPacket chunkRadiusUpdatedPacket = new ChunkRadiusUpdatedPacket();
        chunkRadiusUpdatedPacket.setRadius(renderDistance);
        this.upstream.sendPacket(chunkRadiusUpdatedPacket);
    }

    public InetSocketAddress getSocketAddress() {
        return this.upstream.getAddress();
    }

    @Override
    public boolean sendForm(@NonNull Form form) {
        this.formCache.showForm(form);
        return true;
    }

    @Override
    public boolean sendForm(@NonNull org.geysermc.cumulus.form.util.FormBuilder<?, ?, ?> formBuilder) {
        this.formCache.showForm((Form)formBuilder.build());
        return true;
    }

    @Deprecated
    public void sendForm(org.geysermc.cumulus.Form<?> form) {
        this.sendForm((Form)form.newForm());
    }

    @Deprecated
    public void sendForm(FormBuilder<?, ?> formBuilder) {
        this.sendForm((org.geysermc.cumulus.Form<?>)formBuilder.build());
    }

    private void startGame() {
        this.upstream.getCodecHelper().setItemDefinitions(this.itemMappings);
        this.upstream.getCodecHelper().setBlockDefinitions(this.blockMappings);
        this.upstream.getCodecHelper().setCameraPresetDefinitions(CameraDefinitions.CAMERA_DEFINITIONS);
        StartGamePacket startGamePacket = new StartGamePacket();
        startGamePacket.setUniqueEntityId(this.playerEntity.getGeyserId());
        startGamePacket.setRuntimeEntityId(this.playerEntity.getGeyserId());
        startGamePacket.setPlayerGameType(EntityUtils.toBedrockGamemode(this.gameMode));
        startGamePacket.setPlayerPosition(Vector3f.from(0.0f, 69.0f, 0.0f));
        startGamePacket.setRotation(Vector2f.from(1.0f, 1.0f));
        startGamePacket.setSeed(-1L);
        startGamePacket.setDimensionId(DimensionUtils.javaToBedrock(this.chunkCache.getBedrockDimension()));
        startGamePacket.setGeneratorId(1);
        startGamePacket.setLevelGameType(GameType.SURVIVAL);
        startGamePacket.setDifficulty(1);
        startGamePacket.setDefaultSpawn(Vector3i.ZERO);
        startGamePacket.setAchievementsDisabled(!this.geyser.getConfig().isXboxAchievementsEnabled());
        startGamePacket.setCurrentTick(-1L);
        startGamePacket.setEduEditionOffers(0);
        startGamePacket.setEduFeaturesEnabled(false);
        startGamePacket.setRainLevel(0.0f);
        startGamePacket.setLightningLevel(0.0f);
        startGamePacket.setMultiplayerGame(true);
        startGamePacket.setBroadcastingToLan(true);
        startGamePacket.setPlatformBroadcastMode(GamePublishSetting.PUBLIC);
        startGamePacket.setXblBroadcastMode(GamePublishSetting.PUBLIC);
        startGamePacket.setCommandsEnabled(!this.geyser.getConfig().isXboxAchievementsEnabled());
        startGamePacket.setTexturePacksRequired(false);
        startGamePacket.setBonusChestEnabled(false);
        startGamePacket.setStartingWithMap(false);
        startGamePacket.setTrustingPlayers(true);
        startGamePacket.setDefaultPlayerPermission(PlayerPermission.MEMBER);
        startGamePacket.setServerChunkTickRange(4);
        startGamePacket.setBehaviorPackLocked(false);
        startGamePacket.setResourcePackLocked(false);
        startGamePacket.setFromLockedWorldTemplate(false);
        startGamePacket.setUsingMsaGamertagsOnly(false);
        startGamePacket.setFromWorldTemplate(false);
        startGamePacket.setWorldTemplateOptionLocked(false);
        startGamePacket.setSpawnBiomeType(SpawnBiomeType.DEFAULT);
        startGamePacket.setCustomBiomeName("");
        startGamePacket.setEducationProductionId("");
        startGamePacket.setForceExperimentalGameplay(OptionalBoolean.empty());
        String serverName = this.geyser.getConfig().getBedrock().serverName();
        startGamePacket.setLevelId(serverName);
        startGamePacket.setLevelName(serverName);
        startGamePacket.setPremiumWorldTemplateId("00000000-0000-0000-0000-000000000000");
        startGamePacket.setEnchantmentSeed(0);
        startGamePacket.setMultiplayerCorrelationId("");
        startGamePacket.getItemDefinitions().addAll(this.itemMappings.getItemDefinitions().values());
        startGamePacket.getBlockProperties().addAll(this.blockMappings.getBlockProperties());
        startGamePacket.getExperiments().add(new ExperimentData("data_driven_items", true));
        startGamePacket.getExperiments().add(new ExperimentData("upcoming_creator_features", true));
        startGamePacket.getExperiments().add(new ExperimentData("experimental_molang_features", true));
        startGamePacket.getExperiments().add(new ExperimentData("updateAnnouncedLive2023", true));
        startGamePacket.setVanillaVersion("*");
        startGamePacket.setInventoriesServerAuthoritative(true);
        startGamePacket.setServerEngine("");
        startGamePacket.setPlayerPropertyData(NbtMap.EMPTY);
        startGamePacket.setWorldTemplateId(UUID.randomUUID());
        startGamePacket.setChatRestrictionLevel(ChatRestrictionLevel.NONE);
        startGamePacket.setAuthoritativeMovementMode(AuthoritativeMovementMode.CLIENT);
        startGamePacket.setRewindHistorySize(0);
        startGamePacket.setServerAuthoritativeBlockBreaking(false);
        startGamePacket.setServerId("");
        startGamePacket.setWorldId("");
        startGamePacket.setScenarioId("");
        this.upstream.sendPacket(startGamePacket);
    }

    private void syncEntityProperties() {
        for (NbtMap nbtMap : (Set)Registries.BEDROCK_ENTITY_PROPERTIES.get()) {
            SyncEntityPropertyPacket syncEntityPropertyPacket = new SyncEntityPropertyPacket();
            syncEntityPropertyPacket.setData(nbtMap);
            this.upstream.sendPacket(syncEntityPropertyPacket);
        }
    }

    public int getNextItemNetId() {
        return this.itemNetId.getAndIncrement();
    }

    public void confirmTeleport(Vector3d position) {
        if (this.unconfirmedTeleport == null) {
            return;
        }
        if (this.unconfirmedTeleport.canConfirm(position)) {
            this.unconfirmedTeleport = null;
            return;
        }
        this.unconfirmedTeleport.incrementUnconfirmedFor();
        if (this.unconfirmedTeleport.shouldResend()) {
            this.unconfirmedTeleport.resetUnconfirmedFor();
            this.geyser.getLogger().debug("Resending teleport " + this.unconfirmedTeleport.getTeleportConfirmId());
            this.getPlayerEntity().moveAbsolute(Vector3f.from(this.unconfirmedTeleport.getX(), this.unconfirmedTeleport.getY(), this.unconfirmedTeleport.getZ()), this.unconfirmedTeleport.getYaw(), this.unconfirmedTeleport.getPitch(), this.playerEntity.isOnGround(), true);
        }
    }

    public void sendUpstreamPacket(BedrockPacket packet) {
        this.upstream.sendPacket(packet);
    }

    public void sendUpstreamPacketImmediately(BedrockPacket packet) {
        this.upstream.sendPacketImmediately(packet);
    }

    public void sendDownstreamGamePacket(Packet packet) {
        this.sendDownstreamPacket(packet, ProtocolState.GAME);
    }

    public void sendDownstreamLoginPacket(Packet packet) {
        this.sendDownstreamPacket(packet, ProtocolState.LOGIN);
    }

    public void sendDownstreamPacket(Packet packet, ProtocolState intendedState) {
        if (this.protocol == null) {
            if (this.geyser.getConfig().isDebugMode()) {
                this.geyser.getLogger().debug("Tried to send downstream packet with no downstream session!");
                Thread.dumpStack();
            }
            return;
        }
        if (this.protocol.getState() != intendedState) {
            this.geyser.getLogger().debug("Tried to send " + packet.getClass().getSimpleName() + " packet while not in " + intendedState.name() + " state");
            return;
        }
        this.sendDownstreamPacket(packet);
    }

    public void sendDownstreamPacket(Packet packet) {
        if (!this.closed && this.downstream != null) {
            Channel channel = this.downstream.getSession().getChannel();
            if (channel == null) {
                this.geyser.getLogger().warning("Tried to send a packet to the Java server too early!");
                if (this.geyser.getConfig().isDebugMode()) {
                    Thread.dumpStack();
                }
                return;
            }
            EventLoop eventLoop = channel.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.sendDownstreamPacket0(packet);
            } else {
                eventLoop.execute(() -> this.sendDownstreamPacket0(packet));
            }
        }
    }

    private void sendDownstreamPacket0(Packet packet) {
        ProtocolState state = this.protocol.getState();
        if (state == ProtocolState.GAME || state == ProtocolState.CONFIGURATION || packet.getClass() == ServerboundCustomQueryAnswerPacket.class) {
            this.downstream.sendPacket(packet);
        } else {
            this.geyser.getLogger().debug("Tried to send downstream packet " + packet.getClass().getSimpleName() + " before connected to the server");
        }
    }

    public void setReducedDebugInfo(boolean value) {
        this.reducedDebugInfo = value;
        this.preferencesCache.updateShowCoordinates();
    }

    public void setDaylightCycle(boolean doCycle) {
        this.sendGameRule("dodaylightcycle", doCycle);
        this.daylightCycle = doCycle;
    }

    public void sendGameRule(String gameRule, Object value) {
        GameRulesChangedPacket gameRulesChangedPacket = new GameRulesChangedPacket();
        gameRulesChangedPacket.getGameRules().add(new GameRuleData<Object>(gameRule, value));
        this.upstream.sendPacket(gameRulesChangedPacket);
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.geyser.getWorldManager().hasPermission(this, permission);
    }

    public void sendAdventureSettings() {
        long bedrockId = this.playerEntity.getGeyserId();
        CommandPermission commandPermission = this.opPermissionLevel >= 2 ? CommandPermission.GAME_DIRECTORS : CommandPermission.ANY;
        PlayerPermission playerPermission = this.opPermissionLevel >= 2 ? PlayerPermission.OPERATOR : PlayerPermission.MEMBER;
        boolean spectator = this.gameMode == GameMode.SPECTATOR;
        boolean worldImmutable = this.gameMode == GameMode.ADVENTURE || spectator;
        UpdateAdventureSettingsPacket adventureSettingsPacket = new UpdateAdventureSettingsPacket();
        adventureSettingsPacket.setNoMvP(false);
        adventureSettingsPacket.setNoPvM(false);
        adventureSettingsPacket.setImmutableWorld(worldImmutable);
        adventureSettingsPacket.setShowNameTags(false);
        adventureSettingsPacket.setAutoJump(true);
        this.sendUpstreamPacket(adventureSettingsPacket);
        UpdateAbilitiesPacket updateAbilitiesPacket = new UpdateAbilitiesPacket();
        updateAbilitiesPacket.setUniqueEntityId(bedrockId);
        updateAbilitiesPacket.setCommandPermission(commandPermission);
        updateAbilitiesPacket.setPlayerPermission(playerPermission);
        AbilityLayer abilityLayer = new AbilityLayer();
        Set<Ability> abilities = abilityLayer.getAbilityValues();
        if (this.canFly) {
            abilities.add(Ability.MAY_FLY);
        }
        abilities.add(Ability.BUILD);
        abilities.add(Ability.MINE);
        abilities.add(Ability.DOORS_AND_SWITCHES);
        abilities.add(Ability.OPEN_CONTAINERS);
        if (this.gameMode == GameMode.CREATIVE) {
            abilities.add(Ability.INSTABUILD);
        }
        if (commandPermission == CommandPermission.GAME_DIRECTORS) {
            abilities.add(Ability.OPERATOR_COMMANDS);
        }
        if (this.flying || spectator) {
            if (spectator && !this.flying) {
                this.flying = true;
                ServerboundPlayerAbilitiesPacket abilitiesPacket = new ServerboundPlayerAbilitiesPacket(true);
                this.sendDownstreamGamePacket(abilitiesPacket);
            }
            abilities.add(Ability.FLYING);
        }
        if (spectator) {
            AbilityLayer spectatorLayer = new AbilityLayer();
            spectatorLayer.setLayerType(AbilityLayer.Type.SPECTATOR);
            Set<Ability> abilitySet = spectatorLayer.getAbilitiesSet();
            abilitySet.add(Ability.BUILD);
            abilitySet.add(Ability.MINE);
            abilitySet.add(Ability.DOORS_AND_SWITCHES);
            abilitySet.add(Ability.OPEN_CONTAINERS);
            abilitySet.add(Ability.ATTACK_PLAYERS);
            abilitySet.add(Ability.ATTACK_MOBS);
            abilitySet.add(Ability.INVULNERABLE);
            abilitySet.add(Ability.FLYING);
            abilitySet.add(Ability.MAY_FLY);
            abilitySet.add(Ability.INSTABUILD);
            abilitySet.add(Ability.NO_CLIP);
            Set<Ability> abilityValues = spectatorLayer.getAbilityValues();
            abilityValues.add(Ability.INVULNERABLE);
            abilityValues.add(Ability.FLYING);
            abilityValues.add(Ability.NO_CLIP);
            updateAbilitiesPacket.getAbilityLayers().add(spectatorLayer);
        }
        abilityLayer.setLayerType(AbilityLayer.Type.BASE);
        abilityLayer.setFlySpeed(this.flySpeed);
        abilityLayer.setWalkSpeed(this.walkSpeed == 0.0f ? 0.01f : this.walkSpeed);
        Collections.addAll(abilityLayer.getAbilitiesSet(), USED_ABILITIES);
        updateAbilitiesPacket.getAbilityLayers().add(abilityLayer);
        this.sendUpstreamPacket(updateAbilitiesPacket);
    }

    private int getRenderDistance() {
        if (this.clientRenderDistance != -1) {
            return this.clientRenderDistance;
        }
        if (this.serverRenderDistance != -1) {
            return this.serverRenderDistance;
        }
        return 2;
    }

    public void sendJavaClientSettings() {
        ServerboundClientInformationPacket clientSettingsPacket = new ServerboundClientInformationPacket(this.locale(), this.getRenderDistance(), ChatVisibility.FULL, true, SKIN_PARTS, HandPreference.RIGHT_HAND, false, true);
        this.sendDownstreamPacket(clientSettingsPacket);
    }

    public void updateStatistics(@NonNull Object2IntMap<Statistic> statistics) {
        if (this.statistics.isEmpty()) {
            for (CustomStatistic customStatistic : CustomStatistic.values()) {
                this.statistics.put((Statistic)customStatistic, 0);
            }
        }
        this.statistics.putAll(statistics);
    }

    public void refreshEmotes(List<UUID> emotes) {
        this.emotes.addAll(emotes);
        for (GeyserSession player : this.geyser.getSessionManager().getSessions().values()) {
            ArrayList<UUID> pieces = new ArrayList<UUID>();
            for (UUID piece : emotes) {
                if (!player.getEmotes().contains(piece)) {
                    pieces.add(piece);
                }
                player.getEmotes().add(piece);
            }
            EmoteListPacket emoteList = new EmoteListPacket();
            emoteList.setRuntimeEntityId(player.getPlayerEntity().getGeyserId());
            emoteList.getPieceIds().addAll(pieces);
            player.sendUpstreamPacket(emoteList);
        }
    }

    public boolean canUseCommandBlocks() {
        return this.instabuild && this.opPermissionLevel >= 2;
    }

    public void playSoundEvent(SoundEvent sound, Vector3f position) {
        LevelSoundEvent2Packet packet = new LevelSoundEvent2Packet();
        packet.setPosition(position);
        packet.setSound(sound);
        packet.setIdentifier(":");
        packet.setExtraData(-1);
        this.sendUpstreamPacket(packet);
    }

    public float getEyeHeight() {
        return switch (this.pose) {
            case Pose.SNEAKING -> 1.27f;
            case Pose.SWIMMING, Pose.FALL_FLYING, Pose.SPIN_ATTACK -> 0.4f;
            case Pose.SLEEPING -> 0.2f;
            default -> EntityDefinitions.PLAYER.offset();
        };
    }

    @Override
    public @NonNull String bedrockUsername() {
        return this.authData.name();
    }

    @Override
    public @MonotonicNonNull String javaUsername() {
        return this.playerEntity != null ? this.playerEntity.getUsername() : null;
    }

    @Override
    public UUID javaUuid() {
        return this.playerEntity != null ? this.playerEntity.getUuid() : null;
    }

    @Override
    public @NonNull String xuid() {
        return this.authData.xuid();
    }

    @Override
    public @NonNull String version() {
        return this.clientData.getGameVersion();
    }

    @Override
    public @NonNull BedrockPlatform platform() {
        return BedrockPlatform.values()[this.clientData.getDeviceOs().ordinal()];
    }

    @Override
    public @NonNull String languageCode() {
        return this.locale();
    }

    @Override
    public @NonNull UiProfile uiProfile() {
        return UiProfile.values()[this.clientData.getUiProfile().ordinal()];
    }

    @Override
    public @NonNull InputMode inputMode() {
        return InputMode.values()[this.clientData.getCurrentInputMode().ordinal()];
    }

    @Override
    public boolean isLinked() {
        return false;
    }

    @Override
    public boolean transfer(@NonNull String address, @IntRange(from=0L, to=65535L) int port) {
        if (address == null || address.isBlank()) {
            throw new IllegalArgumentException("Server address cannot be null or blank");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Server port must be between 0 and 65535, was " + port);
        }
        TransferPacket transferPacket = new TransferPacket();
        transferPacket.setAddress(address);
        transferPacket.setPort(port);
        this.sendUpstreamPacket(transferPacket);
        return true;
    }

    @Override
    public @NonNull CompletableFuture<@Nullable GeyserEntity> entityByJavaId(@NonNegative int javaId) {
        return this.entities().entityByJavaId(javaId);
    }

    @Override
    public void showEmote(@NonNull GeyserPlayerEntity emoter, @NonNull String emoteId) {
        this.entities().showEmote(emoter, emoteId);
    }

    public void lockInputs(boolean camera, boolean movement) {
        UpdateClientInputLocksPacket packet = new UpdateClientInputLocksPacket();
        int cameraOffset = 2;
        int movementOffset = 4;
        int result = 0;
        if (camera) {
            result |= 2;
        }
        if (movement) {
            result |= 4;
        }
        packet.setLockComponentData(result);
        packet.setServerPosition(this.playerEntity.getPosition());
        this.sendUpstreamPacket(packet);
    }

    @Override
    public @NonNull CameraData camera() {
        return this.cameraData;
    }

    @Override
    public @NonNull EntityData entities() {
        return this.entityData;
    }

    @Override
    public void shakeCamera(float intensity, float duration, @NonNull CameraShake type) {
        this.cameraData.shakeCamera(intensity, duration, type);
    }

    @Override
    public void stopCameraShake() {
        this.cameraData.stopCameraShake();
    }

    @Override
    public void sendFog(String ... fogNameSpaces) {
        this.cameraData.sendFog(fogNameSpaces);
    }

    @Override
    public void removeFog(String ... fogNameSpaces) {
        this.cameraData.removeFog(fogNameSpaces);
    }

    @Override
    public @NonNull Set<String> fogEffects() {
        return this.cameraData.fogEffects();
    }

    public void addCommandEnum(String name, String enums) {
        this.softEnumPacket(name, SoftEnumUpdateType.ADD, enums);
    }

    public void removeCommandEnum(String name, String enums) {
        this.softEnumPacket(name, SoftEnumUpdateType.REMOVE, enums);
    }

    private void softEnumPacket(String name, SoftEnumUpdateType type, String enums) {
        if (!this.geyser.getConfig().isCommandSuggestions()) {
            return;
        }
        UpdateSoftEnumPacket packet = new UpdateSoftEnumPacket();
        packet.setType(type);
        packet.setSoftEnum(new CommandEnumData(name, Collections.singletonMap(enums, Collections.emptySet()), true));
        this.sendUpstreamPacket(packet);
    }

    public GeyserImpl getGeyser() {
        return this.geyser;
    }

    public UpstreamSession getUpstream() {
        return this.upstream;
    }

    public DownstreamSession getDownstream() {
        return this.downstream;
    }

    public EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public AuthData getAuthData() {
        return this.authData;
    }

    public BedrockClientData getClientData() {
        return this.clientData;
    }

    public List<String> getCertChainData() {
        return this.certChainData;
    }

    public @NonNull AbstractGeyserboundPacketHandler getErosionHandler() {
        return this.erosionHandler;
    }

    public RemoteServer remoteServer() {
        return this.remoteServer;
    }

    public SessionPlayerEntity getPlayerEntity() {
        return this.playerEntity;
    }

    public AdvancementsCache getAdvancementsCache() {
        return this.advancementsCache;
    }

    public BookEditCache getBookEditCache() {
        return this.bookEditCache;
    }

    public ChunkCache getChunkCache() {
        return this.chunkCache;
    }

    public EntityCache getEntityCache() {
        return this.entityCache;
    }

    public EntityEffectCache getEffectCache() {
        return this.effectCache;
    }

    public FormCache getFormCache() {
        return this.formCache;
    }

    public LodestoneCache getLodestoneCache() {
        return this.lodestoneCache;
    }

    public PistonCache getPistonCache() {
        return this.pistonCache;
    }

    public PreferencesCache getPreferencesCache() {
        return this.preferencesCache;
    }

    public RegistryCache getRegistryCache() {
        return this.registryCache;
    }

    public SkullCache getSkullCache() {
        return this.skullCache;
    }

    public StructureBlockCache getStructureBlockCache() {
        return this.structureBlockCache;
    }

    public TagCache getTagCache() {
        return this.tagCache;
    }

    public WorldCache getWorldCache() {
        return this.worldCache;
    }

    public TeleportCache getUnconfirmedTeleport() {
        return this.unconfirmedTeleport;
    }

    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    public boolean isInWorldBorderWarningArea() {
        return this.isInWorldBorderWarningArea;
    }

    public PlayerInventory getPlayerInventory() {
        return this.playerInventory;
    }

    public Inventory getOpenInventory() {
        return this.openInventory;
    }

    public boolean isClosingInventory() {
        return this.closingInventory;
    }

    public @NonNull InventoryTranslator getInventoryTranslator() {
        return this.inventoryTranslator;
    }

    public ScheduledFuture<?> getCraftingGridFuture() {
        return this.craftingGridFuture;
    }

    public CollisionManager getCollisionManager() {
        return this.collisionManager;
    }

    public BlockMappings getBlockMappings() {
        return this.blockMappings;
    }

    public ItemMappings getItemMappings() {
        return this.itemMappings;
    }

    public Map<Vector3i, ItemFrameEntity> getItemFrameCache() {
        return this.itemFrameCache;
    }

    public Set<UUID> getPlayerWithCustomHeads() {
        return this.playerWithCustomHeads;
    }

    public boolean isDroppingLecternBook() {
        return this.droppingLecternBook;
    }

    public Vector2i getLastChunkPosition() {
        return this.lastChunkPosition;
    }

    public int getClientRenderDistance() {
        return this.clientRenderDistance;
    }

    public int getServerRenderDistance() {
        return this.serverRenderDistance;
    }

    public boolean isSentSpawnPacket() {
        return this.sentSpawnPacket;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean isLoggingIn() {
        return this.loggingIn;
    }

    public boolean isSpawned() {
        return this.spawned;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public Key getWorldName() {
        return this.worldName;
    }

    public String[] getLevels() {
        return this.levels;
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public Pose getPose() {
        return this.pose;
    }

    public boolean isSprinting() {
        return this.sprinting;
    }

    public int getDimension() {
        return this.dimension;
    }

    public @MonotonicNonNull JavaDimension getDimensionType() {
        return this.dimensionType;
    }

    public int getBreakingBlock() {
        return this.breakingBlock;
    }

    public Vector3i getLastBlockPlacePosition() {
        return this.lastBlockPlacePosition;
    }

    public BlockItem getLastBlockPlaced() {
        return this.lastBlockPlaced;
    }

    public boolean isInteracting() {
        return this.interacting;
    }

    public Vector3i getLastInteractionBlockPosition() {
        return this.lastInteractionBlockPosition;
    }

    public Vector3f getLastInteractionPlayerPosition() {
        return this.lastInteractionPlayerPosition;
    }

    public Entity getMouseoverEntity() {
        return this.mouseoverEntity;
    }

    public Map<String, List<String>> getJavaToBedrockRecipeIds() {
        return this.javaToBedrockRecipeIds;
    }

    public Int2ObjectMap<GeyserRecipe> getCraftingRecipes() {
        return this.craftingRecipes;
    }

    public AtomicInteger getLastRecipeNetId() {
        return this.lastRecipeNetId;
    }

    public Int2ObjectMap<GeyserStonecutterData> getStonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    public boolean isEmulatePost1_13Logic() {
        return this.emulatePost1_13Logic;
    }

    public boolean isEmulatePost1_16Logic() {
        return this.emulatePost1_16Logic;
    }

    public boolean isEmulatePost1_18Logic() {
        return this.emulatePost1_18Logic;
    }

    public boolean isOldSmithingTable() {
        return this.oldSmithingTable;
    }

    public double getAttackSpeed() {
        return this.attackSpeed;
    }

    public long getLastHitTime() {
        return this.lastHitTime;
    }

    public boolean isSteeringLeft() {
        return this.steeringLeft;
    }

    public boolean isSteeringRight() {
        return this.steeringRight;
    }

    public long getLastInteractionTime() {
        return this.lastInteractionTime;
    }

    public long getBlockBreakStartTime() {
        return this.blockBreakStartTime;
    }

    public boolean isPlacedBucket() {
        return this.placedBucket;
    }

    public long getLastMovementTimestamp() {
        return this.lastMovementTimestamp;
    }

    public long getLastVehicleMoveTimestamp() {
        return this.lastVehicleMoveTimestamp;
    }

    public int getArmAnimationTicks() {
        return this.armAnimationTicks;
    }

    public boolean isDaylightCycle() {
        return this.daylightCycle;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public int getOpPermissionLevel() {
        return this.opPermissionLevel;
    }

    public boolean isCanFly() {
        return this.canFly;
    }

    public boolean isFlying() {
        return this.flying;
    }

    public boolean isInstabuild() {
        return this.instabuild;
    }

    public float getFlySpeed() {
        return this.flySpeed;
    }

    public float getWalkSpeed() {
        return this.walkSpeed;
    }

    public boolean isRaining() {
        return this.raining;
    }

    public boolean isThunder() {
        return this.thunder;
    }

    public Object2IntMap<Statistic> getStatistics() {
        return this.statistics;
    }

    public boolean isWaitingForStatistics() {
        return this.waitingForStatistics;
    }

    public Set<UUID> getEmotes() {
        return this.emotes;
    }

    public boolean isAdvancedTooltips() {
        return this.advancedTooltips;
    }

    public ScheduledFuture<?> getTickThread() {
        return this.tickThread;
    }

    public ScheduledFuture<?> getLookBackScheduledFuture() {
        return this.lookBackScheduledFuture;
    }

    public ScheduledFuture<?> getMountVehicleScheduledFuture() {
        return this.mountVehicleScheduledFuture;
    }

    public Queue<Long> getKeepAliveCache() {
        return this.keepAliveCache;
    }

    public @Nullable ItemData getCurrentBook() {
        return this.currentBook;
    }

    public GeyserCameraData getCameraData() {
        return this.cameraData;
    }

    public GeyserEntityData getEntityData() {
        return this.entityData;
    }

    public MinecraftProtocol getProtocol() {
        return this.protocol;
    }

    public void setAuthData(AuthData authData) {
        this.authData = authData;
    }

    public void setClientData(BedrockClientData clientData) {
        this.clientData = clientData;
    }

    public void setCertChainData(List<String> certChainData) {
        this.certChainData = certChainData;
    }

    public void setErosionHandler(@NonNull AbstractGeyserboundPacketHandler erosionHandler) {
        if (erosionHandler == null) {
            throw new NullPointerException("erosionHandler is marked non-null but is null");
        }
        this.erosionHandler = erosionHandler;
    }

    public GeyserSession remoteServer(RemoteServer remoteServer) {
        this.remoteServer = remoteServer;
        return this;
    }

    public void setUnconfirmedTeleport(TeleportCache unconfirmedTeleport) {
        this.unconfirmedTeleport = unconfirmedTeleport;
    }

    public void setOpenInventory(Inventory openInventory) {
        this.openInventory = openInventory;
    }

    public void setClosingInventory(boolean closingInventory) {
        this.closingInventory = closingInventory;
    }

    public void setInventoryTranslator(@NonNull InventoryTranslator inventoryTranslator) {
        if (inventoryTranslator == null) {
            throw new NullPointerException("inventoryTranslator is marked non-null but is null");
        }
        this.inventoryTranslator = inventoryTranslator;
    }

    public void setCraftingGridFuture(ScheduledFuture<?> craftingGridFuture) {
        this.craftingGridFuture = craftingGridFuture;
    }

    public void setBlockMappings(BlockMappings blockMappings) {
        this.blockMappings = blockMappings;
    }

    public void setItemMappings(ItemMappings itemMappings) {
        this.itemMappings = itemMappings;
    }

    public void setDroppingLecternBook(boolean droppingLecternBook) {
        this.droppingLecternBook = droppingLecternBook;
    }

    public void setLastChunkPosition(Vector2i lastChunkPosition) {
        this.lastChunkPosition = lastChunkPosition;
    }

    public void setClientRenderDistance(int clientRenderDistance) {
        this.clientRenderDistance = clientRenderDistance;
    }

    public void setSpawned(boolean spawned) {
        this.spawned = spawned;
    }

    public void setWorldName(Key worldName) {
        this.worldName = worldName;
    }

    public void setLevels(String[] levels) {
        this.levels = levels;
    }

    public void setPose(Pose pose) {
        this.pose = pose;
    }

    public void setSprinting(boolean sprinting) {
        this.sprinting = sprinting;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setDimensionType(@MonotonicNonNull JavaDimension dimensionType) {
        this.dimensionType = dimensionType;
    }

    public void setBreakingBlock(int breakingBlock) {
        this.breakingBlock = breakingBlock;
    }

    public void setLastBlockPlacePosition(Vector3i lastBlockPlacePosition) {
        this.lastBlockPlacePosition = lastBlockPlacePosition;
    }

    public void setLastBlockPlaced(BlockItem lastBlockPlaced) {
        this.lastBlockPlaced = lastBlockPlaced;
    }

    public void setInteracting(boolean interacting) {
        this.interacting = interacting;
    }

    public void setLastInteractionBlockPosition(Vector3i lastInteractionBlockPosition) {
        this.lastInteractionBlockPosition = lastInteractionBlockPosition;
    }

    public void setLastInteractionPlayerPosition(Vector3f lastInteractionPlayerPosition) {
        this.lastInteractionPlayerPosition = lastInteractionPlayerPosition;
    }

    public void setMouseoverEntity(Entity mouseoverEntity) {
        this.mouseoverEntity = mouseoverEntity;
    }

    public void setCraftingRecipes(Int2ObjectMap<GeyserRecipe> craftingRecipes) {
        this.craftingRecipes = craftingRecipes;
    }

    public void setStonecutterRecipes(Int2ObjectMap<GeyserStonecutterData> stonecutterRecipes) {
        this.stonecutterRecipes = stonecutterRecipes;
    }

    public void setEmulatePost1_13Logic(boolean emulatePost1_13Logic) {
        this.emulatePost1_13Logic = emulatePost1_13Logic;
    }

    public void setEmulatePost1_16Logic(boolean emulatePost1_16Logic) {
        this.emulatePost1_16Logic = emulatePost1_16Logic;
    }

    public void setEmulatePost1_18Logic(boolean emulatePost1_18Logic) {
        this.emulatePost1_18Logic = emulatePost1_18Logic;
    }

    public void setOldSmithingTable(boolean oldSmithingTable) {
        this.oldSmithingTable = oldSmithingTable;
    }

    public void setAttackSpeed(double attackSpeed) {
        this.attackSpeed = attackSpeed;
    }

    public void setLastHitTime(long lastHitTime) {
        this.lastHitTime = lastHitTime;
    }

    public void setSteeringLeft(boolean steeringLeft) {
        this.steeringLeft = steeringLeft;
    }

    public void setSteeringRight(boolean steeringRight) {
        this.steeringRight = steeringRight;
    }

    public void setLastInteractionTime(long lastInteractionTime) {
        this.lastInteractionTime = lastInteractionTime;
    }

    public void setBlockBreakStartTime(long blockBreakStartTime) {
        this.blockBreakStartTime = blockBreakStartTime;
    }

    public void setPlacedBucket(boolean placedBucket) {
        this.placedBucket = placedBucket;
    }

    public void setLastMovementTimestamp(long lastMovementTimestamp) {
        this.lastMovementTimestamp = lastMovementTimestamp;
    }

    public void setLastVehicleMoveTimestamp(long lastVehicleMoveTimestamp) {
        this.lastVehicleMoveTimestamp = lastVehicleMoveTimestamp;
    }

    public void setOpPermissionLevel(int opPermissionLevel) {
        this.opPermissionLevel = opPermissionLevel;
    }

    public void setCanFly(boolean canFly) {
        this.canFly = canFly;
    }

    public void setInstabuild(boolean instabuild) {
        this.instabuild = instabuild;
    }

    public void setFlySpeed(float flySpeed) {
        this.flySpeed = flySpeed;
    }

    public void setWalkSpeed(float walkSpeed) {
        this.walkSpeed = walkSpeed;
    }

    public void setRaining(boolean raining) {
        this.raining = raining;
    }

    public void setThunder(boolean thunder) {
        this.thunder = thunder;
    }

    public void setWaitingForStatistics(boolean waitingForStatistics) {
        this.waitingForStatistics = waitingForStatistics;
    }

    public void setAdvancedTooltips(boolean advancedTooltips) {
        this.advancedTooltips = advancedTooltips;
    }

    public void setLookBackScheduledFuture(ScheduledFuture<?> lookBackScheduledFuture) {
        this.lookBackScheduledFuture = lookBackScheduledFuture;
    }

    public void setMountVehicleScheduledFuture(ScheduledFuture<?> mountVehicleScheduledFuture) {
        this.mountVehicleScheduledFuture = mountVehicleScheduledFuture;
    }

    public void setCurrentBook(@Nullable ItemData currentBook) {
        this.currentBook = currentBook;
    }

    public void setCookies(Map<String, byte[]> cookies) {
        this.cookies = cookies;
    }

    public Map<String, byte[]> getCookies() {
        return this.cookies;
    }
}

