/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapedRecipe;
import org.geysermc.geyser.inventory.recipe.GeyserShapelessRecipe;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodec;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.Ingredient;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.RecipeType;

public final class RecipeRegistryLoader
implements RegistryLoader<String, Map<RecipeType, List<GeyserRecipe>>> {
    @Override
    public Map<RecipeType, List<GeyserRecipe>> load(String input) {
        List<NbtMap> recipes;
        Object2ObjectOpenHashMap<RecipeType, List<GeyserRecipe>> deserializedRecipes = new Object2ObjectOpenHashMap<RecipeType, List<GeyserRecipe>>();
        try (InputStream stream = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow("mappings/recipes.nbt");
             NBTInputStream nbtStream = new NBTInputStream(new DataInputStream(stream));){
            recipes = ((NbtMap)nbtStream.readTag()).getList("recipes", NbtType.COMPOUND);
        }
        catch (Exception e) {
            throw new AssertionError(GeyserLocale.getLocaleStringLog("geyser.toolbox.fail.runtime_java"), e);
        }
        MinecraftCodecHelper helper = MinecraftCodec.CODEC.getHelperFactory().get();
        for (NbtMap recipeCollection : recipes) {
            Pair<RecipeType, List<GeyserRecipe>> pair = RecipeRegistryLoader.getRecipes(recipeCollection, helper);
            deserializedRecipes.put(pair.key(), pair.value());
        }
        return deserializedRecipes;
    }

    private static Pair<RecipeType, List<GeyserRecipe>> getRecipes(NbtMap recipes, MinecraftCodecHelper helper) {
        List<NbtMap> typedRecipes = recipes.getList("recipes", NbtType.COMPOUND);
        RecipeType recipeType = RecipeType.from(recipes.getInt("recipe_type", -1));
        if (recipeType == RecipeType.CRAFTING_SPECIAL_TIPPEDARROW) {
            return Pair.of(recipeType, RecipeRegistryLoader.getShapedRecipes(typedRecipes, helper));
        }
        return Pair.of(recipeType, RecipeRegistryLoader.getShapelessRecipes(typedRecipes, helper));
    }

    private static List<GeyserRecipe> getShapelessRecipes(List<NbtMap> recipes, MinecraftCodecHelper helper) {
        ObjectArrayList<GeyserRecipe> deserializedRecipes = new ObjectArrayList<GeyserRecipe>(recipes.size());
        for (NbtMap recipe : recipes) {
            ItemStack output = RecipeRegistryLoader.toItemStack(recipe.getCompound("output"), helper);
            List<NbtMap> rawInputs = recipe.getList("inputs", NbtType.COMPOUND);
            Ingredient[] javaInputs = new Ingredient[rawInputs.size()];
            for (int i = 0; i < rawInputs.size(); ++i) {
                javaInputs[i] = new Ingredient(new ItemStack[]{RecipeRegistryLoader.toItemStack(rawInputs.get(i), helper)});
            }
            deserializedRecipes.add(new GeyserShapelessRecipe(javaInputs, output));
        }
        return deserializedRecipes;
    }

    private static List<GeyserRecipe> getShapedRecipes(List<NbtMap> recipes, MinecraftCodecHelper helper) {
        ObjectArrayList<GeyserRecipe> deserializedRecipes = new ObjectArrayList<GeyserRecipe>(recipes.size());
        for (NbtMap recipe : recipes) {
            ItemStack output = RecipeRegistryLoader.toItemStack(recipe.getCompound("output"), helper);
            List<int[]> shape = recipe.getList("shape", NbtType.INT_ARRAY);
            ArrayList<ItemStack> letterToRecipe = new ArrayList<ItemStack>();
            for (NbtMap rawInput : recipe.getList("inputs", NbtType.COMPOUND)) {
                letterToRecipe.add(RecipeRegistryLoader.toItemStack(rawInput, helper));
            }
            Ingredient[] inputs = new Ingredient[shape.size() * shape.get(0).length];
            int i = 0;
            int j = 0;
            while (i < shape.size() * shape.get(0).length) {
                for (int index : shape.get(j)) {
                    ItemStack stack = (ItemStack)letterToRecipe.get(index);
                    inputs[i++] = new Ingredient(new ItemStack[]{stack});
                }
                ++j;
            }
            deserializedRecipes.add(new GeyserShapedRecipe(shape.size(), shape.get(0).length, inputs, output));
        }
        return deserializedRecipes;
    }

    private static ItemStack toItemStack(NbtMap nbt, MinecraftCodecHelper helper) {
        int id = nbt.getInt("id");
        int count = nbt.getInt("count", 1);
        String componentsRaw = nbt.getString("components", null);
        if (componentsRaw != null) {
            byte[] bytes = Base64.getDecoder().decode(componentsRaw);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
            DataComponents components = helper.readDataComponentPatch(buf);
            return new ItemStack(id, count, components);
        }
        return new ItemStack(id, count);
    }
}

