/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.geysermc.geyser.registry.IRegistry;
import org.geysermc.geyser.registry.Registry;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.geyser.registry.loader.RegistryLoaders;

public final class DeferredRegistry<M>
implements IRegistry<M> {
    private final Registry<M> backingRegistry;
    private final Supplier<M> loader;
    private boolean loaded;

    private <I> DeferredRegistry(Function<RegistryLoader<I, M>, Registry<M>> registryLoader, RegistryLoader<I, M> deferredLoader) {
        this.backingRegistry = registryLoader.apply(RegistryLoaders.uninitialized());
        this.loader = () -> deferredLoader.load(null);
    }

    private <I> DeferredRegistry(Function<RegistryLoader<I, M>, Registry<M>> registryLoader, Supplier<RegistryLoader<I, M>> deferredLoader) {
        this.backingRegistry = registryLoader.apply(RegistryLoaders.uninitialized());
        this.loader = () -> ((RegistryLoader)deferredLoader.get()).load(null);
    }

    private <I> DeferredRegistry(I input, RegistryInitializer<M> registryInitializer, RegistryLoader<I, M> deferredLoader) {
        this.backingRegistry = registryInitializer.initialize(input, RegistryLoaders.uninitialized());
        this.loader = () -> deferredLoader.load(input);
    }

    private <I> DeferredRegistry(I input, RegistryInitializer<M> registryInitializer, Supplier<RegistryLoader<I, M>> deferredLoader) {
        this.backingRegistry = registryInitializer.initialize(input, RegistryLoaders.uninitialized());
        this.loader = () -> ((RegistryLoader)deferredLoader.get()).load(input);
    }

    @Override
    public M get() {
        if (!this.loaded) {
            throw new IllegalStateException("Registry has not been loaded yet!");
        }
        return this.backingRegistry.get();
    }

    @Override
    public void set(M mappings) {
        this.backingRegistry.set(mappings);
    }

    @Override
    public void register(Consumer<M> consumer) {
        if (!this.loaded) {
            throw new IllegalStateException("Registry has not been loaded yet!");
        }
        this.backingRegistry.register(consumer);
    }

    public void load() {
        this.backingRegistry.set(this.loader.get());
        this.loaded = true;
    }

    public static <I, M> DeferredRegistry<M> create(Function<RegistryLoader<I, M>, Registry<M>> registryLoader, RegistryLoader<I, M> deferredLoader) {
        return new DeferredRegistry<M>(registryLoader, deferredLoader);
    }

    public static <I, M> DeferredRegistry<M> create(Function<RegistryLoader<I, M>, Registry<M>> registryLoader, Supplier<RegistryLoader<I, M>> deferredLoader) {
        return new DeferredRegistry<M>(registryLoader, deferredLoader);
    }

    public static <I, M> DeferredRegistry<M> create(I input, RegistryInitializer<M> registryInitializer, RegistryLoader<I, M> deferredLoader) {
        return new DeferredRegistry<M>(input, registryInitializer, deferredLoader);
    }

    public static <I, M> DeferredRegistry<M> create(I input, RegistryInitializer<M> registryInitializer, Supplier<RegistryLoader<I, M>> deferredLoader) {
        return new DeferredRegistry<M>(input, registryInitializer, deferredLoader);
    }

    static interface RegistryInitializer<M> {
        public <I> Registry<M> initialize(I var1, RegistryLoader<I, M> var2);
    }
}

