/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.bungeecord.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.plugin.TabExecutor;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandExecutor;
import org.geysermc.geyser.platform.bungeecord.command.BungeeCommandSource;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;

public class GeyserBungeeCommandExecutor
extends net.md_5.bungee.api.plugin.Command
implements TabExecutor {
    private final GeyserCommandExecutor commandExecutor;

    public GeyserBungeeCommandExecutor(String name, GeyserImpl geyser, Map<String, Command> commands) {
        super(name);
        this.commandExecutor = new GeyserCommandExecutor(geyser, commands);
    }

    public void execute(CommandSender sender, String[] args) {
        BungeeCommandSource commandSender = new BungeeCommandSource(sender);
        GeyserSession session = this.commandExecutor.getGeyserSession(commandSender);
        if (args.length > 0) {
            GeyserCommand command = this.commandExecutor.getCommand(args[0]);
            if (command != null) {
                if (!sender.hasPermission(command.permission())) {
                    String message = GeyserLocale.getPlayerLocaleString("geyser.bootstrap.command.permission_fail", commandSender.locale());
                    commandSender.sendMessage(ChatColor.RED + message);
                    return;
                }
                if (command.isBedrockOnly() && session == null) {
                    String message = GeyserLocale.getPlayerLocaleString("geyser.bootstrap.command.bedrock_only", commandSender.locale());
                    commandSender.sendMessage(ChatColor.RED + message);
                    return;
                }
                command.execute(session, commandSender, args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
            } else {
                String message = GeyserLocale.getPlayerLocaleString("geyser.bootstrap.command.not_found", commandSender.locale());
                commandSender.sendMessage(ChatColor.RED + message);
            }
        } else {
            this.commandExecutor.getCommand("help").execute(session, commandSender, new String[0]);
        }
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return this.commandExecutor.tabComplete(new BungeeCommandSource(sender));
        }
        return Collections.emptyList();
    }
}

