/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.bungeecord;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.protocol.ProtocolConstants;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.util.PlatformType;
import org.geysermc.geyser.command.GeyserCommandManager;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.ping.GeyserLegacyPingPassthrough;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.bungeecord.GeyserBungeeConfiguration;
import org.geysermc.geyser.platform.bungeecord.GeyserBungeeDumpInfo;
import org.geysermc.geyser.platform.bungeecord.GeyserBungeeInjector;
import org.geysermc.geyser.platform.bungeecord.GeyserBungeeLogger;
import org.geysermc.geyser.platform.bungeecord.GeyserBungeePingPassthrough;
import org.geysermc.geyser.platform.bungeecord.command.GeyserBungeeCommandExecutor;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;

public class GeyserBungeePlugin
extends Plugin
implements GeyserBootstrap {
    private GeyserCommandManager geyserCommandManager;
    private GeyserBungeeConfiguration geyserConfig;
    private GeyserBungeeInjector geyserInjector;
    private final GeyserBungeeLogger geyserLogger = new GeyserBungeeLogger(this.getLogger());
    private IGeyserPingPassthrough geyserBungeePingPassthrough;
    private GeyserImpl geyser;

    public void onLoad() {
        this.onGeyserInitialize();
    }

    @Override
    public void onGeyserInitialize() {
        GeyserLocale.init(this);
        try {
            ProtocolConstants.class.getField("MINECRAFT_1_21");
        }
        catch (NoSuchFieldException e) {
            this.geyserLogger.error("      / \\");
            this.geyserLogger.error("     /   \\");
            this.geyserLogger.error("    /  |  \\");
            this.geyserLogger.error("   /   |   \\    " + GeyserLocale.getLocaleStringLog("geyser.bootstrap.unsupported_proxy", this.getProxy().getName()));
            this.geyserLogger.error("  /         \\   " + GeyserLocale.getLocaleStringLog("geyser.may_not_work_as_intended_all_caps"));
            this.geyserLogger.error(" /     o     \\");
            this.geyserLogger.error("/_____________\\");
        }
        if (!this.loadConfig()) {
            return;
        }
        this.geyserLogger.setDebug(this.geyserConfig.isDebugMode());
        GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
        this.geyser = GeyserImpl.load(PlatformType.BUNGEECORD, this);
        this.geyserInjector = new GeyserBungeeInjector(this);
    }

    public void onEnable() {
        this.awaitStartupCompletion(0);
    }

    private void awaitStartupCompletion(int tries) {
        if (tries >= 20) {
            this.geyserLogger.warning("BungeeCord plugin startup is taking abnormally long, so Geyser is starting now. If all your plugins are loaded properly, this is a bug! If not, consider cutting down the amount of plugins on your proxy as it is causing abnormally slow starting times.");
            this.onGeyserEnable();
            return;
        }
        try {
            Field listenersField = BungeeCord.getInstance().getClass().getDeclaredField("listeners");
            listenersField.setAccessible(true);
            Collection listeners = (Collection)listenersField.get(BungeeCord.getInstance());
            if (listeners.isEmpty()) {
                this.getProxy().getScheduler().schedule((Plugin)this, this::onGeyserEnable, (long)tries, TimeUnit.SECONDS);
            } else {
                this.awaitStartupCompletion(++tries);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void onGeyserEnable() {
        if (GeyserImpl.getInstance().isReloading()) {
            if (!this.loadConfig()) {
                return;
            }
            this.geyserLogger.setDebug(this.geyserConfig.isDebugMode());
            GeyserConfiguration.checkGeyserConfiguration(this.geyserConfig, this.geyserLogger);
        } else {
            this.geyserCommandManager = new GeyserCommandManager(this.geyser);
            this.geyserCommandManager.init();
        }
        for (ListenerInfo listenerInfo : this.getProxy().getConfig().getListeners()) {
            if (!listenerInfo.isQueryEnabled() || listenerInfo.getQueryPort() != this.geyserConfig.getBedrock().port()) continue;
            try {
                Field queryField = ListenerInfo.class.getDeclaredField("queryEnabled");
                queryField.setAccessible(true);
                queryField.setBoolean(listenerInfo, false);
                this.geyserLogger.warning("We force-disabled query on port " + listenerInfo.getQueryPort() + " in order for Geyser to boot up successfully. To remove this message, disable query in your proxy's config.");
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                this.geyserLogger.warning("Could not force-disable query. Geyser may not start correctly!");
                if (!this.geyserLogger.isDebug()) continue;
                e.printStackTrace();
            }
        }
        GeyserImpl.start();
        this.geyserBungeePingPassthrough = this.geyserConfig.isLegacyPingPassthrough() ? GeyserLegacyPingPassthrough.init(this.geyser) : new GeyserBungeePingPassthrough(this.getProxy());
        if (GeyserImpl.getInstance().isReloading()) {
            return;
        }
        this.geyserInjector.initializeLocalChannel(this);
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new GeyserBungeeCommandExecutor("geyser", this.geyser, this.geyserCommandManager.getCommands()));
        for (Map.Entry entry : this.geyserCommandManager.extensionCommands().entrySet()) {
            Map commands = (Map)entry.getValue();
            if (commands.isEmpty()) continue;
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new GeyserBungeeCommandExecutor(((Extension)entry.getKey()).description().id(), this.geyser, commands));
        }
    }

    @Override
    public void onGeyserDisable() {
        if (this.geyser != null) {
            this.geyser.disable();
        }
    }

    @Override
    public void onGeyserShutdown() {
        if (this.geyser != null) {
            this.geyser.shutdown();
        }
        if (this.geyserInjector != null) {
            this.geyserInjector.shutdown();
        }
    }

    public void onDisable() {
        this.onGeyserShutdown();
    }

    @Override
    public GeyserBungeeConfiguration getGeyserConfig() {
        return this.geyserConfig;
    }

    @Override
    public GeyserBungeeLogger getGeyserLogger() {
        return this.geyserLogger;
    }

    @Override
    public GeyserCommandManager getGeyserCommandManager() {
        return this.geyserCommandManager;
    }

    @Override
    public IGeyserPingPassthrough getGeyserPingPassthrough() {
        return this.geyserBungeePingPassthrough;
    }

    @Override
    public Path getConfigFolder() {
        return this.getDataFolder().toPath();
    }

    @Override
    public BootstrapDumpInfo getDumpInfo() {
        return new GeyserBungeeDumpInfo(this.getProxy());
    }

    @Override
    public Path getLogsPath() {
        return Paths.get(this.getProxy().getName().equals("BungeeCord") ? "proxy.log.0" : "logs/latest.log", new String[0]);
    }

    @Override
    public @Nullable SocketAddress getSocketAddress() {
        return this.geyserInjector.getServerSocketAddress();
    }

    @Override
    public @NonNull String getServerBindAddress() {
        return this.findCompatibleListener().map(InetSocketAddress::getHostString).orElse("");
    }

    @Override
    public int getServerPort() {
        return this.findCompatibleListener().stream().mapToInt(InetSocketAddress::getPort).findFirst().orElse(-1);
    }

    @Override
    public boolean testFloodgatePluginPresent() {
        if (this.getProxy().getPluginManager().getPlugin("floodgate") != null) {
            this.geyserConfig.loadFloodgate(this);
            return true;
        }
        return false;
    }

    private Optional<InetSocketAddress> findCompatibleListener() {
        return this.getProxy().getConfig().getListeners().stream().filter(info -> info.getSocketAddress() instanceof InetSocketAddress).map(info -> (InetSocketAddress)info.getSocketAddress()).findFirst();
    }

    private boolean loadConfig() {
        try {
            if (!this.getDataFolder().exists()) {
                this.getDataFolder().mkdir();
            }
            File configFile = FileUtils.fileOrCopiedFromResource(new File(this.getDataFolder(), "config.yml"), "config.yml", x -> x.replaceAll("generateduuid", UUID.randomUUID().toString()), this);
            this.geyserConfig = FileUtils.loadConfig(configFile, GeyserBungeeConfiguration.class);
        }
        catch (IOException ex) {
            this.geyserLogger.error(GeyserLocale.getLocaleStringLog("geyser.config.failed"), ex);
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

