/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.bungeecord;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.util.AttributeKey;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.Set;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.event.ProxyReloadEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;
import net.md_5.bungee.netty.PipelineUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.network.netty.GeyserInjector;
import org.geysermc.geyser.network.netty.LocalServerChannelWrapper;
import org.geysermc.geyser.network.netty.LocalSession;
import org.geysermc.geyser.platform.bungeecord.GeyserBungeeCompressionDisabler;

public class GeyserBungeeInjector
extends GeyserInjector
implements Listener {
    private final Plugin plugin;
    private final ProxyServer proxy;
    private ChannelInitializer<Channel> channelInitializer = null;
    private Set<Channel> bungeeChannels = null;
    private boolean eventRegistered = false;

    public GeyserBungeeInjector(Plugin plugin) {
        this.plugin = plugin;
        this.proxy = plugin.getProxy();
    }

    @Override
    protected void initializeLocalChannel0(final GeyserBootstrap bootstrap) throws Exception {
        ChannelFuture channelFuture;
        EventLoopGroup workerGroup;
        EventLoopGroup bossGroup;
        if (this.proxy.getConfig().getListeners().size() != 1) {
            throw new UnsupportedOperationException("Geyser does not currently support multiple listeners with injection! Please reach out to us on our Discord at https://discord.gg/GeyserMC so we can hear feedback on your setup.");
        }
        ListenerInfo listenerInfo = (ListenerInfo)this.proxy.getConfig().getListeners().stream().findFirst().orElseThrow(IllegalStateException::new);
        Class<?> proxyClass = this.proxy.getClass();
        try {
            EventLoopGroup eventLoops;
            bossGroup = eventLoops = (EventLoopGroup)proxyClass.getField("eventLoops").get(this.proxy);
            workerGroup = eventLoops;
            bootstrap.getGeyserLogger().debug("BungeeCord event loop style detected.");
        }
        catch (NoSuchFieldException e) {
            bossGroup = (EventLoopGroup)proxyClass.getField("bossEventLoopGroup").get(this.proxy);
            workerGroup = (EventLoopGroup)proxyClass.getField("workerEventLoopGroup").get(this.proxy);
            bootstrap.getGeyserLogger().debug("Waterfall event loop style detected.");
        }
        AttributeKey listener = PipelineUtils.LISTENER;
        listenerInfo = new ListenerInfo(listenerInfo.getSocketAddress(), listenerInfo.getMotd(), listenerInfo.getMaxPlayers(), listenerInfo.getTabListSize(), listenerInfo.getServerPriority(), listenerInfo.isForceDefault(), listenerInfo.getForcedHosts(), listenerInfo.getTabListType(), listenerInfo.isSetLocalAddress(), listenerInfo.isPingPassthrough(), listenerInfo.getQueryPort(), listenerInfo.isQueryEnabled(), bootstrap.getGeyserConfig().getRemote().isUseProxyProtocol());
        Field listenerField = proxyClass.getDeclaredField("listeners");
        listenerField.setAccessible(true);
        this.bungeeChannels = (Set)listenerField.get(this.proxy);
        final Method initChannel = ChannelInitializer.class.getDeclaredMethod("initChannel", Channel.class);
        initChannel.setAccessible(true);
        this.localChannel = channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannelWrapper.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(@NonNull Channel ch) throws Exception {
                if (GeyserBungeeInjector.this.proxy.getConfig().getServers() == null) {
                    bootstrap.getGeyserLogger().info("Disconnecting player as Bungee has not finished loading");
                    ch.close();
                    return;
                }
                if (GeyserBungeeInjector.this.channelInitializer == null) {
                    GeyserBungeeInjector.this.channelInitializer = PipelineUtils.SERVER_CHILD;
                }
                initChannel.invoke(GeyserBungeeInjector.this.channelInitializer, ch);
                if (bootstrap.getGeyserConfig().isDisableCompression()) {
                    ch.pipeline().addAfter("packet-encoder", "geyser-compression-disabler", (ChannelHandler)new GeyserBungeeCompressionDisabler());
                }
            }
        }).childAttr(listener, (Object)listenerInfo).group(bossGroup, workerGroup).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
        this.bungeeChannels.add(this.localChannel.channel());
        this.serverSocketAddress = channelFuture.channel().localAddress();
        if (!this.eventRegistered) {
            this.proxy.getPluginManager().registerListener(this.plugin, (Listener)this);
            this.eventRegistered = true;
        }
        LocalSession.createDirectByteBufAllocator();
    }

    @Override
    public void shutdown() {
        if (this.localChannel != null && this.bungeeChannels != null) {
            this.bungeeChannels.remove(this.localChannel.channel());
            this.bungeeChannels = null;
        }
        super.shutdown();
    }

    @EventHandler
    public void onProxyReload(ProxyReloadEvent event) {
        this.bungeeChannels = null;
        if (this.localChannel != null) {
            this.shutdown();
            this.initializeLocalChannel(GeyserImpl.getInstance().getBootstrap());
        }
    }
}

