/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block.type;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.BasicEnumProperty;
import org.geysermc.geyser.level.block.property.IntegerProperty;
import org.geysermc.geyser.level.block.property.Property;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.block.type.SkullBlock;
import org.geysermc.geyser.level.physics.PistonBehavior;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;
import org.intellij.lang.annotations.Subst;

public class Block {
    public static final int JAVA_AIR_ID = 0;
    private final Key javaIdentifier;
    private final boolean requiresCorrectToolForDrops;
    private final @Nullable BlockEntityType blockEntityType;
    private final float destroyTime;
    private final @NonNull PistonBehavior pushReaction;
    private final Supplier<Item> pickItem;
    protected Item item = null;
    private int javaId = -1;
    private final Property<?>[] propertyKeys;
    private final BlockState defaultState;

    public Block(@Subst(value="empty") String javaIdentifier, Builder builder) {
        this.javaIdentifier = Key.key(javaIdentifier);
        this.requiresCorrectToolForDrops = builder.requiresCorrectToolForDrops;
        this.blockEntityType = builder.blockEntityType;
        this.destroyTime = builder.destroyTime;
        this.pushReaction = builder.pushReaction;
        this.pickItem = builder.pickItem;
        BlockState firstState = builder.build(this).get(0);
        this.propertyKeys = builder.propertyKeys;
        this.defaultState = this.setDefaultState(firstState);
    }

    public void updateBlock(GeyserSession session, BlockState state, Vector3i position) {
        this.checkForEmptySkull(session, state, position);
        GeyserBedrockBlock definition = session.getBlockMappings().getBedrockBlock(state);
        this.sendBlockUpdatePacket(session, state, definition, position);
        if (!session.getBlockMappings().getExtendedCollisionBoxes().isEmpty()) {
            int aboveBlock = session.getGeyser().getWorldManager().getBlockAt(session, position.getX(), position.getY() + 1, position.getZ());
            BlockDefinition aboveBedrockExtendedCollisionDefinition = (BlockDefinition)session.getBlockMappings().getExtendedCollisionBoxes().get(state.javaId());
            int belowBlock = session.getGeyser().getWorldManager().getBlockAt(session, position.getX(), position.getY() - 1, position.getZ());
            BlockDefinition belowBedrockExtendedCollisionDefinition = (BlockDefinition)session.getBlockMappings().getExtendedCollisionBoxes().get(belowBlock);
            if (belowBedrockExtendedCollisionDefinition != null && state.is(Blocks.AIR)) {
                UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
                updateBlockPacket.setDataLayer(0);
                updateBlockPacket.setBlockPosition(position);
                updateBlockPacket.setDefinition(belowBedrockExtendedCollisionDefinition);
                updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
                session.sendUpstreamPacket(updateBlockPacket);
            } else if (aboveBedrockExtendedCollisionDefinition != null && aboveBlock == 0) {
                UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
                updateBlockPacket.setDataLayer(0);
                updateBlockPacket.setBlockPosition(position.add(0, 1, 0));
                updateBlockPacket.setDefinition(aboveBedrockExtendedCollisionDefinition);
                updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
                session.sendUpstreamPacket(updateBlockPacket);
            } else if (aboveBlock == 0) {
                UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
                updateBlockPacket.setDataLayer(0);
                updateBlockPacket.setBlockPosition(position.add(0, 1, 0));
                updateBlockPacket.setDefinition(session.getBlockMappings().getBedrockAir());
                updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
                session.sendUpstreamPacket(updateBlockPacket);
            }
        }
    }

    protected void sendBlockUpdatePacket(GeyserSession session, BlockState state, BlockDefinition definition, Vector3i position) {
        UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
        updateBlockPacket.setDataLayer(0);
        updateBlockPacket.setBlockPosition(position);
        updateBlockPacket.setDefinition(definition);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
        session.sendUpstreamPacket(updateBlockPacket);
        UpdateBlockPacket waterPacket = new UpdateBlockPacket();
        waterPacket.setDataLayer(1);
        waterPacket.setBlockPosition(position);
        if (((BitSet)BlockRegistries.WATERLOGGED.get()).get(state.javaId())) {
            waterPacket.setDefinition(session.getBlockMappings().getBedrockWater());
        } else {
            waterPacket.setDefinition(session.getBlockMappings().getBedrockAir());
        }
        session.sendUpstreamPacket(waterPacket);
    }

    protected void checkForEmptySkull(GeyserSession session, BlockState state, Vector3i position) {
        if (!(state.block() instanceof SkullBlock)) {
            session.getSkullCache().removeSkull(position);
        }
    }

    public Item asItem() {
        if (this.item == null) {
            this.item = Item.byBlock(this);
            return this.item;
        }
        return this.item;
    }

    public ItemStack pickItem(BlockState state) {
        if (this.pickItem != null) {
            return new ItemStack(this.pickItem.get().javaId());
        }
        return new ItemStack(this.asItem().javaId());
    }

    protected BlockState setDefaultState(BlockState firstState) {
        return firstState;
    }

    public @NonNull Key javaIdentifier() {
        return this.javaIdentifier;
    }

    public boolean requiresCorrectToolForDrops() {
        return this.requiresCorrectToolForDrops;
    }

    public boolean hasBlockEntity() {
        return this.blockEntityType != null;
    }

    public @Nullable BlockEntityType blockEntityType() {
        return this.blockEntityType;
    }

    public float destroyTime() {
        return this.destroyTime;
    }

    public @NonNull PistonBehavior pushReaction() {
        return this.pushReaction;
    }

    public BlockState defaultBlockState() {
        return this.defaultState;
    }

    public int javaId() {
        return this.javaId;
    }

    public void setJavaId(int javaId) {
        if (this.javaId != -1) {
            throw new RuntimeException("Block ID has already been set!");
        }
        this.javaId = javaId;
    }

    public String toString() {
        return "Block{javaIdentifier='" + this.javaIdentifier + "', javaId=" + this.javaId + "}";
    }

    Property<?>[] propertyKeys() {
        return this.propertyKeys;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<Property<?>, List<Comparable<?>>> states = new LinkedHashMap();
        private boolean requiresCorrectToolForDrops = false;
        private BlockEntityType blockEntityType = null;
        private PistonBehavior pushReaction = PistonBehavior.NORMAL;
        private float destroyTime;
        private Supplier<Item> pickItem;
        private Property<?>[] propertyKeys;

        public Builder enumState(BasicEnumProperty property) {
            this.states.put(property, (List)property.values());
            return this;
        }

        @SafeVarargs
        public final <T extends Enum<T>> Builder enumState(Property<T> property, T ... enums) {
            this.states.put(property, List.of(enums));
            return this;
        }

        public Builder booleanState(Property<Boolean> property) {
            this.states.put(property, List.of(Boolean.TRUE, Boolean.FALSE));
            return this;
        }

        public Builder intState(IntegerProperty property) {
            int low = property.low();
            int high = property.high();
            IntArrayList list = new IntArrayList();
            for (int i = low; i <= high; ++i) {
                list.add(i);
            }
            this.states.put(property, List.copyOf(list));
            return this;
        }

        public Builder requiresCorrectToolForDrops() {
            this.requiresCorrectToolForDrops = true;
            return this;
        }

        public Builder setBlockEntity(BlockEntityType blockEntityType) {
            this.blockEntityType = blockEntityType;
            return this;
        }

        public Builder destroyTime(float destroyTime) {
            this.destroyTime = destroyTime;
            return this;
        }

        public Builder pushReaction(PistonBehavior pushReaction) {
            this.pushReaction = pushReaction;
            return this;
        }

        public Builder pickItem(Supplier<Item> pickItem) {
            this.pickItem = pickItem;
            return this;
        }

        private List<BlockState> build(Block block) {
            if (this.states.isEmpty()) {
                BlockState state = new BlockState(block, ((List)BlockRegistries.BLOCK_STATES.get()).size());
                ((List)BlockRegistries.BLOCK_STATES.get()).add(state);
                this.propertyKeys = null;
                return List.of(state);
            }
            if (this.states.size() == 1) {
                Map.Entry property = (Map.Entry)this.states.entrySet().stream().findFirst().orElseThrow();
                ArrayList<BlockState> states = new ArrayList<BlockState>(((List)property.getValue()).size());
                ((List)property.getValue()).forEach(value -> {
                    BlockState state = new BlockState(block, ((List)BlockRegistries.BLOCK_STATES.get()).size(), new Comparable[]{value});
                    ((List)BlockRegistries.BLOCK_STATES.get()).add(state);
                    states.add(state);
                });
                this.propertyKeys = new Property[]{(Property)property.getKey()};
                return states;
            }
            Stream<List<List<Object>>> stream = Stream.of(Collections.emptyList());
            for (List<Comparable<?>> values : this.states.values()) {
                stream = stream.flatMap(aPreviousPropertiesList -> values.stream().map(value -> {
                    ArrayList<Comparable> newProperties = new ArrayList<Comparable>((Collection<Comparable>)aPreviousPropertiesList);
                    newProperties.add((Comparable)value);
                    return newProperties;
                }));
            }
            ArrayList states = new ArrayList();
            List<List<List>> result = stream.toList();
            Property[] keys = this.states.keySet().toArray(new Property[0]);
            result.forEach(properties -> {
                Comparable[] values = properties.toArray(new Comparable[0]);
                BlockState state = new BlockState(block, ((List)BlockRegistries.BLOCK_STATES.get()).size(), values);
                ((List)BlockRegistries.BLOCK_STATES.get()).add(state);
                states.add(state);
            });
            this.propertyKeys = keys;
            return states;
        }

        private Builder() {
        }
    }
}

