/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.ArmadilloState;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ObjectEntityMetadata;

public class ArmadilloEntity
extends AnimalEntity {
    private ArmadilloState armadilloState = ArmadilloState.IDLE;

    public ArmadilloEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setArmadilloState(ObjectEntityMetadata<ArmadilloState> entityMetadata) {
        this.armadilloState = entityMetadata.getValue();
        switch (this.armadilloState) {
            case IDLE: {
                this.propertyManager.add("minecraft:armadillo_state", "unrolled");
                break;
            }
            case ROLLING: {
                this.propertyManager.add("minecraft:armadillo_state", "rolled_up");
                break;
            }
            case SCARED: {
                this.propertyManager.add("minecraft:armadillo_state", "rolled_up_relaxing");
                break;
            }
            case UNROLLING: {
                this.propertyManager.add("minecraft:armadillo_state", "rolled_up_unrolling");
            }
        }
        this.updateBedrockEntityProperties();
    }

    public void onPeeking() {
        if (this.armadilloState == ArmadilloState.SCARED) {
            this.propertyManager.add("minecraft:armadillo_state", "rolled_up_peeking");
            this.updateBedrockEntityProperties();
            this.session.scheduleInEventLoop(() -> {
                if (this.armadilloState == ArmadilloState.SCARED) {
                    this.propertyManager.add("minecraft:armadillo_state", "rolled_up_relaxing");
                    this.updateBedrockEntityProperties();
                }
            }, 250L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected @Nullable ItemTag getFoodTag() {
        return ItemTag.ARMADILLO_FOOD;
    }
}

