/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BlockEntityDataPacket;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

public class BlockEntityUtils {
    public static final Map<BlockEntityType, String> BLOCK_ENTITY_TRANSLATIONS = Map.of(BlockEntityType.ENCHANTING_TABLE, "EnchantTable", BlockEntityType.JIGSAW, "JigsawBlock", BlockEntityType.PISTON, "PistonArm", BlockEntityType.TRAPPED_CHEST, "Chest");

    public static String getBedrockBlockEntityId(BlockEntityType type) {
        String value = BLOCK_ENTITY_TRANSLATIONS.get(type);
        if (value != null) {
            return value;
        }
        String id = type.name();
        CharSequence[] words = id.split("_");
        for (int i = 0; i < words.length; ++i) {
            words[i] = ((String)words[i]).substring(0, 1).toUpperCase(Locale.ROOT) + ((String)words[i]).substring(1).toLowerCase(Locale.ROOT);
        }
        return String.join((CharSequence)"", words);
    }

    public static BlockEntityTranslator getBlockEntityTranslator(BlockEntityType type) {
        return (BlockEntityTranslator)Registries.BLOCK_ENTITIES.get(type);
    }

    public static void updateBlockEntity(GeyserSession session, @NonNull NbtMap blockEntity, Vector3i position) {
        BlockEntityDataPacket blockEntityPacket = new BlockEntityDataPacket();
        blockEntityPacket.setBlockPosition(position);
        blockEntityPacket.setData(blockEntity);
        session.sendUpstreamPacket((BedrockPacket)blockEntityPacket);
    }
}

