/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.mappings.versions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.block.custom.CustomBlockData;
import org.geysermc.geyser.api.block.custom.CustomBlockPermutation;
import org.geysermc.geyser.api.block.custom.CustomBlockState;
import org.geysermc.geyser.api.block.custom.component.BoxComponent;
import org.geysermc.geyser.api.block.custom.component.GeometryComponent;
import org.geysermc.geyser.api.block.custom.component.MaterialInstance;
import org.geysermc.geyser.api.block.custom.component.PlacementConditions;
import org.geysermc.geyser.api.block.custom.component.TransformationComponent;
import org.geysermc.geyser.api.item.custom.CustomItemData;
import org.geysermc.geyser.api.item.custom.CustomItemOptions;
import org.geysermc.geyser.api.util.CreativeCategory;
import org.geysermc.geyser.item.exception.InvalidCustomMappingsFileException;
import org.geysermc.geyser.level.block.GeyserCustomBlockComponents;
import org.geysermc.geyser.level.block.GeyserCustomBlockData;
import org.geysermc.geyser.level.block.GeyserGeometryComponent;
import org.geysermc.geyser.level.block.GeyserMaterialInstance;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.mappings.util.CustomBlockComponentsMapping;
import org.geysermc.geyser.registry.mappings.util.CustomBlockMapping;
import org.geysermc.geyser.registry.mappings.util.CustomBlockStateBuilderMapping;
import org.geysermc.geyser.registry.mappings.util.CustomBlockStateMapping;
import org.geysermc.geyser.registry.mappings.versions.MappingsReader;
import org.geysermc.geyser.translator.collision.BlockCollision;
import org.geysermc.geyser.util.BlockUtils;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.geyser.util.MinecraftKey;

public class MappingsReader_v1
extends MappingsReader {
    @Override
    public void readItemMappings(Path file, JsonObject mappingsRoot, BiConsumer<String, CustomItemData> consumer) {
        this.readItemMappingsV1(file, mappingsRoot, consumer);
    }

    @Override
    public void readBlockMappings(Path file, JsonObject mappingsRoot, BiConsumer<String, CustomBlockMapping> consumer) {
        this.readBlockMappingsV1(file, mappingsRoot, consumer);
    }

    public void readItemMappingsV1(Path file, JsonObject mappingsRoot, BiConsumer<String, CustomItemData> consumer) {
        JsonObject itemsNode = mappingsRoot.getAsJsonObject("items");
        if (itemsNode != null) {
            itemsNode.entrySet().forEach(entry -> {
                Object patt5077$temp = entry.getValue();
                if (patt5077$temp instanceof JsonArray) {
                    JsonArray array = (JsonArray)patt5077$temp;
                    array.forEach(data -> {
                        try {
                            CustomItemData customItemData = this.readItemMappingEntry((JsonObject)data);
                            consumer.accept((String)entry.getKey(), customItemData);
                        }
                        catch (InvalidCustomMappingsFileException e) {
                            GeyserImpl.getInstance().getLogger().error("Error in registering items for custom mapping file: " + file.toString(), e);
                        }
                    });
                }
            });
        }
    }

    public void readBlockMappingsV1(Path file, JsonObject mappingsRoot, BiConsumer<String, CustomBlockMapping> consumer) {
        JsonElement jsonElement = mappingsRoot.get("blocks");
        if (jsonElement instanceof JsonObject) {
            JsonObject blocksNode = (JsonObject)jsonElement;
            blocksNode.entrySet().forEach(entry -> {
                Object patt6277$temp = entry.getValue();
                if (patt6277$temp instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)patt6277$temp;
                    try {
                        String identifier = MinecraftKey.key((String)entry.getKey()).asString();
                        CustomBlockMapping customBlockMapping = this.readBlockMappingEntry(identifier, jsonObject);
                        consumer.accept(identifier, customBlockMapping);
                    }
                    catch (Exception e) {
                        GeyserImpl.getInstance().getLogger().error("Error in registering blocks for custom mapping file: " + file.toString());
                        GeyserImpl.getInstance().getLogger().error("due to entry: " + String.valueOf(entry), e);
                    }
                }
            });
        }
    }

    private CustomItemOptions readItemCustomItemOptions(JsonObject node) {
        JsonElement defaultItem;
        JsonElement unbreakable;
        JsonElement damagePredicate;
        CustomItemOptions.Builder customItemOptions = CustomItemOptions.builder();
        JsonElement customModelData = node.get("custom_model_data");
        if (customModelData != null && customModelData.isJsonPrimitive()) {
            customItemOptions.customModelData(customModelData.getAsInt());
        }
        if ((damagePredicate = node.get("damage_predicate")) != null && damagePredicate.isJsonPrimitive()) {
            customItemOptions.damagePredicate(damagePredicate.getAsInt());
        }
        if ((unbreakable = node.get("unbreakable")) != null && unbreakable.isJsonPrimitive()) {
            customItemOptions.unbreakable(unbreakable.getAsBoolean());
        }
        if ((defaultItem = node.get("default")) != null && defaultItem.isJsonPrimitive()) {
            customItemOptions.defaultItem(defaultItem.getAsBoolean());
        }
        return customItemOptions.build();
    }

    @Override
    public CustomItemData readItemMappingEntry(JsonObject node) throws InvalidCustomMappingsFileException {
        JsonElement jsonElement;
        if (node == null) {
            throw new InvalidCustomMappingsFileException("Invalid item mappings entry");
        }
        JsonElement name = node.get("name");
        if (name == null || !name.isJsonPrimitive() || name.getAsString().isEmpty()) {
            throw new InvalidCustomMappingsFileException("An item entry has no name");
        }
        CustomItemData.Builder customItemData = CustomItemData.builder().name(name.getAsString()).customItemOptions(this.readItemCustomItemOptions(node));
        if (node.has("display_name")) {
            customItemData.displayName(node.get("display_name").getAsString());
        }
        if (node.has("icon")) {
            customItemData.icon(node.get("icon").getAsString());
        }
        if (node.has("creative_category")) {
            customItemData.creativeCategory(node.get("creative_category").getAsInt());
        }
        if (node.has("creative_group")) {
            customItemData.creativeGroup(node.get("creative_group").getAsString());
        }
        if (node.has("allow_offhand")) {
            customItemData.allowOffhand(node.get("allow_offhand").getAsBoolean());
        }
        if (node.has("display_handheld")) {
            customItemData.displayHandheld(node.get("display_handheld").getAsBoolean());
        }
        if (node.has("texture_size")) {
            customItemData.textureSize(node.get("texture_size").getAsInt());
        }
        if (node.has("render_offsets")) {
            JsonObject tmpNode = node.getAsJsonObject("render_offsets");
            customItemData.renderOffsets(this.fromJsonObject(tmpNode));
        }
        if ((jsonElement = node.get("tags")) instanceof JsonArray) {
            JsonArray tags = (JsonArray)jsonElement;
            ObjectOpenHashSet tagsSet = new ObjectOpenHashSet();
            tags.forEach(arg_0 -> MappingsReader_v1.lambda$readItemMappingEntry$3((Set)tagsSet, arg_0));
            customItemData.tags((Set<String>)tagsSet);
        }
        return customItemData.build();
    }

    @Override
    public CustomBlockMapping readBlockMappingEntry(String identifier, JsonObject node) throws InvalidCustomMappingsFileException {
        if (node == null) {
            throw new InvalidCustomMappingsFileException("Invalid block mappings entry:" + String.valueOf(node));
        }
        String name = node.get("name").getAsString();
        if (name == null || name.isEmpty()) {
            throw new InvalidCustomMappingsFileException("A block entry has no name");
        }
        boolean includedInCreativeInventory = node.has("included_in_creative_inventory") && node.get("included_in_creative_inventory").getAsBoolean();
        CreativeCategory creativeCategory = CreativeCategory.NONE;
        if (node.has("creative_category")) {
            String categoryName = node.get("creative_category").getAsString();
            try {
                creativeCategory = CreativeCategory.valueOf(categoryName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new InvalidCustomMappingsFileException("Invalid creative category \"" + categoryName + "\" for block \"" + name + "\"");
            }
        }
        String creativeGroup = "";
        if (node.has("creative_group")) {
            creativeGroup = node.get("creative_group").getAsString();
        }
        boolean onlyOverrideStates = node.has("only_override_states") && node.get("only_override_states").getAsBoolean();
        GeyserCustomBlockData.Builder customBlockDataBuilder = new GeyserCustomBlockData.Builder().name(name).includedInCreativeInventory(includedInCreativeInventory).creativeCategory(creativeCategory).creativeGroup(creativeGroup);
        if (((Object2IntMap)BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.get()).containsKey((Object)identifier)) {
            CustomBlockComponentsMapping componentsMapping = this.createCustomBlockComponentsMapping((JsonElement)node, identifier, name);
            CustomBlockData blockData = customBlockDataBuilder.components(componentsMapping.components()).build();
            return new CustomBlockMapping(blockData, Map.of(identifier, new CustomBlockStateMapping(blockData.defaultBlockState(), componentsMapping.extendedCollisionBox())), identifier, !onlyOverrideStates);
        }
        LinkedHashMap<String, CustomBlockComponentsMapping> componentsMap = new LinkedHashMap<String, CustomBlockComponentsMapping>();
        JsonElement jsonElement = node.get("state_overrides");
        if (jsonElement instanceof JsonObject) {
            JsonObject stateOverrides = (JsonObject)jsonElement;
            for (Map.Entry overrideEntry : stateOverrides.entrySet()) {
                String state2 = identifier + "[" + (String)overrideEntry.getKey() + "]";
                if (!((Object2IntMap)BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.get()).containsKey((Object)state2)) {
                    throw new InvalidCustomMappingsFileException("Unknown Java block state: " + state2 + " for state_overrides.");
                }
                componentsMap.put(state2, this.createCustomBlockComponentsMapping((JsonElement)overrideEntry.getValue(), state2, name));
            }
        }
        if (componentsMap.isEmpty() && onlyOverrideStates) {
            throw new InvalidCustomMappingsFileException("Block entry for " + identifier + " has only_override_states set to true, but has no state_overrides.");
        }
        if (!onlyOverrideStates) {
            ((Object2IntMap)BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.get()).keySet().stream().filter(s -> s.startsWith(identifier + "[")).filter(Predicate.not(componentsMap::containsKey)).forEach(state -> componentsMap.put((String)state, this.createCustomBlockComponentsMapping(null, (String)state, name)));
        }
        if (componentsMap.isEmpty()) {
            throw new InvalidCustomMappingsFileException("Unknown Java block: " + identifier);
        }
        String firstState = (String)componentsMap.keySet().iterator().next();
        CustomBlockComponentsMapping firstComponentsMapping = this.createCustomBlockComponentsMapping((JsonElement)node, firstState, name);
        customBlockDataBuilder.components(firstComponentsMapping.components());
        return this.createCustomBlockMapping(customBlockDataBuilder, componentsMap, identifier, !onlyOverrideStates);
    }

    private CustomBlockMapping createCustomBlockMapping(CustomBlockData.Builder customBlockDataBuilder, Map<String, CustomBlockComponentsMapping> componentsMap, String identifier, boolean overrideItem) {
        Object2ObjectOpenHashMap valuesMap = new Object2ObjectOpenHashMap();
        ArrayList<CustomBlockPermutation> permutations = new ArrayList<CustomBlockPermutation>();
        Object2ObjectOpenHashMap blockStateBuilders = new Object2ObjectOpenHashMap();
        for (Map.Entry<String, CustomBlockComponentsMapping> entry : componentsMap.entrySet()) {
            String state = entry.getKey();
            String[] pairs = this.splitStateString(state);
            CharSequence[] conditions = new String[pairs.length];
            Function blockStateBuilder = Function.identity();
            for (int i = 0; i < pairs.length; ++i) {
                String[] parts = pairs[i].split("=");
                String property = parts[0];
                String value2 = parts[1];
                valuesMap.computeIfAbsent(property, k -> new LinkedHashSet()).add(value2);
                conditions[i] = String.format("q.block_property('%s') == '%s'", property, value2);
                blockStateBuilder = blockStateBuilder.andThen(builder -> builder.stringProperty(property, value2));
            }
            permutations.add(new CustomBlockPermutation(entry.getValue().components(), String.join((CharSequence)" && ", conditions)));
            blockStateBuilders.put(state, new CustomBlockStateBuilderMapping(blockStateBuilder.andThen(CustomBlockState.Builder::build), entry.getValue().extendedCollisionBox()));
        }
        valuesMap.forEach((key, value) -> customBlockDataBuilder.stringProperty((String)key, (List<String>)new ArrayList<String>((Collection<String>)value)));
        CustomBlockData customBlockData = customBlockDataBuilder.permutations(permutations).build();
        Map<String, CustomBlockStateMapping> states = blockStateBuilders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new CustomBlockStateMapping(((CustomBlockStateBuilderMapping)e.getValue()).builder().apply(customBlockData.blockStateBuilder()), ((CustomBlockStateBuilderMapping)e.getValue()).extendedCollisionBox())));
        return new CustomBlockMapping(customBlockData, states, identifier, overrideItem);
    }

    private CustomBlockComponentsMapping createCustomBlockComponentsMapping(JsonElement element, String stateKey, String name) {
        JsonElement conditions;
        JsonObject placementFilter;
        JsonElement rotationY2;
        JsonElement rotationX22;
        JsonElement rotationX22;
        BoxComponent extendedCollisionBox;
        BoxComponent collisionBox;
        int id = BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.getOrDefault(stateKey, -1);
        BoxComponent boxComponent = this.createBoxComponent(id);
        BoxComponent extendedBoxComponent = this.createExtendedBoxComponent(id);
        GeyserCustomBlockComponents.Builder builder = new GeyserCustomBlockComponents.Builder().collisionBox(boxComponent).selectionBox(boxComponent);
        if (!(element instanceof JsonObject)) {
            return new CustomBlockComponentsMapping(builder.build(), extendedBoxComponent);
        }
        JsonObject node = (JsonObject)element;
        BoxComponent selectionBox = this.createBoxComponent(node.get("selection_box"));
        if (selectionBox != null) {
            builder.selectionBox(selectionBox);
        }
        if ((collisionBox = this.createBoxComponent(node.get("collision_box"))) != null) {
            builder.collisionBox(collisionBox);
        }
        if ((extendedCollisionBox = this.createBoxComponent(node.get("extended_collision_box"))) != null) {
            extendedBoxComponent = extendedCollisionBox;
        }
        float destructibleByMining = Float.MAX_VALUE;
        if (node.has("destructible_by_mining")) {
            destructibleByMining = node.get("destructible_by_mining").getAsFloat();
        }
        builder.destructibleByMining(Float.valueOf(destructibleByMining));
        if (node.has("geometry")) {
            if (node.get("geometry").isJsonPrimitive()) {
                builder.geometry(new GeyserGeometryComponent.Builder().identifier(node.get("geometry").getAsString()).build());
            } else {
                JsonElement jsonElement;
                JsonObject geometry = node.getAsJsonObject("geometry");
                GeyserGeometryComponent.Builder geometryBuilder = new GeyserGeometryComponent.Builder();
                if (geometry.has("identifier")) {
                    geometryBuilder.identifier(geometry.get("identifier").getAsString());
                }
                if (geometry.has("bone_visibility") && (jsonElement = geometry.get("bone_visibility")) instanceof JsonObject) {
                    JsonObject boneVisibility = (JsonObject)jsonElement;
                    Object2ObjectOpenHashMap boneVisibilityMap = new Object2ObjectOpenHashMap();
                    boneVisibility.entrySet().forEach(arg_0 -> MappingsReader_v1.lambda$createCustomBlockComponentsMapping$10((Map)boneVisibilityMap, arg_0));
                    geometryBuilder.boneVisibility((Map<String, String>)boneVisibilityMap);
                }
                builder.geometry(geometryBuilder.build());
            }
        }
        String displayName = name;
        if (node.has("display_name")) {
            displayName = node.get("display_name").getAsString();
        }
        builder.displayName(displayName);
        if (node.has("friction")) {
            builder.friction(Float.valueOf(node.get("friction").getAsFloat()));
        }
        if (node.has("light_emission")) {
            builder.lightEmission(node.get("light_emission").getAsInt());
        }
        if (node.has("light_dampening")) {
            builder.lightDampening(node.get("light_dampening").getAsInt());
        }
        boolean placeAir = true;
        if (node.has("place_air")) {
            placeAir = node.get("place_air").getAsBoolean();
        }
        builder.placeAir(placeAir);
        if (node.has("transformation")) {
            JsonObject transformation = node.getAsJsonObject("transformation");
            int rotationX22 = 0;
            int rotationY2 = 0;
            int rotationZ = 0;
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            float scaleZ = 1.0f;
            float transformX = 0.0f;
            float transformY = 0.0f;
            float transformZ = 0.0f;
            if (transformation.has("rotation")) {
                JsonArray rotation = transformation.getAsJsonArray("rotation");
                rotationX22 = rotation.get(0).getAsInt();
                rotationY2 = rotation.get(1).getAsInt();
                rotationZ = rotation.get(2).getAsInt();
            }
            if (transformation.has("scale")) {
                JsonArray scale = transformation.getAsJsonArray("scale");
                scaleX = scale.get(0).getAsFloat();
                scaleY = scale.get(1).getAsFloat();
                scaleZ = scale.get(2).getAsFloat();
            }
            if (transformation.has("translation")) {
                JsonArray translation = transformation.getAsJsonArray("translation");
                transformX = translation.get(0).getAsFloat();
                transformY = translation.get(1).getAsFloat();
                transformZ = translation.get(2).getAsFloat();
            }
            builder.transformation(new TransformationComponent(rotationX22, rotationY2, rotationZ, scaleX, scaleY, scaleZ, transformX, transformY, transformZ));
        }
        if (node.has("unit_cube")) {
            builder.geometry(GeometryComponent.builder().identifier("minecraft:geometry.full_block").build());
        }
        if (node.has("material_instances") && (rotationX22 = node.get("material_instances")) instanceof JsonObject) {
            JsonObject materialInstances = (JsonObject)rotationX22;
            materialInstances.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                Object patt24348$temp = entry.getValue();
                if (patt24348$temp instanceof JsonObject) {
                    JsonObject value = (JsonObject)patt24348$temp;
                    MaterialInstance materialInstance = this.createMaterialInstanceComponent(value);
                    builder.materialInstance(key, materialInstance);
                }
            });
        }
        if ((rotationX22 = node.get("placement_filter")) instanceof JsonObject && (rotationY2 = (placementFilter = (JsonObject)rotationX22).get("conditions")) instanceof JsonArray) {
            conditions = (JsonArray)rotationY2;
            List<PlacementConditions> filter = this.createPlacementFilterComponent((JsonArray)conditions);
            builder.placementFilter(filter);
        }
        if ((conditions = node.get("tags")) instanceof JsonArray) {
            JsonArray tags = (JsonArray)conditions;
            ObjectOpenHashSet tagsSet = new ObjectOpenHashSet();
            tags.forEach(arg_0 -> MappingsReader_v1.lambda$createCustomBlockComponentsMapping$12((Set)tagsSet, arg_0));
            builder.tags((Set<String>)tagsSet);
        }
        return new CustomBlockComponentsMapping(builder.build(), extendedBoxComponent);
    }

    private BoxComponent createBoxComponent(int javaId, float heightTranslation) {
        BlockCollision blockCollision = BlockUtils.getCollision(javaId);
        if (blockCollision == null || blockCollision.getBoundingBoxes().length == 0) {
            return BoxComponent.emptyBox();
        }
        float minX = 5.0f;
        float minY = 5.0f;
        float minZ = 5.0f;
        float maxX = -5.0f;
        float maxY = -5.0f;
        float maxZ = -5.0f;
        for (BoundingBox boundingBox : blockCollision.getBoundingBoxes()) {
            double offsetX = boundingBox.getSizeX() * 0.5;
            double offsetY = boundingBox.getSizeY() * 0.5;
            double offsetZ = boundingBox.getSizeZ() * 0.5;
            minX = Math.min(minX, (float)(boundingBox.getMiddleX() - offsetX));
            minY = Math.min(minY, (float)(boundingBox.getMiddleY() - offsetY));
            minZ = Math.min(minZ, (float)(boundingBox.getMiddleZ() - offsetZ));
            maxX = Math.max(maxX, (float)(boundingBox.getMiddleX() + offsetX));
            maxY = Math.max(maxY, (float)(boundingBox.getMiddleY() + offsetY));
            maxZ = Math.max(maxZ, (float)(boundingBox.getMiddleZ() + offsetZ));
        }
        minX = MathUtils.clamp(minX, 0.0f, 1.0f);
        minY = MathUtils.clamp(minY + heightTranslation, 0.0f, 1.0f);
        minZ = MathUtils.clamp(minZ, 0.0f, 1.0f);
        maxX = MathUtils.clamp(maxX, 0.0f, 1.0f);
        maxY = MathUtils.clamp(maxY + heightTranslation, 0.0f, 1.0f);
        maxZ = MathUtils.clamp(maxZ, 0.0f, 1.0f);
        return new BoxComponent(16.0f * (1.0f - maxX) - 8.0f, 16.0f * minY, 16.0f * minZ - 8.0f, 16.0f * (maxX - minX), 16.0f * (maxY - minY), 16.0f * (maxZ - minZ));
    }

    private BoxComponent createBoxComponent(int javaId) {
        return this.createBoxComponent(javaId, 0.0f);
    }

    private @Nullable BoxComponent createExtendedBoxComponent(int javaId) {
        BlockCollision blockCollision = BlockUtils.getCollision(javaId);
        if (blockCollision == null) {
            return null;
        }
        for (BoundingBox box : blockCollision.getBoundingBoxes()) {
            double maxY = 0.5 * box.getSizeY() + box.getMiddleY();
            if (!(maxY > 1.0)) continue;
            return this.createBoxComponent(javaId, -1.0f);
        }
        return null;
    }

    private @Nullable BoxComponent createBoxComponent(JsonElement element) {
        JsonObject node;
        if (element instanceof JsonObject && (node = (JsonObject)element).has("origin") && node.has("size")) {
            JsonArray origin = node.getAsJsonArray("origin");
            float originX = origin.get(0).getAsFloat();
            float originY = origin.get(1).getAsFloat();
            float originZ = origin.get(2).getAsFloat();
            JsonArray size = node.getAsJsonArray("size");
            float sizeX = size.get(0).getAsFloat();
            float sizeY = size.get(1).getAsFloat();
            float sizeZ = size.get(2).getAsFloat();
            return new BoxComponent(originX, originY, originZ, sizeX, sizeY, sizeZ);
        }
        return null;
    }

    private MaterialInstance createMaterialInstanceComponent(JsonObject node) {
        String texture = null;
        if (node.has("texture")) {
            texture = node.get("texture").getAsString();
        }
        String renderMethod = "opaque";
        if (node.has("render_method")) {
            renderMethod = node.get("render_method").getAsString();
        }
        boolean faceDimming = true;
        if (node.has("face_dimming")) {
            faceDimming = node.get("face_dimming").getAsBoolean();
        }
        boolean ambientOcclusion = true;
        if (node.has("ambient_occlusion")) {
            ambientOcclusion = node.get("ambient_occlusion").getAsBoolean();
        }
        return new GeyserMaterialInstance.Builder().texture(texture).renderMethod(renderMethod).faceDimming(faceDimming).ambientOcclusion(ambientOcclusion).build();
    }

    private List<PlacementConditions> createPlacementFilterComponent(JsonArray node) {
        ArrayList<PlacementConditions> conditions = new ArrayList<PlacementConditions>();
        node.forEach(json -> {
            JsonElement patt32467$temp;
            JsonElement patt32100$temp;
            if (!(json instanceof JsonObject)) {
                return;
            }
            JsonObject condition = (JsonObject)json;
            EnumSet<PlacementConditions.Face> faces = EnumSet.noneOf(PlacementConditions.Face.class);
            if (condition.has("allowed_faces") && (patt32100$temp = condition.get("allowed_faces")) instanceof JsonArray) {
                JsonArray allowedFaces = (JsonArray)patt32100$temp;
                allowedFaces.forEach(face -> faces.add(PlacementConditions.Face.valueOf(face.getAsString().toUpperCase())));
            }
            LinkedHashMap<String, PlacementConditions.BlockFilterType> blockFilters = new LinkedHashMap<String, PlacementConditions.BlockFilterType>();
            if (condition.has("block_filter") && (patt32467$temp = condition.get("block_filter")) instanceof JsonArray) {
                JsonArray blockFilter = (JsonArray)patt32467$temp;
                blockFilter.forEach(filter -> {
                    JsonPrimitive primitive;
                    if (filter instanceof JsonObject) {
                        JsonObject jsonObject = (JsonObject)filter;
                        if (jsonObject.has("tags")) {
                            JsonElement tags = jsonObject.get("tags");
                            blockFilters.put(tags.getAsString(), PlacementConditions.BlockFilterType.TAG);
                        }
                    } else if (filter instanceof JsonPrimitive && (primitive = (JsonPrimitive)filter).isString()) {
                        blockFilters.put(filter.getAsString(), PlacementConditions.BlockFilterType.BLOCK);
                    }
                });
            }
            conditions.add(new PlacementConditions(faces, blockFilters));
        });
        return conditions;
    }

    private String[] splitStateString(String state) {
        int openBracketIndex = state.indexOf("[");
        String states = state.substring(openBracketIndex + 1, state.length() - 1);
        return states.split(",");
    }

    private static /* synthetic */ void lambda$createCustomBlockComponentsMapping$12(Set tagsSet, JsonElement tag) {
        tagsSet.add(tag.getAsString());
    }

    private static /* synthetic */ void lambda$createCustomBlockComponentsMapping$10(Map boneVisibilityMap, Map.Entry entry) {
        JsonPrimitive primitive;
        String key = (String)entry.getKey();
        Object patt21140$temp = entry.getValue();
        String value = patt21140$temp instanceof JsonPrimitive && (primitive = (JsonPrimitive)patt21140$temp).isBoolean() ? (((JsonElement)entry.getValue()).getAsBoolean() ? "1" : "0") : ((JsonElement)entry.getValue()).getAsString();
        boneVisibilityMap.put(key, value);
    }

    private static /* synthetic */ void lambda$readItemMappingEntry$3(Set tagsSet, JsonElement tag) {
        tagsSet.add(tag.getAsString());
    }
}

