/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import java.util.Map;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.jetbrains.annotations.Range;

public class PlayerInventory
extends Inventory {
    private int heldItemSlot = 0;
    private @NonNull GeyserItemStack cursor = GeyserItemStack.EMPTY;

    public PlayerInventory(GeyserSession session) {
        super(session, 0, 46, null);
    }

    @Override
    public int getOffsetForHotbar(@Range(from=0L, to=8L) int slot) {
        return slot + 36;
    }

    public void setCursor(@NonNull GeyserItemStack newCursor, GeyserSession session) {
        PlayerInventory.updateItemNetId(this.cursor, newCursor, session);
        this.cursor = newCursor;
    }

    public boolean isHolding(@NonNull Item item) {
        return this.getItemInHand().is(item) || this.getOffhand().is(item);
    }

    public GeyserItemStack getItemInHand(@NonNull Hand hand) {
        return hand == Hand.OFF_HAND ? this.getOffhand() : this.getItemInHand();
    }

    public GeyserItemStack getItemInHand() {
        if (36 + this.heldItemSlot > this.size) {
            GeyserImpl.getInstance().getLogger().debug("Held item slot was larger than expected!");
            return GeyserItemStack.EMPTY;
        }
        return this.items[36 + this.heldItemSlot];
    }

    public Map<EquipmentSlot, GeyserItemStack> getEquipment() {
        return Map.of(EquipmentSlot.MAIN_HAND, this.getItemInHand(), EquipmentSlot.OFF_HAND, this.items[45], EquipmentSlot.BOOTS, this.items[8], EquipmentSlot.LEGGINGS, this.items[7], EquipmentSlot.CHESTPLATE, this.items[6], EquipmentSlot.HELMET, this.items[5]);
    }

    public void setItemInHand(@NonNull GeyserItemStack item) {
        if (36 + this.heldItemSlot > this.size) {
            GeyserImpl.getInstance().getLogger().debug("Held item slot was larger than expected!");
            return;
        }
        this.items[36 + this.heldItemSlot] = item;
    }

    @Override
    public boolean shouldConfirmContainerClose() {
        return false;
    }

    public GeyserItemStack getOffhand() {
        return this.items[45];
    }

    @Generated
    public int getHeldItemSlot() {
        return this.heldItemSlot;
    }

    @Generated
    public @NonNull GeyserItemStack getCursor() {
        return this.cursor;
    }

    @Generated
    public void setHeldItemSlot(int heldItemSlot) {
        this.heldItemSlot = heldItemSlot;
    }
}

