/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import java.util.Arrays;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.LodestoneTracker;
import org.jetbrains.annotations.Range;

public abstract class Inventory {
    protected final int javaId;
    private int bedrockId;
    private int stateId;
    private int nextStateId = -1;
    protected final int size;
    protected final ContainerType containerType;
    protected final String title;
    protected final GeyserItemStack[] items;
    protected Vector3i holderPosition = Vector3i.ZERO;
    protected long holderId = -1L;
    private boolean displayed;

    protected Inventory(GeyserSession session, int id, int size, ContainerType containerType) {
        this(session, "Inventory", id, size, containerType);
    }

    protected Inventory(GeyserSession session, String title, int javaId, int size, ContainerType containerType) {
        this.title = title;
        this.javaId = javaId;
        this.size = size;
        this.containerType = containerType;
        this.items = new GeyserItemStack[size];
        Arrays.fill(this.items, GeyserItemStack.EMPTY);
        int n = this.bedrockId = javaId <= 100 ? javaId : javaId % 100 + 1;
        if (session.getInventoryHolder() != null && session.getInventoryHolder().bedrockId() == this.bedrockId || session.isClosingInventory()) {
            ++this.bedrockId;
        }
    }

    public GeyserItemStack getItem(int slot) {
        if (slot > this.size) {
            GeyserImpl.getInstance().getLogger().debug("Tried to get an item out of bounds! " + String.valueOf(this));
            return GeyserItemStack.EMPTY;
        }
        return this.items[slot];
    }

    public abstract int getOffsetForHotbar(@Range(from=0L, to=8L) int var1);

    public void setItem(int slot, @NonNull GeyserItemStack newItem, GeyserSession session) {
        LodestoneTracker tracker;
        if (slot < 0 || slot >= this.size) {
            session.getGeyser().getLogger().debug("Tried to set an item out of bounds (slot was " + slot + ")! " + String.valueOf(this));
            return;
        }
        GeyserItemStack oldItem = this.items[slot];
        Inventory.updateItemNetId(oldItem, newItem, session);
        this.items[slot] = newItem;
        if (newItem.is(Items.COMPASS) && (tracker = (LodestoneTracker)newItem.getComponent(DataComponentTypes.LODESTONE_TRACKER)) != null) {
            session.getLodestoneCache().cacheInventoryItem(newItem, tracker);
        }
    }

    public static void updateItemNetId(GeyserItemStack oldItem, GeyserItemStack newItem, GeyserSession session) {
        if (!newItem.isEmpty()) {
            ItemDefinition newMapping;
            ItemDefinition oldMapping = ItemTranslator.getBedrockItemDefinition(session, oldItem);
            if (oldMapping.equals(newMapping = ItemTranslator.getBedrockItemDefinition(session, newItem))) {
                newItem.setNetId(oldItem.getNetId());
                newItem.mergeBundleData(session, oldItem.getBundleData());
            } else {
                newItem.setNetId(session.getNextItemNetId());
                session.getBundleCache().markNewBundle(newItem.getBundleData());
                session.getBundleCache().onOldItemDelete(oldItem);
            }
        } else {
            session.getBundleCache().onOldItemDelete(oldItem);
        }
    }

    public void incrementStateId(int count) {
        this.nextStateId = (this.nextStateId == -1 ? this.stateId : this.nextStateId) + count & Short.MAX_VALUE;
    }

    public void resetNextStateId() {
        this.nextStateId = -1;
    }

    public boolean shouldConfirmContainerClose() {
        return true;
    }

    @Generated
    public String toString() {
        return "Inventory(javaId=" + this.getJavaId() + ", bedrockId=" + this.getBedrockId() + ", stateId=" + this.getStateId() + ", nextStateId=" + this.getNextStateId() + ", size=" + this.getSize() + ", containerType=" + String.valueOf(this.getContainerType()) + ", title=" + this.getTitle() + ", items=" + Arrays.deepToString(this.items) + ", holderPosition=" + String.valueOf(this.getHolderPosition()) + ", holderId=" + this.getHolderId() + ", displayed=" + this.isDisplayed() + ")";
    }

    @Generated
    public int getJavaId() {
        return this.javaId;
    }

    @Generated
    public void setBedrockId(int bedrockId) {
        this.bedrockId = bedrockId;
    }

    @Generated
    public int getBedrockId() {
        return this.bedrockId;
    }

    @Generated
    public int getStateId() {
        return this.stateId;
    }

    @Generated
    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    @Generated
    public int getNextStateId() {
        return this.nextStateId;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public ContainerType getContainerType() {
        return this.containerType;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public Vector3i getHolderPosition() {
        return this.holderPosition;
    }

    @Generated
    public void setHolderPosition(Vector3i holderPosition) {
        this.holderPosition = holderPosition;
    }

    @Generated
    public long getHolderId() {
        return this.holderId;
    }

    @Generated
    public void setHolderId(long holderId) {
        this.holderId = holderId;
    }

    @Generated
    public boolean isDisplayed() {
        return this.displayed;
    }

    @Generated
    public void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }
}

