/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Pattern;
import org.geysermc.geyser.GeyserImpl;

public final class CpuUtils {
    public static String tryGetProcessorName() {
        try {
            String osName = System.getProperty("os.name", "unknown").toLowerCase();
            if (osName.contains("linux") && new File("/proc/cpuinfo").canRead()) {
                return CpuUtils.getLinuxProcessorName();
            }
            if (osName.contains("windows")) {
                return CpuUtils.getWindowsProcessorName();
            }
            if (osName.contains("mac")) {
                return CpuUtils.getMacProcessorName();
            }
            GeyserImpl.getInstance().getLogger().warning("Couldn't determine OS to get processor name! The OS name is " + osName);
            return "unknown";
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().warning("Couldn't get processor name! " + e.getMessage());
            return "unknown";
        }
    }

    private static String getLinuxProcessorName() throws Exception {
        List<String> lines = Files.readAllLines(Paths.get("/proc/cpuinfo", new String[0]), StandardCharsets.UTF_8);
        Pattern whitespaceColonWhitespace = Pattern.compile("\\s+:\\s");
        for (String line : lines) {
            String[] splitLine = whitespaceColonWhitespace.split(line);
            if (!"model name".equals(splitLine[0]) && !"Processor".equals(splitLine[0])) continue;
            return splitLine[1];
        }
        GeyserImpl.getInstance().getLogger().warning("Couldn't parse processor name!");
        return "unknown";
    }

    private static String getWindowsProcessorName() throws Exception {
        String cpuNameCmd = "reg query \"HKLM\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0\" /v ProcessorNameString";
        String regstrToken = "REG_SZ";
        Process process = Runtime.getRuntime().exec("reg query \"HKLM\\HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0\" /v ProcessorNameString");
        process.waitFor();
        InputStream is = process.getInputStream();
        StringBuilder sb = new StringBuilder();
        while (is.available() != 0) {
            sb.append((char)is.read());
        }
        String result = sb.toString();
        int p = result.indexOf("REG_SZ");
        if (p == -1) {
            GeyserImpl.getInstance().getLogger().warning("Couldn't parse processor name!");
            return "unknown";
        }
        return result.substring(p + "REG_SZ".length()).trim();
    }

    private static String getMacProcessorName() throws Exception {
        Process process = Runtime.getRuntime().exec(new String[]{"sysctl", "-n", "machdep.cpu.brand_string"});
        process.waitFor();
        InputStream is = process.getInputStream();
        StringBuilder sb = new StringBuilder();
        while (is.available() != 0) {
            sb.append((char)is.read());
        }
        String result = sb.toString().trim();
        if (!result.isEmpty()) {
            return result;
        }
        GeyserImpl.getInstance().getLogger().warning("Couldn't parse processor name!");
        return "unknown";
    }

    private CpuUtils() {
    }
}

