/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.stream.Collectors;
import org.geysermc.geyser.GeyserImpl;

public class AnnotationUtils {
    public static boolean hasAnnotationRecursive(Class<?> clazz, Class<? extends Annotation> annotation) {
        if (clazz.isAnnotationPresent(annotation)) {
            return true;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!AnnotationUtils.hasAnnotationRecursive(iface, annotation)) continue;
            return true;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return AnnotationUtils.hasAnnotationRecursive(superClass, annotation);
        }
        return false;
    }

    public static Set<Class<?>> getGeneratedClassesForAnnotation(Class<? extends Annotation> annotationClass) {
        return AnnotationUtils.getGeneratedClassesForAnnotation(annotationClass.getName());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Set<Class<?>> getGeneratedClassesForAnnotation(String input) {
        try (InputStream annotatedClass = GeyserImpl.getInstance().getBootstrap().getResourceOrThrow(input);){
            Set<Class<?>> set;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(annotatedClass));){
                set = reader.lines().map(className -> {
                    try {
                        return Class.forName(className);
                    }
                    catch (ClassNotFoundException ex) {
                        GeyserImpl.getInstance().getLogger().error("Failed to find class " + className, ex);
                        throw new RuntimeException(ex);
                    }
                }).collect(Collectors.toSet());
            }
            return set;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

