/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity.player;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.UUID;
import org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.PlayerListUtils;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.data.game.PlayerListEntry;
import org.geysermc.mcprotocollib.protocol.data.game.PlayerListEntryAction;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.ClientboundPlayerInfoUpdatePacket;

@Translator(packet=ClientboundPlayerInfoUpdatePacket.class)
public class JavaPlayerInfoUpdateTranslator
extends PacketTranslator<ClientboundPlayerInfoUpdatePacket> {
    @Override
    public void translate(GeyserSession session, ClientboundPlayerInfoUpdatePacket packet) {
        EnumSet actions = packet.getActions();
        if (actions.contains(PlayerListEntryAction.ADD_PLAYER)) {
            for (PlayerListEntry entry : packet.getEntries()) {
                PlayerEntity playerEntity;
                GameProfile profile = entry.getProfile();
                if (profile == null) {
                    GeyserImpl.getInstance().getLogger().debug("Received a null profile in a player info update packet!");
                    continue;
                }
                UUID id = entry.getProfileId();
                boolean self = id.equals(session.getPlayerEntity().uuid());
                if (self) {
                    playerEntity = session.getPlayerEntity();
                    playerEntity.setUsername(profile.getName());
                    playerEntity.setSkin(profile, () -> GeyserImpl.getInstance().getLogger().debug("Loaded Local Bedrock Java Skin Data for " + session.getClientData().getUsername()));
                    continue;
                }
                playerEntity = new PlayerEntity((EntitySpawnContext)EntitySpawnContext.DUMMY_CONTEXT.apply((Object)session, (Object)id, EntityDefinitions.PLAYER), profile);
                session.getEntityCache().addPlayerEntity(playerEntity);
            }
        }
        if (actions.contains(PlayerListEntryAction.UPDATE_LISTED)) {
            ArrayList<PlayerListPacket.Entry> toAdd = new ArrayList<PlayerListPacket.Entry>();
            ArrayList<PlayerListPacket.Entry> toRemove = new ArrayList<PlayerListPacket.Entry>();
            for (PlayerListEntry entry : packet.getEntries()) {
                PlayerEntity entity = session.getEntityCache().getPlayerEntity(entry.getProfileId());
                if (entity == null) {
                    session.getGeyser().getLogger().debug("Ignoring player info update for " + String.valueOf(entry.getProfileId()));
                    continue;
                }
                if (entry.isListed()) {
                    if (!PlayerListUtils.shouldLimitPlayerListEntries(session)) {
                        PlayerListPacket.Entry playerListEntry = SkinManager.buildEntryFromCachedSkin(session, entity);
                        toAdd.add(playerListEntry);
                        session.getWaypointCache().listPlayer(entity);
                    }
                } else if (entity.isListed()) {
                    toRemove.add(new PlayerListPacket.Entry(entity.getTabListUuid()));
                    session.getWaypointCache().unlistPlayer(entity);
                }
                entity.setListed(entry.isListed());
            }
            if (!toAdd.isEmpty()) {
                PlayerListUtils.batchSendPlayerList(session, toAdd, PlayerListPacket.Action.ADD);
            }
            if (!toRemove.isEmpty()) {
                PlayerListUtils.batchSendPlayerList(session, toRemove, PlayerListPacket.Action.REMOVE);
            }
        }
    }
}

