/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.entity;

import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.FallingBlockEntity;
import org.geysermc.geyser.entity.type.FishingHookEntity;
import org.geysermc.geyser.entity.type.HangingEntity;
import org.geysermc.geyser.entity.type.player.AvatarEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.EnvironmentUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.Direction;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.FallingBlockData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.ProjectileData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.object.WardenData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity.ClientboundAddEntityPacket;

@Translator(packet=ClientboundAddEntityPacket.class)
public class JavaAddEntityTranslator
extends PacketTranslator<ClientboundAddEntityPacket> {
    private static final boolean SHOW_PLAYER_LIST_LOGS = Boolean.parseBoolean(System.getProperty("Geyser.ShowPlayerListLogs", "true"));

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void translate(GeyserSession session, ClientboundAddEntityPacket packet) {
        void var10_16;
        WardenData wardenData;
        EntityDefinition definition = (EntityDefinition)Registries.ENTITY_DEFINITIONS.get(packet.getType());
        if (definition == null) {
            session.getGeyser().getLogger().debug("Could not find an entity definition with type " + String.valueOf(packet.getType()));
            return;
        }
        Vector3f position = Vector3f.from((double)packet.getX(), (double)packet.getY(), (double)packet.getZ());
        Vector3f motion = packet.getMovement().toFloat();
        float yaw = packet.getYaw();
        float pitch = packet.getPitch();
        float headYaw = packet.getHeadYaw();
        EntitySpawnContext context = EntitySpawnContext.fromPacket(session, definition, packet);
        if (packet.getType() == EntityType.PLAYER) {
            void var10_12;
            if (packet.getUuid().equals(session.getPlayerEntity().uuid())) {
                PlayerEntity playerEntity = new PlayerEntity(context, session.getPlayerEntity().getUsername(), session.getPlayerEntity().getTextures());
            } else {
                PlayerEntity playerEntity = session.getEntityCache().getPlayerEntity(packet.getUuid());
                if (playerEntity == null) {
                    if (!SHOW_PLAYER_LIST_LOGS) return;
                    GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.entity.player.failed_list", packet.getUuid()));
                    return;
                }
                playerEntity.setEntityId(packet.getEntityId());
                playerEntity.setPosition(position);
                playerEntity.setYaw(yaw);
                playerEntity.setPitch(pitch);
                playerEntity.setHeadYaw(headYaw);
                playerEntity.setMotion(motion);
            }
            var10_12.sendPlayer();
            if (EnvironmentUtils.IS_UNIT_TESTING) return;
            SkinManager.requestAndHandleSkinAndCape((AvatarEntity)var10_12, session, null);
            return;
        }
        if (packet.getType() == EntityType.FALLING_BLOCK) {
            FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(context, ((FallingBlockData)packet.getData()).getId());
        } else if (packet.getType() == EntityType.FISHING_BOBBER) {
            int ownerEntityId = ((ProjectileData)packet.getData()).getOwnerId();
            Entity owner = session.getEntityCache().getEntityByJavaId(ownerEntityId);
            if (!(owner instanceof PlayerEntity)) return;
            FishingHookEntity fishingHookEntity = new FishingHookEntity(context, (PlayerEntity)owner);
        } else {
            Object t = definition.factory().create(context);
            if (t instanceof HangingEntity) {
                HangingEntity hanging = (HangingEntity)t;
                hanging.setDirection((Direction)packet.getData());
            }
        }
        if (packet.getType() == EntityType.WARDEN && (wardenData = (WardenData)packet.getData()).isEmerging()) {
            var10_16.setPose(Pose.EMERGING);
        }
        session.getEntityCache().spawnEntity((Entity)var10_16);
    }
}

