/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;

public abstract class BaseInventoryTranslator<Type extends Container>
extends InventoryTranslator<Type> {
    public BaseInventoryTranslator(int size) {
        super(size);
    }

    @Override
    public void updateProperty(GeyserSession session, Type container, int key, int value) {
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        int slotnum = slotInfoData.getSlot();
        switch (slotInfoData.getContainerName().getContainer()) {
            case HOTBAR_AND_INVENTORY: 
            case HOTBAR: 
            case INVENTORY: {
                if (slotnum >= 9) {
                    return slotnum + this.size - 9;
                }
                return slotnum + this.size + 27;
            }
        }
        return slotnum;
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        if (slot >= this.size) {
            int tmp = slot - this.size;
            if (tmp < 27) {
                return tmp + 9;
            }
            return tmp - 27;
        }
        return slot;
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot, Type inventory) {
        if (slot >= this.size) {
            int tmp = slot - this.size;
            if (tmp < 27) {
                return new BedrockContainerSlot(ContainerSlotType.INVENTORY, tmp + 9);
            }
            return new BedrockContainerSlot(ContainerSlotType.HOTBAR, tmp - 27);
        }
        throw new IllegalArgumentException("Unknown bedrock slot");
    }

    @Override
    public SlotType getSlotType(int javaSlot) {
        return SlotType.NORMAL;
    }

    @Override
    public Type createInventory(GeyserSession session, String name, int windowId, ContainerType containerType) {
        return (Type)new Container(session, name, windowId, this.size, containerType);
    }
}

